/*
 * Decompiled with CFR 0.152.
 */
package fuzs.deathfinder.client;

import fuzs.deathfinder.client.handler.DeathCommandHandler;
import fuzs.deathfinder.client.handler.DeathScreenHandler;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.gui.screens.DeathScreen;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLConstructModEvent;

@Mod.EventBusSubscriber(modid="deathfinder", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class DeathFinderForgeClient {
    @SubscribeEvent
    public static void onConstructMod(FMLConstructModEvent evt) {
        DeathFinderForgeClient.registerHandlers();
    }

    private static void registerHandlers() {
        DeathScreenHandler deathScreenHandler = new DeathScreenHandler();
        MinecraftForge.EVENT_BUS.addListener(evt -> {
            if (evt.getScreen() instanceof DeathScreen) {
                deathScreenHandler.onDrawScreen(evt.getScreen(), evt.getPoseStack(), evt.getMouseX(), evt.getMouseY(), evt.getPartialTick());
            }
        });
        MinecraftForge.EVENT_BUS.addListener(evt -> {
            boolean result = deathScreenHandler.onScreenOpen(evt.getNewScreen());
            if (!result) {
                evt.setCanceled(true);
            }
        });
        DeathCommandHandler deathCommandHandler = new DeathCommandHandler();
        MinecraftForge.EVENT_BUS.addListener(evt -> {
            boolean result;
            if (evt.getScreen() instanceof ChatScreen && !(result = deathCommandHandler.onMouseClicked(evt.getScreen(), evt.getMouseX(), evt.getMouseY(), evt.getButton()))) {
                evt.setCanceled(true);
            }
        });
    }
}

