/*
 * Decompiled with CFR 0.152.
 */
package fuzs.deathfinder.config;

import fuzs.puzzleslib.config.ConfigCore;
import fuzs.puzzleslib.config.annotation.Config;
import fuzs.puzzleslib.config.serialization.EntryCollectionBuilder;
import java.util.List;
import java.util.Set;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EntityType;

public class ServerConfig
implements ConfigCore {
    @Config(name="death_message_components")
    public ComponentsConfig components = new ComponentsConfig();
    @Config(name="death_messages")
    public MessagesConfig messages = new MessagesConfig();

    public static class ComponentsConfig
    implements ConfigCore {
        @Config(description={"Add position component to death messages."})
        public boolean positionComponent = true;
        @Config(description={"Add dimension component to death messages."})
        public boolean dimensionComponent = true;
        @Config(description={"Add distance component to death messages."})
        public boolean distanceComponent = true;
        @Config(description={"Who should be allowed to click the position component to teleport there.", "Normal player can only teleport to their own death position once in a given time frame, if enabled.", "Operators can teleport to any death position without limitations, if enabled."})
        public TeleportRestriction allowTeleporting = TeleportRestriction.OPERATORS_ONLY;
        @Config(description={"Amount of seconds in which teleporting to the last death point is possible.", "Set to -1 to remove time limit."})
        @Config.IntRange(min=-1)
        public int teleportInterval = 300;
    }

    public static class MessagesConfig
    implements ConfigCore {
        @Config(description={"Show death message for players."})
        public boolean playerDeaths = true;
        @Config(description={"Show death message for tamed entities."})
        public boolean petDeaths = true;
        @Config(description={"Show death message for villagers."})
        public boolean villagerDeaths = true;
        @Config(description={"Show death message for named entities."})
        public boolean namedEntityDeaths = true;
        @Config(description={"Show death message for all entities."})
        public boolean allDeaths = false;
        @Config(name="death_message_blacklist", description={"Entities to be excluded when \"all_deaths\" is enabled.", "Format for every entry is \"<namespace>:<path>\". Path may use asterisk as wildcard parameter. Tags are not supported."})
        List<String> deathMessageBlacklistRaw = EntryCollectionBuilder.getKeyList((ResourceKey)Registry.f_122903_, (Object[])new EntityType[]{EntityType.f_20549_, EntityType.f_147034_});
        @Config(name="death_message_whitelist", description={"The only entities to be included when \"all_deaths\" is enabled. Takes precedence over blacklist.", "Format for every entry is \"<namespace>:<path>\". Path may use asterisk as wildcard parameter. Tags are not supported."})
        List<String> deathMessageWhitelistRaw = EntryCollectionBuilder.getKeyList((ResourceKey)Registry.f_122903_, (Object[])new EntityType[0]);
        public Set<EntityType<?>> deathMessageBlacklist;
        public Set<EntityType<?>> deathMessageWhitelist;

        public void afterConfigReload() {
            this.deathMessageBlacklist = EntryCollectionBuilder.of((ResourceKey)Registry.f_122903_).buildSet(this.deathMessageBlacklistRaw);
            this.deathMessageWhitelist = EntryCollectionBuilder.of((ResourceKey)Registry.f_122903_).buildSet(this.deathMessageWhitelistRaw);
        }
    }

    public static enum TeleportRestriction {
        NO_ONE,
        OPERATORS_ONLY,
        EVERYONE;

    }
}

