/*
 * Decompiled with CFR 0.152.
 */
package fuzs.deathfinder.handler;

import fuzs.deathfinder.DeathFinder;
import fuzs.deathfinder.config.ServerConfig;
import fuzs.deathfinder.network.S2CAdvancedSystemChatMessage;
import fuzs.deathfinder.util.DeathMessageBuilder;
import fuzs.deathfinder.util.DeathMessageSender;
import fuzs.puzzleslib.network.Message;
import java.util.function.BooleanSupplier;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.network.PacketSendListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundPlayerCombatKillPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.scores.Team;

public class DeathMessageHandler {
    public void onLivingDeath(LivingEntity entity, DamageSource source) {
        if (entity.f_19853_.f_46443_ || !entity.f_19853_.m_46469_().m_46207_(GameRules.f_46142_)) {
            return;
        }
        block5: for (DeathMessageSource deathSource : DeathMessageSource.values()) {
            if (!deathSource.test(entity)) continue;
            DeathMessageBuilder builder = DeathMessageBuilder.from(entity).withPosition(((ServerConfig)DeathFinder.CONFIG.get(ServerConfig.class)).components.positionComponent).withDimension(((ServerConfig)DeathFinder.CONFIG.get(ServerConfig.class)).components.dimensionComponent).withDistance(((ServerConfig)DeathFinder.CONFIG.get(ServerConfig.class)).components.distanceComponent);
            switch (deathSource) {
                case PLAYER: {
                    this.handlePlayer((ServerPlayer)entity, builder, DeathMessageSender.from(entity.m_20194_()));
                    break;
                }
                case PET: {
                    LivingEntity livingEntity = ((TamableAnimal)entity).m_21826_();
                    if (!(livingEntity instanceof ServerPlayer)) break block5;
                    ServerPlayer player = (ServerPlayer)livingEntity;
                    DeathFinder.NETWORK.sendTo((Message)new S2CAdvancedSystemChatMessage(builder.build((Player)player), false), player);
                    break;
                }
                case VILLAGER: {
                    DeathMessageSender.from(entity.m_20194_()).sendToAll(builder, false);
                    break;
                }
                default: {
                    DeathMessageSender.from(entity.m_20194_()).sendToAll(builder);
                    break;
                }
            }
            break;
        }
    }

    private void handlePlayer(ServerPlayer player, DeathMessageBuilder builder, DeathMessageSender sender) {
        Component component = player.m_21231_().m_19293_();
        player.f_8906_.m_243119_((Packet)new ClientboundPlayerCombatKillPacket(player.m_21231_(), component), PacketSendListener.m_243073_(() -> {
            String s = component.m_130668_(256);
            MutableComponent component1 = Component.m_237110_((String)"death.attack.message_too_long", (Object[])new Object[]{Component.m_237113_((String)s).m_130940_(ChatFormatting.YELLOW)});
            MutableComponent component2 = Component.m_237110_((String)"death.attack.even_more_magic", (Object[])new Object[]{player.m_5446_()}).m_130938_(arg_0 -> DeathMessageHandler.lambda$handlePlayer$0((Component)component1, arg_0));
            return new ClientboundPlayerCombatKillPacket(player.m_21231_(), (Component)component2);
        }));
        Team team = player.m_5647_();
        if (team != null && team.m_7468_() != Team.Visibility.ALWAYS) {
            if (team.m_7468_() == Team.Visibility.HIDE_FOR_OTHER_TEAMS) {
                sender.sendMessageToAllTeamMembers((Player)player, builder);
            } else if (team.m_7468_() == Team.Visibility.HIDE_FOR_OWN_TEAM) {
                sender.sendMessageToTeamOrAllPlayers((Player)player, builder);
            }
        } else {
            sender.sendToAll(builder);
        }
    }

    private static boolean isAllowed(EntityType<?> type) {
        if (((ServerConfig)DeathFinder.CONFIG.get(ServerConfig.class)).messages.deathMessageWhitelist.contains(type)) {
            return true;
        }
        return !((ServerConfig)DeathFinder.CONFIG.get(ServerConfig.class)).messages.deathMessageBlacklist.contains(type);
    }

    private static /* synthetic */ Style lambda$handlePlayer$0(Component component1, Style p_143420_) {
        return p_143420_.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)component1));
    }

    private static enum DeathMessageSource {
        PLAYER(() -> ((ServerConfig)DeathFinder.CONFIG.get(ServerConfig.class)).messages.allDeaths || ((ServerConfig)DeathFinder.CONFIG.get(ServerConfig.class)).messages.playerDeaths, entity -> entity instanceof ServerPlayer && !entity.m_5833_()),
        ALL(() -> ((ServerConfig)DeathFinder.CONFIG.get(ServerConfig.class)).messages.allDeaths, entity -> DeathMessageHandler.isAllowed(entity.m_6095_())),
        NAMED(() -> ((ServerConfig)DeathFinder.CONFIG.get(ServerConfig.class)).messages.namedEntityDeaths, Entity::m_8077_),
        VILLAGER(() -> ((ServerConfig)DeathFinder.CONFIG.get(ServerConfig.class)).messages.villagerDeaths, entity -> entity instanceof Villager),
        PET(() -> ((ServerConfig)DeathFinder.CONFIG.get(ServerConfig.class)).messages.petDeaths, entity -> {
            TamableAnimal animal;
            return entity instanceof TamableAnimal && (animal = (TamableAnimal)entity).m_21826_() instanceof ServerPlayer;
        });

        private final BooleanSupplier config;
        private final Predicate<LivingEntity> predicate;

        private DeathMessageSource(BooleanSupplier config, Predicate<LivingEntity> predicate) {
            this.config = config;
            this.predicate = predicate;
        }

        public boolean test(LivingEntity entity) {
            return this.config.getAsBoolean() && this.predicate.test(entity);
        }
    }
}

