/*
 * Decompiled with CFR 0.152.
 */
package fuzs.deathfinder.network.chat;

import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Either;
import fuzs.deathfinder.DeathFinder;
import fuzs.deathfinder.capability.PlayerDeathTracker;
import fuzs.deathfinder.config.ServerConfig;
import fuzs.deathfinder.network.chat.AdvancedClickEvent;
import fuzs.deathfinder.network.chat.TeleportToDeathProblem;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Unit;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class TeleportClickEvent
extends AdvancedClickEvent {
    private UUID uuid;
    private ResourceKey<Level> dimension;
    private int x;
    private int y;
    private int z;

    public TeleportClickEvent(UUID uuid, ResourceKey<Level> dimension, int x, int y, int z) {
        super(ClickEvent.Action.SUGGEST_COMMAND, TeleportClickEvent.makeCommand(dimension, x, y, z));
        this.uuid = uuid;
        this.dimension = dimension;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public TeleportClickEvent(ClickEvent.Action action, String string) {
        super(action, string);
    }

    public Either<TeleportToDeathProblem, Unit> acceptsTracker(Player player, PlayerDeathTracker tracker) {
        if (!player.m_20148_().equals(this.uuid)) {
            return Either.left((Object)((Object)TeleportToDeathProblem.NOT_YOURS));
        }
        return tracker.isValid(this.dimension, new BlockPos(this.x, this.y, this.z), ((ServerConfig)DeathFinder.CONFIG.get(ServerConfig.class)).components.teleportInterval);
    }

    @Override
    public void serialize(JsonObject jsonObject) {
        super.serialize(jsonObject);
        jsonObject.addProperty("uuid", this.uuid.toString());
        jsonObject.addProperty("dimension", this.dimension.m_135782_().toString());
        jsonObject.addProperty("x", (Number)this.x);
        jsonObject.addProperty("y", (Number)this.y);
        jsonObject.addProperty("z", (Number)this.z);
    }

    @Override
    public void deserialize(JsonObject jsonObject) {
        String string2;
        String string = GsonHelper.m_13851_((JsonObject)jsonObject, (String)"uuid", null);
        if (string != null) {
            this.uuid = UUID.fromString(string);
        }
        if ((string2 = GsonHelper.m_13851_((JsonObject)jsonObject, (String)"dimension", null)) != null) {
            this.dimension = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)ResourceLocation.m_135820_((String)string2));
        }
        this.x = GsonHelper.m_13824_((JsonObject)jsonObject, (String)"x", (int)0);
        this.y = GsonHelper.m_13824_((JsonObject)jsonObject, (String)"y", (int)0);
        this.z = GsonHelper.m_13824_((JsonObject)jsonObject, (String)"z", (int)0);
    }

    private static String makeCommand(ResourceKey<Level> dimension, int x, int y, int z) {
        return String.format("/execute in %s run tp @s %s %s %s", dimension.m_135782_(), x, y, z);
    }
}

