/*
 * Decompiled with CFR 0.152.
 */
package net.bettercombat.mixin.client.firstpersonrender;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Optional;
import net.bettercombat.client.animation.first_person.FirstPersonAnimator;
import net.bettercombat.client.animation.first_person.FirstPersonRenderHelper;
import net.bettercombat.compatibility.CompatibilityFlags;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LevelRenderer.class})
public abstract class WorldRendererMixin {
    @Redirect(method={"render"}, at=@At(ordinal=0, value="INVOKE", target="Lnet/minecraft/client/render/Camera;isThirdPerson()Z"))
    private boolean renderInFirstPerson(Camera instance) {
        if (!CompatibilityFlags.firstPersonRender() || Minecraft.m_91087_().f_91074_.m_5803_()) {
            return instance.m_90594_();
        }
        return true;
    }

    @Inject(method={"renderEntity"}, at={@At(value="HEAD")}, cancellable=true)
    private void dontRenderEntity_Begin(Entity entity, double cameraX, double cameraY, double cameraZ, float tickDelta, PoseStack matrices, MultiBufferSource vertexConsumers, CallbackInfo ci) {
        Optional<Object> currentAnimation;
        Player player;
        if (!CompatibilityFlags.firstPersonRender()) {
            return;
        }
        if (entity instanceof Player && (player = (Player)entity).m_5803_()) {
            return;
        }
        if (entity instanceof FirstPersonAnimator) {
            FirstPersonAnimator animator = (FirstPersonAnimator)entity;
            currentAnimation = animator.getActiveFirstPersonAnimation(tickDelta);
        } else {
            currentAnimation = Optional.empty();
        }
        Camera camera = Minecraft.m_91087_().f_91063_.m_109153_();
        if (entity == camera.m_90592_() && !camera.m_90594_()) {
            if (currentAnimation.isPresent()) {
                FirstPersonRenderHelper.isRenderingFirstPersonPlayerModel = true;
                return;
            }
        } else {
            return;
        }
        ci.cancel();
    }

    @Inject(method={"renderEntity"}, at={@At(value="TAIL")}, cancellable=true)
    private void dontRenderEntity_End(Entity entity, double cameraX, double cameraY, double cameraZ, float tickDelta, PoseStack matrices, MultiBufferSource vertexConsumers, CallbackInfo ci) {
        Camera camera = Minecraft.m_91087_().f_91063_.m_109153_();
        if (entity == camera.m_90592_()) {
            FirstPersonRenderHelper.isRenderingFirstPersonPlayerModel = false;
        }
    }
}

