/*
 * Decompiled with CFR 0.152.
 */
package net.bettercombat.tinyconfig;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.bettercombat.tinyconfig.PlatformHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigManager<Config> {
    static final Logger LOGGER = LoggerFactory.getLogger((String)"tiny-config");
    public Config value;
    public String configName;
    public String directory;
    public boolean isLoggingEnabled = false;
    public boolean sanitize = false;

    public ConfigManager(String configName, Config defaultConfig) {
        this.configName = configName;
        this.value = defaultConfig;
    }

    public void refresh() {
        Path filePath = this.getConfigFilePath();
        this.load();
        if (this.sanitize || !Files.exists(filePath, new LinkOption[0])) {
            this.save();
        }
    }

    public void load() {
        block3: {
            Path filePath = this.getConfigFilePath();
            try {
                Gson gson = new Gson();
                if (Files.exists(filePath, new LinkOption[0])) {
                    BufferedReader reader = Files.newBufferedReader(filePath);
                    this.value = gson.fromJson((Reader)reader, this.value.getClass());
                    ((Reader)reader).close();
                }
            }
            catch (Exception e) {
                if (!this.isLoggingEnabled) break block3;
                LOGGER.error("Failed loading " + this.configName + " config: " + e.getMessage());
            }
        }
    }

    public void save() {
        block4: {
            Config config = this.value;
            Path filePath = this.getConfigFilePath();
            Path configDir = PlatformHelper.getConfigDir();
            try {
                if (this.directory != null && !this.directory.isEmpty()) {
                    Path directoryPath = configDir.resolve(this.directory);
                    Files.createDirectories(directoryPath, new FileAttribute[0]);
                }
                Gson prettyGson = new GsonBuilder().setPrettyPrinting().create();
                BufferedWriter writer = Files.newBufferedWriter(filePath, new OpenOption[0]);
                writer.write(prettyGson.toJson(config));
                ((Writer)writer).close();
                if (this.isLoggingEnabled) {
                    Gson gson = new Gson();
                    LOGGER.info(this.configName + " config written: " + gson.toJson(config));
                }
            }
            catch (Exception e) {
                if (!this.isLoggingEnabled) break block4;
                LOGGER.error("Failed writing " + this.configName + " config: " + e.getMessage());
            }
        }
    }

    private Path getConfigFilePath() {
        String configFilePath = this.configName + ".json";
        if (this.directory != null && !this.directory.isEmpty()) {
            configFilePath = this.directory + "/" + configFilePath;
        }
        Path configDir = PlatformHelper.getConfigDir();
        return configDir.resolve(configFilePath);
    }

    public Builder builder() {
        return new Builder(this);
    }

    public class Builder {
        ConfigManager<Config> manager;

        Builder(ConfigManager<Config> manager) {
            this.manager = manager;
        }

        public Builder enableLogging(boolean enable) {
            this.manager.isLoggingEnabled = enable;
            return this;
        }

        public Builder setDirectory(String directory) {
            this.manager.directory = directory;
            return this;
        }

        public Builder sanitize(boolean sanitize) {
            this.manager.sanitize = sanitize;
            return this;
        }

        public ConfigManager<Config> build() {
            return this.manager;
        }
    }
}

