/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.backend.instancing;

import com.jozufozu.flywheel.backend.instancing.DrawBuffer;
import com.jozufozu.flywheel.backend.instancing.RenderTypeExtension;
import com.jozufozu.flywheel.backend.model.BufferBuilderExtension;
import com.jozufozu.flywheel.backend.model.DirectVertexConsumer;
import com.mojang.blaze3d.vertex.BufferBuilder;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.client.renderer.RenderType;

public class BatchDrawingTracker {
    protected final Set<RenderType> activeTypes = new HashSet<RenderType>();
    private final BufferBuilder scratch = new BufferBuilder(8);

    public BatchDrawingTracker() {
        ((BufferBuilderExtension)this.scratch).flywheel$freeBuffer();
    }

    public DirectVertexConsumer getDirectConsumer(RenderType renderType, int vertexCount) {
        this.activeTypes.add(renderType);
        return RenderTypeExtension.getDrawBuffer(renderType).begin(vertexCount);
    }

    public void endBatch() {
        for (RenderType renderType : this.activeTypes) {
            this._draw(renderType);
        }
        this.activeTypes.clear();
    }

    public void endBatch(RenderType renderType) {
        this._draw(renderType);
        this.activeTypes.remove(renderType);
    }

    public void clear() {
        for (RenderType type : this.activeTypes) {
            RenderTypeExtension.getDrawBuffer(type).reset();
        }
        this.activeTypes.clear();
    }

    private void _draw(RenderType renderType) {
        DrawBuffer drawBuffer = RenderTypeExtension.getDrawBuffer(renderType);
        BufferBuilderExtension scratch = (BufferBuilderExtension)this.scratch;
        if (drawBuffer.hasVertices()) {
            drawBuffer.inject(scratch);
            renderType.m_110412_(this.scratch, 0, 0, 0);
            drawBuffer.reset();
        }
    }
}

