/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.core;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.event.ModelEvent;

public class PartialModel {
    private static final List<PartialModel> ALL = new ArrayList<PartialModel>();
    private static boolean tooLate = false;
    protected final ResourceLocation modelLocation;
    protected BakedModel bakedModel;

    public PartialModel(ResourceLocation modelLocation) {
        if (tooLate) {
            throw new RuntimeException("PartialModel '" + modelLocation + "' loaded after ModelEvent.RegisterAdditional");
        }
        this.modelLocation = modelLocation;
        ALL.add(this);
    }

    public static void onModelRegistry(ModelEvent.RegisterAdditional event) {
        for (PartialModel partial : ALL) {
            event.register(partial.getLocation());
        }
        tooLate = true;
    }

    public static void onModelBake(ModelEvent.BakingCompleted event) {
        Map models = event.getModels();
        for (PartialModel partial : ALL) {
            partial.set((BakedModel)models.get(partial.getLocation()));
        }
    }

    protected void set(BakedModel bakedModel) {
        this.bakedModel = bakedModel;
    }

    public ResourceLocation getLocation() {
        return this.modelLocation;
    }

    public BakedModel get() {
        return this.bakedModel;
    }
}

