/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.movingelevators.elevator;

import com.supermartijn642.core.network.BasePacket;
import com.supermartijn642.movingelevators.MovingElevators;
import com.supermartijn642.movingelevators.MovingElevatorsConfig;
import com.supermartijn642.movingelevators.blocks.ControllerBlockEntity;
import com.supermartijn642.movingelevators.elevator.ElevatorCage;
import com.supermartijn642.movingelevators.elevator.ElevatorCollisionHandler;
import com.supermartijn642.movingelevators.elevator.ElevatorGroupCapability;
import com.supermartijn642.movingelevators.packets.PacketSyncElevatorMovement;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ElevatorGroup {
    private static final int RE_SYNC_INTERVAL = 10;
    private static final double ACCELERATION = 0.05;
    public final Level level;
    public final int x;
    public final int z;
    public final Direction facing;
    private boolean isMoving = false;
    private int targetY;
    private double lastY;
    private double currentY;
    private double syncCurrentY = 2.147483647E9;
    private double targetSpeed = 0.2;
    private double speed = 0.0;
    private int cageSideOffset = 0;
    private int cageDepthOffset = 0;
    private int cageHeightOffset = -1;
    private int cageSizeX = 3;
    private int cageSizeY = 4;
    private int cageSizeZ = 3;
    private ElevatorCage cage = null;
    private final ArrayList<Integer> floors = new ArrayList();
    private final ArrayList<FloorData> floorData = new ArrayList();
    private boolean shouldBeSynced = false;
    private Map<Integer, Set<BlockPos>> comparatorListeners = new Int2ObjectArrayMap();
    private int syncCounter = 0;

    public ElevatorGroup(Level level, int x, int z, Direction facing) {
        this.level = level;
        this.x = x;
        this.z = z;
        this.facing = facing;
    }

    public void update() {
        if (!this.level.f_46443_ && this.shouldBeSynced) {
            this.shouldBeSynced = false;
            this.updateGroup();
        }
        if (this.isMoving) {
            if (this.currentY != (double)this.targetY) {
                this.lastY = this.currentY;
            }
            if (this.speed < this.targetSpeed) {
                this.speed = Math.min(this.targetSpeed, this.speed + 0.05);
            }
            if (this.currentY == (double)this.targetY) {
                this.stopElevator();
            } else if (Math.abs((double)this.targetY - this.currentY) < this.speed) {
                this.currentY = this.targetY;
                this.moveElevator(this.lastY, this.currentY);
            } else {
                if (this.syncCurrentY != 2.147483647E9) {
                    this.currentY = this.syncCurrentY;
                    this.syncCurrentY = 2.147483647E9;
                } else {
                    this.currentY += Math.signum((double)this.targetY - this.currentY) * this.speed;
                }
                this.moveElevator(this.lastY, this.currentY);
            }
            if (this.syncCounter >= 10) {
                this.syncMovement();
                this.syncCounter = 0;
            }
            ++this.syncCounter;
        }
    }

    private void moveElevator(double oldY, double newY) {
        ElevatorCollisionHandler.handleEntityCollisions(this.level, this.cage.bounds, this.cage.collisionBoxes, this.getCageAnchorPos(oldY), new Vec3((double)this.x, newY - oldY, 0.0));
    }

    private void stopElevator() {
        this.isMoving = false;
        this.cage.place(this.level, this.getCageAnchorBlockPos(this.targetY));
        this.moveElevator(this.lastY, this.currentY);
        if (!this.level.f_46443_) {
            this.level.m_46717_(this.getPos(this.targetY), (Block)MovingElevators.elevator_block);
            for (BlockPos pos : this.comparatorListeners.getOrDefault(this.targetY, Collections.emptySet())) {
                if (!this.level.m_46749_(pos)) continue;
                this.level.m_46717_(pos, this.level.m_8055_(pos).m_60734_());
            }
            this.shouldBeSynced = true;
            Vec3 soundPos = this.getCageAnchorPos(this.targetY).m_82520_((double)this.cageSizeX / 2.0, (double)this.cageSizeY / 2.0, (double)this.cageSizeZ / 2.0);
            this.level.m_6263_(null, soundPos.f_82479_, soundPos.f_82480_, soundPos.f_82481_, SoundEvents.f_11871_, SoundSource.BLOCKS, 0.4f, 0.5f);
            this.syncCounter = 0;
        }
    }

    private void startElevator(int currentY, int targetY) {
        if (this.level == null || this.isMoving) {
            return;
        }
        ElevatorCage cage = ElevatorCage.createCageAndClear(this.level, this.getCageAnchorBlockPos(currentY), this.cageSizeX, this.cageSizeY, this.cageSizeZ);
        if (cage == null) {
            return;
        }
        this.cage = cage;
        this.isMoving = true;
        this.targetY = targetY;
        this.lastY = this.currentY = (double)currentY;
        this.speed = 0.0;
        if (!this.level.f_46443_) {
            this.level.m_46717_(this.getPos(currentY), (Block)MovingElevators.elevator_block);
            for (BlockPos pos : this.comparatorListeners.getOrDefault(currentY, Collections.emptySet())) {
                if (!this.level.m_46749_(pos)) continue;
                this.level.m_46717_(pos, this.level.m_8055_(pos).m_60734_());
            }
            this.updateGroup();
        }
    }

    public void onButtonPress(boolean isUp, boolean isDown, int yLevel) {
        if (this.isMoving || !this.floors.contains(yLevel)) {
            return;
        }
        ControllerBlockEntity entity = this.getEntity(yLevel);
        if (entity == null) {
            return;
        }
        if (isUp) {
            if (this.isCageAvailableAt(entity)) {
                for (int floor = this.floors.indexOf(yLevel) + 1; floor < this.floors.size(); ++floor) {
                    ControllerBlockEntity entity2 = this.getEntity(this.floors.get(floor));
                    if (entity2 == null) continue;
                    if (this.canCageBePlacedAt(entity2)) {
                        this.startElevator(yLevel, this.floors.get(floor));
                    }
                    return;
                }
            }
        } else if (isDown) {
            if (this.isCageAvailableAt(entity)) {
                for (int floor = this.floors.indexOf(yLevel) - 1; floor >= 0; --floor) {
                    ControllerBlockEntity entity2 = this.getEntity(this.floors.get(floor));
                    if (entity2 == null) continue;
                    if (this.canCageBePlacedAt(entity2)) {
                        this.startElevator(yLevel, this.floors.get(floor));
                    }
                    return;
                }
            }
        } else if (this.canCageBePlacedAt(entity)) {
            this.floors.sort(Comparator.comparingInt(a -> Math.abs(a - yLevel)));
            for (int y : this.floors) {
                ControllerBlockEntity entity2;
                if (y == yLevel || (entity2 = this.getEntity(y)) == null || !this.isCageAvailableAt(entity2)) continue;
                this.floors.sort(Integer::compare);
                this.startElevator(y, yLevel);
                return;
            }
            this.floors.sort(Integer::compare);
        }
    }

    public void onDisplayPress(int yLevel, int floorOffset) {
        if (this.isMoving || !this.floors.contains(yLevel)) {
            return;
        }
        int floor = this.floors.indexOf(yLevel);
        if (floorOffset == 0) {
            this.onButtonPress(false, false, yLevel);
            return;
        }
        int toFloor = floor + floorOffset;
        if (toFloor < 0 || toFloor >= this.floors.size()) {
            return;
        }
        ControllerBlockEntity entity = this.getEntity(yLevel);
        int toY = this.floors.get(toFloor);
        ControllerBlockEntity toEntity = this.getEntity(toY);
        if (entity != null && toEntity != null && this.isCageAvailableAt(entity) && this.canCageBePlacedAt(toEntity)) {
            this.startElevator(yLevel, toY);
        }
    }

    public void remove(ControllerBlockEntity entity) {
        int floor = this.getFloorNumber(entity.m_58899_().m_123342_());
        this.floors.remove(floor);
        this.floorData.remove(floor);
        if (this.floors.isEmpty()) {
            if (this.isMoving) {
                Vec3 spawnPos = this.getCageAnchorPos(this.targetY).m_82520_((double)this.cageSizeX / 2.0, (double)this.cageSizeY / 2.0, (double)this.cageSizeZ / 2.0);
                BlockState[][][] blockStateArray = this.cage.blockStates;
                int n = blockStateArray.length;
                for (int i = 0; i < n; ++i) {
                    BlockState[][] arr;
                    BlockState[][] blockStateArray2 = arr = blockStateArray[i];
                    int n2 = blockStateArray2.length;
                    for (int j = 0; j < n2; ++j) {
                        BlockState[] arr2;
                        for (BlockState state : arr2 = blockStateArray2[j]) {
                            ItemEntity itemEntity = new ItemEntity(this.level, spawnPos.f_82479_, spawnPos.f_82480_, spawnPos.f_82481_, new ItemStack((ItemLike)state.m_60734_()));
                            this.level.m_7967_((Entity)itemEntity);
                        }
                    }
                }
            }
        } else {
            this.shouldBeSynced = true;
        }
    }

    public void add(ControllerBlockEntity entity) {
        if (entity == null) {
            return;
        }
        int y = entity.m_58899_().m_123342_();
        if (this.floors.contains(y)) {
            return;
        }
        FloorData floorData = new FloorData(entity.getFloorName(), entity.getDisplayLabelColor());
        for (int i = 0; i < this.floors.size(); ++i) {
            if (y >= this.floors.get(i)) continue;
            this.floors.add(i, y);
            this.floorData.add(i, floorData);
            break;
        }
        if (!this.floors.contains(y)) {
            this.floors.add(y);
            this.floorData.add(floorData);
        }
        this.shouldBeSynced = true;
    }

    public void updateFloorData(ControllerBlockEntity entity, String name, DyeColor color) {
        int floor = this.getFloorNumber(entity.m_58899_().m_123342_());
        if (floor == -1) {
            return;
        }
        FloorData data = this.floorData.get(floor);
        if (!Objects.equals(name, data.name) || color != data.color) {
            data.name = name;
            data.color = color;
            this.shouldBeSynced = true;
        }
    }

    public boolean isMoving() {
        return this.isMoving;
    }

    public double getLastY() {
        return this.lastY;
    }

    public double getCurrentY() {
        return this.currentY;
    }

    public void updateCurrentY(double y, double speed) {
        if (this.isMoving && (this.currentY < this.lastY ? y < this.currentY : y > this.currentY) && speed >= this.speed) {
            this.syncCurrentY = y;
            this.speed = speed;
        }
    }

    public ElevatorCage getCage() {
        return this.cage;
    }

    public double getTargetSpeed() {
        return this.targetSpeed;
    }

    public void setTargetSpeed(double targetSpeed) {
        this.targetSpeed = targetSpeed;
        this.shouldBeSynced = true;
    }

    public int getCageSideOffset() {
        return this.cageSideOffset;
    }

    public boolean canIncreaseCageSideOffset() {
        return !this.isMoving() && this.cageSideOffset < 2 + (this.facing == Direction.NORTH || this.facing == Direction.WEST ? (this.getCageWidth() - 1) / 2 : (int)Math.ceil((float)(this.getCageWidth() - 1) / 2.0f));
    }

    public void increaseCageSideOffset() {
        if (this.canIncreaseCageSideOffset()) {
            ++this.cageSideOffset;
            this.shouldBeSynced = true;
        }
    }

    public boolean canDecreaseCageSideOffset() {
        return !this.isMoving() && this.cageSideOffset > -2 - (this.facing == Direction.NORTH || this.facing == Direction.WEST ? (int)Math.ceil((float)(this.getCageWidth() - 1) / 2.0f) : (this.getCageWidth() - 1) / 2);
    }

    public void decreaseCageSideOffset() {
        if (this.canDecreaseCageSideOffset()) {
            --this.cageSideOffset;
            this.shouldBeSynced = true;
        }
    }

    public int getCageDepthOffset() {
        return this.cageDepthOffset;
    }

    public boolean canIncreaseCageDepthOffset() {
        return !this.isMoving() && this.cageDepthOffset < 2;
    }

    public void increaseCageDepthOffset() {
        if (this.canIncreaseCageDepthOffset()) {
            ++this.cageDepthOffset;
            this.shouldBeSynced = true;
        }
    }

    public boolean canDecreaseCageDepthOffset() {
        return !this.isMoving() && this.cageDepthOffset > 0;
    }

    public void decreaseCageDepthOffset() {
        if (this.canDecreaseCageDepthOffset()) {
            --this.cageDepthOffset;
            this.shouldBeSynced = true;
        }
    }

    public int getCageHeightOffset() {
        return this.cageHeightOffset;
    }

    public boolean canIncreaseCageHeightOffset() {
        return !this.isMoving() && this.cageHeightOffset < 3;
    }

    public void increaseCageHeightOffset() {
        if (this.canIncreaseCageHeightOffset()) {
            ++this.cageHeightOffset;
            this.shouldBeSynced = true;
        }
    }

    public boolean canDecreaseCageHeightOffset() {
        return !this.isMoving() && this.cageHeightOffset > -this.cageSizeY;
    }

    public void decreaseCageHeightOffset() {
        if (this.canDecreaseCageHeightOffset()) {
            --this.cageHeightOffset;
            this.shouldBeSynced = true;
        }
    }

    public int getCageWidth() {
        return this.facing.m_122434_() == Direction.Axis.X ? this.cageSizeZ : this.cageSizeX;
    }

    public boolean canIncreaseCageWidth() {
        return !this.isMoving && this.getCageWidth() < MovingElevatorsConfig.maxCabinHorizontalSize.get();
    }

    public void increaseCageWidth() {
        if (!this.isMoving && this.canIncreaseCageWidth()) {
            if (this.facing.m_122434_() == Direction.Axis.X) {
                ++this.cageSizeZ;
            } else {
                ++this.cageSizeX;
            }
            this.shouldBeSynced = true;
        }
    }

    public boolean canDecreaseCageWidth() {
        return !this.isMoving && this.getCageWidth() > 1;
    }

    public void decreaseCageWidth() {
        if (!this.isMoving && this.canDecreaseCageWidth()) {
            if (this.facing.m_122434_() == Direction.Axis.X) {
                --this.cageSizeZ;
            } else {
                --this.cageSizeX;
            }
            if (this.cageSideOffset > 2 + (this.facing == Direction.NORTH || this.facing == Direction.WEST ? (this.getCageWidth() - 1) / 2 : (int)Math.ceil((float)(this.getCageWidth() - 1) / 2.0f))) {
                this.cageSideOffset = 2 + (this.facing == Direction.NORTH || this.facing == Direction.WEST ? (this.getCageWidth() - 1) / 2 : (int)Math.ceil((float)(this.getCageWidth() - 1) / 2.0f));
            } else if (this.cageSideOffset < -2 - (this.facing == Direction.NORTH || this.facing == Direction.WEST ? (int)Math.ceil((float)(this.getCageWidth() - 1) / 2.0f) : (this.getCageWidth() - 1) / 2)) {
                this.cageSideOffset = -2 - (this.facing == Direction.NORTH || this.facing == Direction.WEST ? (int)Math.ceil((float)(this.getCageWidth() - 1) / 2.0f) : (this.getCageWidth() - 1) / 2);
            }
            this.shouldBeSynced = true;
        }
    }

    public int getCageDepth() {
        return this.facing.m_122434_() == Direction.Axis.X ? this.cageSizeX : this.cageSizeZ;
    }

    public boolean canIncreaseCageDepth() {
        return !this.isMoving && this.getCageDepth() < MovingElevatorsConfig.maxCabinHorizontalSize.get();
    }

    public void increaseCageDepth() {
        if (!this.isMoving && this.canIncreaseCageDepth()) {
            if (this.facing.m_122434_() == Direction.Axis.X) {
                ++this.cageSizeX;
            } else {
                ++this.cageSizeZ;
            }
            this.shouldBeSynced = true;
        }
    }

    public boolean canDecreaseCageDepth() {
        return !this.isMoving && this.getCageDepth() > 1;
    }

    public void decreaseCageDepth() {
        if (!this.isMoving && this.canDecreaseCageDepth()) {
            if (this.facing.m_122434_() == Direction.Axis.X) {
                --this.cageSizeX;
            } else {
                --this.cageSizeZ;
            }
            this.shouldBeSynced = true;
        }
    }

    public int getCageHeight() {
        return this.getCageSizeY();
    }

    public boolean canIncreaseCageHeight() {
        return !this.isMoving && this.cageSizeY < MovingElevatorsConfig.maxCabinVerticalSize.get();
    }

    public void increaseCageHeight() {
        if (!this.isMoving && this.canIncreaseCageHeight()) {
            ++this.cageSizeY;
            this.shouldBeSynced = true;
        }
    }

    public boolean canDecreaseCageHeight() {
        return !this.isMoving && this.cageSizeY > 1;
    }

    public void decreaseCageHeight() {
        if (!this.isMoving && this.canDecreaseCageHeight()) {
            --this.cageSizeY;
            if (this.cageHeightOffset < -this.cageSizeY) {
                this.cageHeightOffset = -this.cageSizeY;
            }
            this.shouldBeSynced = true;
        }
    }

    public int getCageSizeX() {
        return this.cageSizeX;
    }

    public int getCageSizeY() {
        return this.cageSizeY;
    }

    public int getCageSizeZ() {
        return this.cageSizeZ;
    }

    public DyeColor getFloorDisplayColor(int floor) {
        return this.floorData.get((int)floor).color;
    }

    public String getFloorDisplayName(int floor) {
        return this.floorData.get((int)floor).name;
    }

    public BlockPos getCageAnchorBlockPos(int y) {
        int x = 0;
        int z = 0;
        if (this.facing == Direction.NORTH) {
            x = this.x - this.cageSizeX / 2 - this.cageSideOffset;
            z = this.z - this.cageSizeZ - this.cageDepthOffset;
        } else if (this.facing == Direction.SOUTH) {
            x = this.x - this.cageSizeX / 2 + this.cageSideOffset;
            z = this.z + 1 + this.cageDepthOffset;
        } else if (this.facing == Direction.WEST) {
            x = this.x - this.cageSizeX - this.cageDepthOffset;
            z = this.z - this.cageSizeZ / 2 + this.cageSideOffset;
        } else if (this.facing == Direction.EAST) {
            x = this.x + 1 + this.cageDepthOffset;
            z = this.z - this.cageSizeZ / 2 - this.cageSideOffset;
        }
        return new BlockPos(x, y += this.cageHeightOffset, z);
    }

    public Vec3 getCageAnchorPos(double y) {
        BlockPos pos = this.getCageAnchorBlockPos(0);
        return new Vec3((double)pos.m_123341_(), y + (double)this.cageHeightOffset, (double)pos.m_123343_());
    }

    public boolean isCageAvailableAt(ControllerBlockEntity entity) {
        return ElevatorCage.canCreateCage(this.level, this.getCageAnchorBlockPos(entity.m_58899_().m_123342_()), this.cageSizeX, this.cageSizeY, this.cageSizeZ);
    }

    public boolean canCageBePlacedAt(ControllerBlockEntity entity) {
        BlockPos startPos = this.getCageAnchorBlockPos(entity.m_58899_().m_123342_());
        for (int x = 0; x < this.cageSizeX; ++x) {
            for (int y = 0; y < this.cageSizeY; ++y) {
                for (int z = 0; z < this.cageSizeZ; ++z) {
                    if (this.level.m_46859_(startPos.m_7918_(x, y, z))) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public void addComparatorListener(int floorYLevel, BlockPos blockPos) {
        this.comparatorListeners.putIfAbsent(floorYLevel, new HashSet());
        this.comparatorListeners.get(floorYLevel).add(blockPos);
    }

    public boolean removeComparatorListener(BlockPos blockPos) {
        boolean removed = false;
        Iterator<Set<BlockPos>> iterator = this.comparatorListeners.values().iterator();
        while (iterator.hasNext()) {
            Set<BlockPos> positions = iterator.next();
            if (!positions.remove(blockPos)) continue;
            removed = true;
            if (!positions.isEmpty()) continue;
            iterator.remove();
        }
        return removed;
    }

    public CompoundTag write() {
        CompoundTag compound = new CompoundTag();
        compound.m_128379_("isMoving", this.isMoving);
        if (this.isMoving) {
            compound.m_128405_("targetY", this.targetY);
            compound.m_128347_("lastY", this.lastY);
            compound.m_128347_("currentY", this.currentY);
            compound.m_128365_("cage", (Tag)this.cage.write());
        }
        compound.m_128347_("targetSpeed", this.targetSpeed);
        compound.m_128347_("speed", this.speed);
        compound.m_128405_("cageSideOffset", this.cageSideOffset);
        compound.m_128405_("cageDepthOffset", this.cageDepthOffset);
        compound.m_128405_("cageHeightOffset", this.cageHeightOffset);
        compound.m_128405_("cageSizeX", this.cageSizeX);
        compound.m_128405_("cageSizeY", this.cageSizeY);
        compound.m_128405_("cageSizeZ", this.cageSizeZ);
        compound.m_128408_("floors", this.floors);
        ListTag floorDataTag = new ListTag();
        for (FloorData floorDatum : this.floorData) {
            floorDataTag.add((Object)floorDatum.write());
        }
        compound.m_128365_("floorData", (Tag)floorDataTag);
        return compound;
    }

    public void read(CompoundTag compound) {
        if (compound.m_128441_("moving")) {
            this.isMoving = compound.m_128471_("moving");
            int size = compound.m_128451_("size");
            if (this.isMoving) {
                this.targetY = compound.m_128451_("targetY");
                this.lastY = compound.m_128459_("lastY");
                this.currentY = compound.m_128459_("currentY");
                BlockState[][][] blockStates = new BlockState[size][1][size];
                VoxelShape shape = Shapes.m_83040_();
                for (int x = 0; x < size; ++x) {
                    for (int z = 0; z < size; ++z) {
                        BlockState state = Block.m_49803_((int)compound.m_128451_("platform" + x + "," + z));
                        if (state.m_60734_() == Blocks.f_50016_) continue;
                        blockStates[x][0][z] = state;
                        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)state.m_60812_((BlockGetter)this.level, this.getPos((int)this.currentY)), (BooleanOp)BooleanOp.f_82695_);
                    }
                }
                shape.m_83296_();
                this.cage = new ElevatorCage(size, 1, size, blockStates, shape.m_83299_());
            }
            this.speed = this.targetSpeed = compound.m_128459_("speed");
            this.cageSizeX = this.cageSizeZ = size;
            this.cageSizeY = 1;
        } else {
            this.isMoving = compound.m_128471_("isMoving");
            if (this.isMoving) {
                this.targetY = compound.m_128451_("targetY");
                this.lastY = compound.m_128459_("lastY");
                this.currentY = compound.m_128459_("currentY");
                this.cage = ElevatorCage.read(compound.m_128469_("cage"));
            }
            this.targetSpeed = compound.m_128459_("targetSpeed");
            this.speed = compound.m_128459_("speed");
            this.cageSideOffset = compound.m_128451_("cageSideOffset");
            this.cageDepthOffset = compound.m_128451_("cageDepthOffset");
            this.cageHeightOffset = compound.m_128451_("cageHeightOffset");
            this.cageSizeX = compound.m_128451_("cageSizeX");
            this.cageSizeY = compound.m_128451_("cageSizeY");
            this.cageSizeZ = compound.m_128451_("cageSizeZ");
        }
        this.floors.clear();
        for (int y : compound.m_128465_("floors")) {
            this.floors.add(y);
        }
        this.floorData.clear();
        ListTag floorDataTag = (ListTag)compound.m_128423_("floorData");
        for (Tag data : floorDataTag) {
            this.floorData.add(FloorData.read((CompoundTag)data));
        }
    }

    private BlockPos getPos(int y) {
        return new BlockPos(this.x, y, this.z);
    }

    private ControllerBlockEntity getEntity(int y) {
        if (this.level == null) {
            return null;
        }
        BlockEntity entity = this.level.m_7702_(this.getPos(y));
        return entity instanceof ControllerBlockEntity ? (ControllerBlockEntity)entity : null;
    }

    public int getFloorCount() {
        return this.floors.size();
    }

    public int getFloorNumber(int y) {
        return this.floors.indexOf(y);
    }

    public int getFloorYLevel(int floor) {
        return this.floors.get(floor);
    }

    public ControllerBlockEntity getEntityForFloor(int floor) {
        if (floor < 0 || floor >= this.floors.size()) {
            return null;
        }
        return this.getEntity(this.floors.get(floor));
    }

    private void updateGroup() {
        this.level.getCapability(ElevatorGroupCapability.CAPABILITY).ifPresent(groups -> groups.updateGroup(this));
    }

    private void syncMovement() {
        if (!this.level.f_46443_) {
            MovingElevators.CHANNEL.sendToDimension(this.level.m_46472_(), (BasePacket)new PacketSyncElevatorMovement(this.x, this.z, this.facing, this.currentY, this.speed));
        }
    }

    private static class FloorData {
        public String name;
        public DyeColor color;

        public FloorData(String name, DyeColor color) {
            this.name = name;
            this.color = color;
        }

        public CompoundTag write() {
            CompoundTag tag = new CompoundTag();
            if (this.name != null) {
                tag.m_128359_("name", this.name);
            }
            tag.m_128405_("color", this.color.m_41060_());
            return tag;
        }

        public static FloorData read(CompoundTag tag) {
            return new FloorData(tag.m_128441_("name") ? tag.m_128461_("name") : null, DyeColor.m_41053_((int)tag.m_128451_("color")));
        }
    }
}

