/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.movingelevators.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.supermartijn642.core.ClientUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.ChunkRenderTypeSet;
import net.minecraftforge.client.model.IDynamicBakedModel;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.data.ModelProperty;
import org.jetbrains.annotations.NotNull;

public class CamoBakedModel
implements IDynamicBakedModel {
    public static final ModelProperty<BlockState> CAMO_PROPERTY = new ModelProperty();
    private final BakedModel originalModel;
    private List<BakedQuad> originalModelQuads;

    public CamoBakedModel(BakedModel originalModel) {
        this.originalModel = originalModel;
    }

    public List<BakedQuad> getQuads(BlockState state, Direction side, RandomSource random, ModelData modelData, RenderType renderType) {
        BlockState camouflage = (BlockState)modelData.get(CAMO_PROPERTY);
        if (camouflage == null || camouflage.m_60734_() == Blocks.f_50016_) {
            if (this.originalModelQuads == null) {
                this.originalModelQuads = CamoBakedModel.getAllQuads(this.originalModel, state, random, renderType);
            }
            return this.originalModelQuads;
        }
        BakedModel model = ClientUtils.getBlockRenderer().m_110910_(camouflage);
        return CamoBakedModel.getAllQuads(model, camouflage, random, renderType);
    }

    private static List<BakedQuad> getAllQuads(BakedModel model, BlockState state, RandomSource random, RenderType renderType) {
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        for (Direction direction : Direction.values()) {
            quads.addAll(model.getQuads(state, direction, random, ModelData.EMPTY, renderType));
        }
        quads.addAll(model.getQuads(state, null, random, ModelData.EMPTY, renderType));
        return quads;
    }

    public ModelData getModelData(BlockAndTintGetter level, BlockPos pos, BlockState state, ModelData entityData) {
        BlockEntity entity = level.m_7702_(pos);
        return entity == null ? ModelData.EMPTY : entity.getModelData();
    }

    public ChunkRenderTypeSet getRenderTypes(@NotNull BlockState state, @NotNull RandomSource rand, @NotNull ModelData data) {
        return ChunkRenderTypeSet.of((RenderType[])new RenderType[]{RenderType.m_110466_()});
    }

    public List<RenderType> getRenderTypes(ItemStack itemStack, boolean fabulous) {
        return Collections.singletonList(RenderType.m_110466_());
    }

    public boolean m_7541_() {
        return this.originalModel.m_7541_();
    }

    public boolean m_7539_() {
        return this.originalModel.m_7539_();
    }

    public boolean m_7547_() {
        return this.originalModel.m_7547_();
    }

    public boolean m_7521_() {
        return false;
    }

    public TextureAtlasSprite m_6160_() {
        return this.originalModel.m_6160_();
    }

    public ItemOverrides m_7343_() {
        return ItemOverrides.f_111734_;
    }

    public BakedModel applyTransform(ItemTransforms.TransformType transformType, PoseStack poseStack, boolean applyLeftHandTransform) {
        return this.originalModel.applyTransform(transformType, poseStack, applyLeftHandTransform);
    }
}

