/*
 * Decompiled with CFR 0.152.
 */
package nl.enjarai.doabarrelroll.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.serialization.Codec;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.network.chat.Component;
import nl.enjarai.doabarrelroll.api.net.SyncableConfig;
import nl.enjarai.doabarrelroll.config.SyncedModConfig;

public class SyncedModConfigServer
implements SyncableConfig<SyncedModConfigServer>,
SyncedModConfig {
    public static final Path CONFIG_FILE = FabricLoader.getInstance().getConfigDir().resolve("do_a_barrel_roll-server.json");
    public static SyncedModConfigServer INSTANCE;
    private static final Gson GSON;
    public boolean allowThrusting = true;
    public boolean forceEnabled = false;
    public boolean forceInstalled = false;
    public int installedTimeout = 20;

    public static void load() {
        INSTANCE = SyncedModConfigServer.loadConfigFile(CONFIG_FILE);
    }

    public void save() {
        this.saveConfigFile(CONFIG_FILE);
    }

    private static SyncedModConfigServer loadConfigFile(Path file) {
        SyncedModConfigServer config = null;
        if (Files.exists(file, new LinkOption[0])) {
            try (BufferedReader fileReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file.toFile()), StandardCharsets.UTF_8));){
                config = (SyncedModConfigServer)GSON.fromJson((Reader)fileReader, SyncedModConfigServer.class);
            }
            catch (IOException e) {
                throw new RuntimeException("Problem occurred when trying to load config: ", e);
            }
        }
        if (config == null) {
            config = new SyncedModConfigServer();
        }
        config.saveConfigFile(file);
        return config;
    }

    private void saveConfigFile(Path file) {
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file.toFile()), StandardCharsets.UTF_8);){
            GSON.toJson((Object)this, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public Integer getSyncTimeout() {
        return this.forceInstalled ? Integer.valueOf(this.installedTimeout) : null;
    }

    @Override
    public Component getSyncTimeoutMessage() {
        return Component.m_130674_((String)"Please install Do a Barrel Roll 2.4.0 or later to play on this server.");
    }

    @Override
    public Codec<? super SyncedModConfigServer> getTransferCodec() {
        return SyncedModConfig.TRANSFER_CODEC;
    }

    @Override
    public boolean allowThrusting() {
        return this.allowThrusting;
    }

    @Override
    public boolean forceEnabled() {
        return this.forceEnabled;
    }

    static {
        GSON = new GsonBuilder().setPrettyPrinting().serializeNulls().disableHtmlEscaping().create();
    }
}

