/*
 * Decompiled with CFR 0.152.
 */
package dev.limonblaze.originsclasses.common.apoli.power;

import dev.limonblaze.originsclasses.OriginsClasses;
import dev.limonblaze.originsclasses.common.apoli.configuration.MultiMineConfiguration;
import io.github.edwinmindcraft.apoli.api.IDynamicFeatureConfiguration;
import io.github.edwinmindcraft.apoli.api.component.IPowerContainer;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredBlockCondition;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredItemCondition;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredPower;
import io.github.edwinmindcraft.apoli.api.power.factory.PowerFactory;
import io.github.edwinmindcraft.apoli.api.registry.ApoliRegistries;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.IForgeRegistry;

public class MultiMinePower
extends PowerFactory<MultiMineConfiguration> {
    public final Range range;

    public MultiMinePower(Range range) {
        super(MultiMineConfiguration.CODEC);
        this.range = range;
    }

    public static boolean shouldApply(ConfiguredPower<?, ?> cp, Player player, BlockPos pos, BlockState state) {
        MultiMineConfiguration mmc;
        IDynamicFeatureConfiguration iDynamicFeatureConfiguration;
        return cp.isActive((Entity)player) && (iDynamicFeatureConfiguration = cp.getConfiguration()) instanceof MultiMineConfiguration && ConfiguredBlockCondition.check((mmc = (MultiMineConfiguration)iDynamicFeatureConfiguration).blockCondition(), (LevelReader)player.f_19853_, (BlockPos)pos, () -> state) && ConfiguredItemCondition.check(mmc.itemCondition(), (Level)player.f_19853_, (ItemStack)player.m_21205_());
    }

    public static List<BlockPos> apply(Player player, BlockPos pos, BlockState state) {
        List<ConfiguredPower> cmmps = ((IForgeRegistry)ApoliRegistries.POWER_FACTORY.get()).getValues().stream().filter(pf -> pf instanceof MultiMinePower).flatMap(pf -> IPowerContainer.getPowers((Entity)player, (PowerFactory)((MultiMinePower)((Object)pf))).stream()).map(Holder::get).filter(cp -> MultiMinePower.shouldApply(cp, player, pos, state)).toList();
        OriginsClasses.LOGGER.debug((Object)cmmps.size());
        for (ConfiguredPower cmmp : cmmps) {
            List<BlockPos> affectBlocks = ((MultiMinePower)cmmp.getFactory()).range.getAffectedBlocks(player, state, pos);
            if (affectBlocks.size() <= 0) continue;
            return affectBlocks;
        }
        return new ArrayList<BlockPos>();
    }

    @FunctionalInterface
    public static interface Range {
        public List<BlockPos> getAffectedBlocks(Player var1, BlockState var2, BlockPos var3);
    }
}

