/*
 * Decompiled with CFR 0.152.
 */
package fudge.notenoughcrashes.forge.platform;

import fudge.notenoughcrashes.NotEnoughCrashes;
import fudge.notenoughcrashes.platform.CommonModMetadata;
import fudge.notenoughcrashes.platform.ModsByLocation;
import fudge.notenoughcrashes.platform.NecPlatform;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.forgespi.language.IModFileInfo;
import net.minecraftforge.forgespi.language.IModInfo;
import org.jetbrains.annotations.Nullable;

public class ForgePlatform
implements NecPlatform {
    @Override
    public boolean isForge() {
        return true;
    }

    @Override
    public boolean isModLoaded(String modId) {
        return ModList.get().isLoaded(modId);
    }

    @Override
    public ModsByLocation getModsAtLocationsInDisk() {
        HashMap<Path, Set<CommonModMetadata>> modMap = new HashMap<Path, Set<CommonModMetadata>>();
        ModList mods = ModList.get();
        if (mods == null) {
            return new ModsByLocation(modMap);
        }
        for (IModFileInfo modFile : mods.getModFiles()) {
            Path modJar = modFile.getFile().getFilePath();
            for (IModInfo modInfo : modFile.getMods()) {
                modMap.computeIfAbsent(modJar, f -> new HashSet()).add(ForgePlatform.toCommon(modInfo));
            }
        }
        return new ModsByLocation(modMap);
    }

    @Override
    public Path getGameDirectory() {
        return FMLPaths.GAMEDIR.get();
    }

    @Override
    public Path getConfigDirectory() {
        return FMLPaths.CONFIGDIR.get();
    }

    @Override
    public boolean isDevelopmentEnvironment() {
        return !FMLLoader.isProduction();
    }

    @Override
    @Nullable
    public InputStream getResource(Path relativePath) {
        return NecPlatform.class.getResourceAsStream("/" + relativePath.toString());
    }

    @Override
    public List<CommonModMetadata> getModMetadatas(String modId) {
        IModFileInfo file = ModList.get().getModFileById(modId);
        if (file == null) {
            return Collections.emptyList();
        }
        return file.getMods().stream().map(ForgePlatform::toCommon).collect(Collectors.toList());
    }

    @Override
    public List<CommonModMetadata> getAllMods() {
        return ModList.get().getMods().stream().map(ForgePlatform::toCommon).collect(Collectors.toList());
    }

    @Override
    public boolean modContainsFile(CommonModMetadata mod, String path) {
        boolean bl;
        block9: {
            if (Files.isDirectory(mod.rootPath(), new LinkOption[0])) {
                return Files.exists(mod.rootPath().resolve(path), new LinkOption[0]);
            }
            FileSystem fs = FileSystems.newFileSystem(mod.rootPath());
            try {
                Path filePath = fs.getPath(path, new String[0]);
                bl = Files.exists(filePath, new LinkOption[0]);
                if (fs == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (fs != null) {
                        try {
                            fs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    NotEnoughCrashes.getLogger().error("Failed to open mod jar, assuming it doesn't contain file " + path, (Throwable)e);
                    return false;
                }
            }
            fs.close();
        }
        return bl;
    }

    private static CommonModMetadata toCommon(IModInfo imod) {
        Optional issueUrl = imod.getOwningFile().getConfig().getConfigElement(new String[]{"issueTrackerURL"});
        Object authorsObj = imod.getConfig().getConfigElement(new String[]{"authors"}).orElse(null);
        List<String> authors = authorsObj instanceof String ? Collections.singletonList(authorsObj) : (List<String>)authorsObj;
        return new CommonModMetadata(imod.getModId(), imod.getDisplayName(), issueUrl.orElse(null), authors, imod.getOwningFile().getFile().getFilePath());
    }
}

