/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions;

import com.simibubi.create.CreateClient;
import com.simibubi.create.content.contraptions.base.IRotate;
import com.simibubi.create.content.contraptions.base.KineticTileEntity;
import com.simibubi.create.content.contraptions.base.KineticTileEntityRenderer;
import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.utility.Color;
import com.simibubi.create.foundation.utility.VecHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

public class KineticDebugger {
    public static void tick() {
        if (!KineticDebugger.isActive()) {
            if (KineticTileEntityRenderer.rainbowMode) {
                KineticTileEntityRenderer.rainbowMode = false;
                CreateClient.BUFFER_CACHE.invalidate();
            }
            return;
        }
        KineticTileEntity te = KineticDebugger.getSelectedTE();
        if (te == null) {
            return;
        }
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        BlockPos toOutline = te.hasSource() ? te.source : te.m_58899_();
        BlockState state = te.m_58900_();
        VoxelShape shape = world.m_8055_(toOutline).m_60816_((BlockGetter)world, toOutline);
        if (te.getTheoreticalSpeed() != 0.0f && !shape.m_83281_()) {
            CreateClient.OUTLINER.chaseAABB("kineticSource", shape.m_83215_().m_82338_(toOutline)).lineWidth(0.0625f).colored(te.hasSource() ? Color.generateFromLong(te.network).getRGB() : 0xFFCC00);
        }
        if (state.m_60734_() instanceof IRotate) {
            Direction.Axis axis = ((IRotate)state.m_60734_()).getRotationAxis(state);
            Vec3 vec = Vec3.m_82528_((Vec3i)Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)axis).m_122436_());
            Vec3 center = VecHelper.getCenterOf((Vec3i)te.m_58899_());
            CreateClient.OUTLINER.showLine("rotationAxis", center.m_82549_(vec), center.m_82546_(vec)).lineWidth(0.0625f);
        }
    }

    public static boolean isActive() {
        return KineticDebugger.isF3DebugModeActive() && (Boolean)AllConfigs.CLIENT.rainbowDebug.get() != false;
    }

    public static boolean isF3DebugModeActive() {
        return Minecraft.m_91087_().f_91066_.f_92063_;
    }

    public static KineticTileEntity getSelectedTE() {
        HitResult obj = Minecraft.m_91087_().f_91077_;
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        if (obj == null) {
            return null;
        }
        if (world == null) {
            return null;
        }
        if (!(obj instanceof BlockHitResult)) {
            return null;
        }
        BlockHitResult ray = (BlockHitResult)obj;
        BlockEntity te = world.m_7702_(ray.m_82425_());
        if (!(te instanceof KineticTileEntity)) {
            return null;
        }
        return (KineticTileEntity)te;
    }
}

