/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.block.connected;

import com.simibubi.create.foundation.block.connected.CTSpriteShiftEntry;
import com.simibubi.create.foundation.block.connected.CTType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ConnectedTextureBehaviour {
    @Nullable
    public abstract CTSpriteShiftEntry getShift(BlockState var1, Direction var2, @NotNull TextureAtlasSprite var3);

    @Nullable
    public abstract CTType getDataType(BlockState var1, Direction var2);

    public boolean buildContextForOccludedDirections() {
        return false;
    }

    protected boolean isBeingBlocked(BlockState state, BlockAndTintGetter reader, BlockPos pos, BlockPos otherPos, Direction face) {
        BlockPos blockingPos = otherPos.m_121945_(face);
        return face.m_122434_().m_7863_(pos.m_123341_(), pos.m_123342_(), pos.m_123343_()) == face.m_122434_().m_7863_(otherPos.m_123341_(), otherPos.m_123342_(), otherPos.m_123343_()) && this.connectsTo(state, reader.m_8055_(blockingPos), reader, pos, blockingPos, face);
    }

    public boolean connectsTo(BlockState state, BlockState other, BlockAndTintGetter reader, BlockPos pos, BlockPos otherPos, Direction face, Direction primaryOffset, Direction secondaryOffset) {
        return this.connectsTo(state, other, reader, pos, otherPos, face);
    }

    public boolean connectsTo(BlockState state, BlockState other, BlockAndTintGetter reader, BlockPos pos, BlockPos otherPos, Direction face) {
        return !this.isBeingBlocked(state, reader, pos, otherPos, face) && state.m_60734_() == other.m_60734_();
    }

    private boolean testConnection(BlockAndTintGetter reader, BlockPos pos, BlockState state, Direction face, Direction horizontal, Direction vertical, int sh, int sv) {
        BlockPos p = pos.m_5484_(horizontal, sh).m_5484_(vertical, sv);
        boolean test = this.connectsTo(state, reader.m_8055_(p), reader, pos, p, face, sh == 0 ? null : (sh == -1 ? horizontal.m_122424_() : horizontal), sv == 0 ? null : (sv == -1 ? vertical.m_122424_() : vertical));
        return test;
    }

    protected boolean reverseUVs(BlockState state, Direction face) {
        return false;
    }

    protected boolean reverseUVsHorizontally(BlockState state, Direction face) {
        return this.reverseUVs(state, face);
    }

    protected boolean reverseUVsVertically(BlockState state, Direction face) {
        return this.reverseUVs(state, face);
    }

    protected Direction getUpDirection(BlockAndTintGetter reader, BlockPos pos, BlockState state, Direction face) {
        Direction.Axis axis = face.m_122434_();
        return axis.m_122479_() ? Direction.UP : Direction.NORTH;
    }

    protected Direction getRightDirection(BlockAndTintGetter reader, BlockPos pos, BlockState state, Direction face) {
        Direction.Axis axis = face.m_122434_();
        return axis == Direction.Axis.X ? Direction.SOUTH : Direction.WEST;
    }

    public CTContext buildContext(BlockAndTintGetter reader, BlockPos pos, BlockState state, Direction face, ContextRequirement requirement) {
        boolean positive = face.m_122421_() == Direction.AxisDirection.POSITIVE;
        Direction h = this.getRightDirection(reader, pos, state, face);
        Direction v = this.getUpDirection(reader, pos, state, face);
        Direction direction = h = positive ? h.m_122424_() : h;
        if (face == Direction.DOWN) {
            v = v.m_122424_();
            h = h.m_122424_();
        }
        Direction horizontal = h;
        Direction vertical = v;
        boolean flipH = this.reverseUVsHorizontally(state, face);
        boolean flipV = this.reverseUVsVertically(state, face);
        int sh = flipH ? -1 : 1;
        int sv = flipV ? -1 : 1;
        CTContext context = new CTContext();
        if (requirement.up) {
            context.up = this.testConnection(reader, pos, state, face, horizontal, vertical, 0, sv);
        }
        if (requirement.down) {
            context.down = this.testConnection(reader, pos, state, face, horizontal, vertical, 0, -sv);
        }
        if (requirement.left) {
            context.left = this.testConnection(reader, pos, state, face, horizontal, vertical, -sh, 0);
        }
        if (requirement.right) {
            context.right = this.testConnection(reader, pos, state, face, horizontal, vertical, sh, 0);
        }
        if (requirement.topLeft) {
            boolean bl = context.topLeft = context.up && context.left && this.testConnection(reader, pos, state, face, horizontal, vertical, -sh, sv);
        }
        if (requirement.topRight) {
            boolean bl = context.topRight = context.up && context.right && this.testConnection(reader, pos, state, face, horizontal, vertical, sh, sv);
        }
        if (requirement.bottomLeft) {
            boolean bl = context.bottomLeft = context.down && context.left && this.testConnection(reader, pos, state, face, horizontal, vertical, -sh, -sv);
        }
        if (requirement.bottomRight) {
            context.bottomRight = context.down && context.right && this.testConnection(reader, pos, state, face, horizontal, vertical, sh, -sv);
        }
        return context;
    }

    public static class CTContext {
        public static final CTContext EMPTY = new CTContext();
        public boolean up;
        public boolean down;
        public boolean left;
        public boolean right;
        public boolean topLeft;
        public boolean topRight;
        public boolean bottomLeft;
        public boolean bottomRight;
    }

    public static class ContextRequirement {
        public final boolean up;
        public final boolean down;
        public final boolean left;
        public final boolean right;
        public final boolean topLeft;
        public final boolean topRight;
        public final boolean bottomLeft;
        public final boolean bottomRight;

        public ContextRequirement(boolean up, boolean down, boolean left, boolean right, boolean topLeft, boolean topRight, boolean bottomLeft, boolean bottomRight) {
            this.up = up;
            this.down = down;
            this.left = left;
            this.right = right;
            this.topLeft = topLeft;
            this.topRight = topRight;
            this.bottomLeft = bottomLeft;
            this.bottomRight = bottomRight;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder {
            private boolean up;
            private boolean down;
            private boolean left;
            private boolean right;
            private boolean topLeft;
            private boolean topRight;
            private boolean bottomLeft;
            private boolean bottomRight;

            public Builder up() {
                this.up = true;
                return this;
            }

            public Builder down() {
                this.down = true;
                return this;
            }

            public Builder left() {
                this.left = true;
                return this;
            }

            public Builder right() {
                this.right = true;
                return this;
            }

            public Builder topLeft() {
                this.topLeft = true;
                return this;
            }

            public Builder topRight() {
                this.topRight = true;
                return this;
            }

            public Builder bottomLeft() {
                this.bottomLeft = true;
                return this;
            }

            public Builder bottomRight() {
                this.bottomRight = true;
                return this;
            }

            public Builder horizontal() {
                this.left();
                this.right();
                return this;
            }

            public Builder vertical() {
                this.up();
                this.down();
                return this;
            }

            public Builder axisAligned() {
                this.horizontal();
                this.vertical();
                return this;
            }

            public Builder corners() {
                this.topLeft();
                this.topRight();
                this.bottomLeft();
                this.bottomRight();
                return this;
            }

            public Builder all() {
                this.axisAligned();
                this.corners();
                return this;
            }

            public ContextRequirement build() {
                return new ContextRequirement(this.up, this.down, this.left, this.right, this.topLeft, this.topRight, this.bottomLeft, this.bottomRight);
            }
        }
    }

    public static abstract class Base
    extends ConnectedTextureBehaviour {
        @Override
        @Nullable
        public abstract CTSpriteShiftEntry getShift(BlockState var1, Direction var2, @Nullable TextureAtlasSprite var3);

        @Override
        @Nullable
        public CTType getDataType(BlockState state, Direction direction) {
            CTSpriteShiftEntry shift = this.getShift(state, direction, null);
            if (shift == null) {
                return null;
            }
            return shift.getType();
        }
    }
}

