/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.ponder;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.simibubi.create.foundation.ponder.PonderRegistry;
import com.simibubi.create.foundation.ponder.PonderStoryBoardEntry;
import com.simibubi.create.foundation.ponder.PonderTag;
import com.simibubi.create.foundation.ponder.content.PonderIndex;
import com.simibubi.create.foundation.ponder.content.SharedText;
import com.simibubi.create.foundation.utility.Couple;
import com.tterrag.registrate.AbstractRegistrate;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.resources.ResourceLocation;

public class PonderLocalization {
    static final Map<ResourceLocation, String> SHARED = new HashMap<ResourceLocation, String>();
    static final Map<ResourceLocation, Couple<String>> TAG = new HashMap<ResourceLocation, Couple<String>>();
    static final Map<ResourceLocation, String> CHAPTER = new HashMap<ResourceLocation, String>();
    static final Map<ResourceLocation, Map<String, String>> SPECIFIC = new HashMap<ResourceLocation, Map<String, String>>();
    public static final String LANG_PREFIX = "ponder.";

    public static void registerShared(ResourceLocation key, String enUS) {
        SHARED.put(key, enUS);
    }

    public static void registerTag(ResourceLocation key, String enUS, String description) {
        TAG.put(key, Couple.create(enUS, description));
    }

    public static void registerChapter(ResourceLocation key, String enUS) {
        CHAPTER.put(key, enUS);
    }

    public static void registerSpecific(ResourceLocation sceneId, String key, String enUS) {
        SPECIFIC.computeIfAbsent(sceneId, $ -> new HashMap()).put(key, enUS);
    }

    public static String getShared(ResourceLocation key) {
        if (PonderIndex.editingModeActive()) {
            return SHARED.containsKey(key) ? SHARED.get(key) : "unregistered shared entry: " + key;
        }
        return I18n.m_118938_((String)PonderLocalization.langKeyForShared(key), (Object[])new Object[0]);
    }

    public static String getTag(ResourceLocation key) {
        if (PonderIndex.editingModeActive()) {
            return TAG.containsKey(key) ? (String)TAG.get(key).getFirst() : "unregistered tag entry: " + key;
        }
        return I18n.m_118938_((String)PonderLocalization.langKeyForTag(key), (Object[])new Object[0]);
    }

    public static String getTagDescription(ResourceLocation key) {
        if (PonderIndex.editingModeActive()) {
            return TAG.containsKey(key) ? (String)TAG.get(key).getSecond() : "unregistered tag entry: " + key;
        }
        return I18n.m_118938_((String)PonderLocalization.langKeyForTagDescription(key), (Object[])new Object[0]);
    }

    public static String getChapter(ResourceLocation key) {
        if (PonderIndex.editingModeActive()) {
            return CHAPTER.containsKey(key) ? CHAPTER.get(key) : "unregistered chapter entry: " + key;
        }
        return I18n.m_118938_((String)PonderLocalization.langKeyForChapter(key), (Object[])new Object[0]);
    }

    public static String getSpecific(ResourceLocation sceneId, String k) {
        if (PonderIndex.editingModeActive()) {
            return SPECIFIC.get(sceneId).get(k);
        }
        return I18n.m_118938_((String)PonderLocalization.langKeyForSpecific(sceneId, k), (Object[])new Object[0]);
    }

    public static void record(String namespace, JsonObject object) {
        SHARED.forEach((k, v) -> {
            if (k.m_135827_().equals(namespace)) {
                object.addProperty(PonderLocalization.langKeyForShared(k), v);
            }
        });
        TAG.forEach((k, v) -> {
            if (k.m_135827_().equals(namespace)) {
                object.addProperty(PonderLocalization.langKeyForTag(k), (String)v.getFirst());
                object.addProperty(PonderLocalization.langKeyForTagDescription(k), (String)v.getSecond());
            }
        });
        CHAPTER.forEach((k, v) -> {
            if (k.m_135827_().equals(namespace)) {
                object.addProperty(PonderLocalization.langKeyForChapter(k), v);
            }
        });
        SPECIFIC.entrySet().stream().filter(entry -> ((ResourceLocation)entry.getKey()).m_135827_().equals(namespace)).sorted(Map.Entry.comparingByKey()).forEach(entry -> ((Map)entry.getValue()).entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(subEntry -> object.addProperty(PonderLocalization.langKeyForSpecific((ResourceLocation)entry.getKey(), (String)subEntry.getKey()), (String)subEntry.getValue())));
    }

    private static void recordGeneral(JsonObject object) {
        PonderLocalization.addGeneral(object, "ponder.hold_to_ponder", "Hold [%1$s] to Ponder");
        PonderLocalization.addGeneral(object, "ponder.subject", "Subject of this scene");
        PonderLocalization.addGeneral(object, "ponder.pondering", "Pondering about...");
        PonderLocalization.addGeneral(object, "ponder.identify_mode", "Identify mode active.\nUnpause with [%1$s]");
        PonderLocalization.addGeneral(object, "ponder.associated", "Associated Entries");
        PonderLocalization.addGeneral(object, "ponder.close", "Close");
        PonderLocalization.addGeneral(object, "ponder.identify", "Identify");
        PonderLocalization.addGeneral(object, "ponder.next", "Next Scene");
        PonderLocalization.addGeneral(object, "ponder.next_up", "Up Next:");
        PonderLocalization.addGeneral(object, "ponder.previous", "Previous Scene");
        PonderLocalization.addGeneral(object, "ponder.replay", "Replay");
        PonderLocalization.addGeneral(object, "ponder.think_back", "Think Back");
        PonderLocalization.addGeneral(object, "ponder.slow_text", "Comfy Reading");
        PonderLocalization.addGeneral(object, "ponder.exit", "Exit");
        PonderLocalization.addGeneral(object, "ponder.welcome", "Welcome to Ponder");
        PonderLocalization.addGeneral(object, "ponder.categories", "Available Categories in Create");
        PonderLocalization.addGeneral(object, "ponder.index_description", "Click one of the icons to learn about its associated Items and Blocks");
        PonderLocalization.addGeneral(object, "ponder.index_title", "Ponder Index");
    }

    private static void addGeneral(JsonObject json, String key, String enUS) {
        json.addProperty("create." + key, enUS);
    }

    public static void generateSceneLang() {
        PonderRegistry.ALL.forEach((id, list) -> {
            for (int i = 0; i < list.size(); ++i) {
                PonderRegistry.compileScene(i, (PonderStoryBoardEntry)list.get(i), null);
            }
        });
    }

    public static JsonObject provideLangEntries() {
        SharedText.gatherText();
        PonderTag.register();
        PonderIndex.register();
        PonderLocalization.generateSceneLang();
        JsonObject object = new JsonObject();
        PonderLocalization.recordGeneral(object);
        PonderLocalization.record("create", object);
        return object;
    }

    public static void provideRegistrateLang(AbstractRegistrate<?> registrate) {
        PonderLocalization.generateSceneLang();
        JsonObject object = new JsonObject();
        PonderLocalization.record(registrate.getModid(), object);
        for (Map.Entry entry : object.entrySet()) {
            registrate.addRawLang((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
        }
    }

    protected static String langKeyForShared(ResourceLocation k) {
        return k.m_135827_() + ".ponder.shared." + k.m_135815_();
    }

    protected static String langKeyForTag(ResourceLocation k) {
        return k.m_135827_() + ".ponder.tag." + k.m_135815_();
    }

    protected static String langKeyForTagDescription(ResourceLocation k) {
        return k.m_135827_() + ".ponder.tag." + k.m_135815_() + ".description";
    }

    protected static String langKeyForChapter(ResourceLocation k) {
        return k.m_135827_() + ".ponder.chapter." + k.m_135815_();
    }

    protected static String langKeyForSpecific(ResourceLocation sceneId, String k) {
        return sceneId.m_135827_() + ".ponder." + sceneId.m_135815_() + "." + k;
    }
}

