/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.tileEntity.behaviour.scrollvalue;

import com.simibubi.create.AllItems;
import com.simibubi.create.AllKeys;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.foundation.tileEntity.SmartTileEntity;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.tileEntity.behaviour.scrollvalue.BulkScrollValueBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.scrollvalue.ScrollValueBehaviour;
import com.simibubi.create.foundation.utility.animation.PhysicalFloat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class ScrollValueHandler {
    private static float lastPassiveScroll = 0.0f;
    private static float passiveScroll = 0.0f;
    private static float passiveScrollDirection = 1.0f;
    private static final PhysicalFloat wrenchCog = PhysicalFloat.create().withDrag(0.3);

    @OnlyIn(value=Dist.CLIENT)
    public static boolean onScroll(double delta) {
        Minecraft mc = Minecraft.m_91087_();
        HitResult objectMouseOver = mc.f_91077_;
        if (!(objectMouseOver instanceof BlockHitResult)) {
            return false;
        }
        ClientLevel world = mc.f_91073_;
        BlockHitResult result = (BlockHitResult)objectMouseOver;
        BlockPos blockPos = result.m_82425_();
        ScrollValueBehaviour scrolling = TileEntityBehaviour.get((BlockGetter)world, blockPos, ScrollValueBehaviour.TYPE);
        if (scrolling == null) {
            return false;
        }
        if (!scrolling.isActive()) {
            return false;
        }
        if (!mc.f_91074_.m_36326_()) {
            return false;
        }
        if (scrolling.needsWrench && !AllItems.WRENCH.isIn(mc.f_91074_.m_21205_())) {
            return false;
        }
        passiveScrollDirection = (float)(-delta);
        wrenchCog.bump(3, -delta * 10.0);
        int prev = scrolling.scrollableValue;
        if (scrolling.slotPositioning instanceof ValueBoxTransform.Sided) {
            ((ValueBoxTransform.Sided)scrolling.slotPositioning).fromSide(result.m_82434_());
        }
        if (!scrolling.testHit(objectMouseOver.m_82450_())) {
            return false;
        }
        if (scrolling instanceof BulkScrollValueBehaviour && AllKeys.ctrlDown()) {
            BulkScrollValueBehaviour bulkScrolling = (BulkScrollValueBehaviour)scrolling;
            for (SmartTileEntity smartTileEntity : bulkScrolling.getBulk()) {
                ScrollValueBehaviour other = smartTileEntity.getBehaviour(ScrollValueBehaviour.TYPE);
                if (other == null) continue;
                ScrollValueHandler.applyTo(delta, other);
            }
        } else {
            ScrollValueHandler.applyTo(delta, scrolling);
        }
        if (prev != scrolling.scrollableValue) {
            float pitch = (float)(scrolling.scrollableValue - scrolling.min) / (float)(scrolling.max - scrolling.min);
            pitch = Mth.m_14179_((float)pitch, (float)1.5f, (float)2.0f);
            AllSoundEvents.SCROLL_VALUE.play((Level)world, (Player)mc.f_91074_, (Vec3i)blockPos, 1.0f, pitch);
        }
        return true;
    }

    public static float getScroll(float partialTicks) {
        return wrenchCog.getValue(partialTicks) + Mth.m_14179_((float)partialTicks, (float)lastPassiveScroll, (float)passiveScroll);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void tick() {
        if (!Minecraft.m_91087_().m_91104_()) {
            lastPassiveScroll = passiveScroll;
            wrenchCog.tick();
            passiveScroll = (float)((double)passiveScroll + (double)passiveScrollDirection * 0.5);
        }
    }

    protected static void applyTo(double delta, ScrollValueBehaviour scrolling) {
        scrolling.ticksUntilScrollPacket = 10;
        int valueBefore = scrolling.scrollableValue;
        ScrollValueBehaviour.StepContext context = new ScrollValueBehaviour.StepContext();
        context.control = AllKeys.ctrlDown();
        context.shift = AllKeys.shiftDown();
        context.currentValue = scrolling.scrollableValue;
        context.forward = delta > 0.0;
        double newValue = (double)scrolling.scrollableValue + Math.signum(delta) * (double)scrolling.step.apply(context).intValue();
        scrolling.scrollableValue = (int)Mth.m_14008_((double)newValue, (double)scrolling.min, (double)scrolling.max);
        if (valueBefore != scrolling.scrollableValue) {
            scrolling.clientCallback.accept(scrolling.scrollableValue);
        }
    }
}

