/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.overlay;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;
import snownee.jade.Jade;
import snownee.jade.api.config.IWailaConfig;
import snownee.jade.api.ui.IBorderStyle;
import snownee.jade.api.ui.IDisplayHelper;
import snownee.jade.impl.ui.BorderStyle;
import snownee.jade.overlay.IconUI;
import snownee.jade.overlay.OverlayRenderer;
import snownee.jade.util.Color;

public class DisplayHelper
implements IDisplayHelper {
    public static final DisplayHelper INSTANCE = new DisplayHelper();
    private static final Minecraft CLIENT = Minecraft.m_91087_();
    private static final int TEX_WIDTH = 16;
    private static final int TEX_HEIGHT = 16;
    private static final int MIN_FLUID_HEIGHT = 1;
    public static DecimalFormat dfCommas = new DecimalFormat("##.##");
    private static final Pattern STRIP_COLOR;

    @Override
    public void drawItem(PoseStack matrixStack, float x, float y, ItemStack stack, float scale, @Nullable String text) {
        if (OverlayRenderer.alpha < 0.5f) {
            return;
        }
        RenderSystem.m_69482_();
        PoseStack modelViewStack = RenderSystem.m_157191_();
        modelViewStack.m_85836_();
        modelViewStack.m_166854_(matrixStack.m_85850_().m_85861_());
        float o = 8.0f * scale;
        modelViewStack.m_85837_((double)(x + o), (double)(y + o), 0.0);
        modelViewStack.m_85841_(scale *= Math.min(1.0f, OverlayRenderer.alpha + 0.2f), scale, scale);
        modelViewStack.m_85837_(-8.0, -8.0, 0.0);
        CLIENT.m_91291_().m_115123_(stack, 0, 0);
        DisplayHelper.renderGuiItemDecorations(DisplayHelper.CLIENT.f_91062_, stack, text);
        modelViewStack.m_85849_();
        RenderSystem.m_157182_();
        RenderSystem.m_69465_();
    }

    private static void renderGuiItemDecorations(Font font, ItemStack stack, @Nullable String p_115179_) {
        LocalPlayer localplayer;
        float f;
        if (stack.m_41619_()) {
            return;
        }
        PoseStack posestack = new PoseStack();
        if (stack.m_41613_() != 1 || p_115179_ != null) {
            String s = p_115179_ == null ? INSTANCE.humanReadableNumber(stack.m_41613_(), "", false) : p_115179_;
            posestack.m_85836_();
            posestack.m_85837_(0.0, 0.0, (double)(DisplayHelper.CLIENT.m_91291_().f_115093_ + 200.0f));
            posestack.m_85841_(0.75f, 0.75f, 0.75f);
            MultiBufferSource.BufferSource multibuffersource$buffersource = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
            font.m_92811_(s, (float)(22 - font.m_92895_(s)), 13.0f, 0xFFFFFF, true, posestack.m_85850_().m_85861_(), (MultiBufferSource)multibuffersource$buffersource, false, 0, 0xF000F0);
            multibuffersource$buffersource.m_109911_();
            posestack.m_85849_();
        }
        if (stack.m_150947_()) {
            RenderSystem.m_69465_();
            RenderSystem.m_69472_();
            RenderSystem.m_69461_();
            Tesselator tesselator = Tesselator.m_85913_();
            BufferBuilder bufferbuilder = tesselator.m_85915_();
            int i = stack.m_150948_();
            int j = stack.m_150949_();
            DisplayHelper.draw(posestack, bufferbuilder, 2.0f, 13.0f, 13, 2, 0, 0, 0, 255);
            DisplayHelper.draw(posestack, bufferbuilder, 2.0f, 13.0f, i, 1, j >> 16 & 0xFF, j >> 8 & 0xFF, j & 0xFF, 255);
            RenderSystem.m_69478_();
            RenderSystem.m_69493_();
            RenderSystem.m_69482_();
        }
        float f2 = f = (localplayer = Minecraft.m_91087_().f_91074_) == null ? 0.0f : localplayer.m_36335_().m_41521_(stack.m_41720_(), Minecraft.m_91087_().m_91296_());
        if (f > 0.0f) {
            RenderSystem.m_69465_();
            RenderSystem.m_69472_();
            RenderSystem.m_69478_();
            RenderSystem.m_69453_();
            Tesselator tesselator1 = Tesselator.m_85913_();
            BufferBuilder bufferbuilder1 = tesselator1.m_85915_();
            DisplayHelper.draw(posestack, bufferbuilder1, 0.0f, 0 + Mth.m_14143_((float)(16.0f * (1.0f - f))), 16, Mth.m_14167_((float)(16.0f * f)), 255, 255, 255, 127);
            RenderSystem.m_69493_();
            RenderSystem.m_69482_();
        }
    }

    private static void draw(PoseStack ms, BufferBuilder renderer, float x, float y, int width, int height, int red, int green, int blue, int alpha) {
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        Matrix4f matrix = ms.m_85850_().m_85861_();
        renderer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        renderer.m_85982_(matrix, x, y, 0.0f).m_6122_(red, green, blue, alpha).m_5752_();
        renderer.m_85982_(matrix, x, y + (float)height, 0.0f).m_6122_(red, green, blue, alpha).m_5752_();
        renderer.m_85982_(matrix, x + (float)width, y + (float)height, 0.0f).m_6122_(red, green, blue, alpha).m_5752_();
        renderer.m_85982_(matrix, x + (float)width, y, 0.0f).m_6122_(red, green, blue, alpha).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)renderer.m_231175_());
    }

    @Override
    public void drawGradientRect(PoseStack matrixStack, float left, float top, float width, float height, int startColor, int endColor) {
        this.drawGradientRect(matrixStack, left, top, width, height, startColor, endColor, false);
    }

    public void drawGradientRect(PoseStack matrixStack, float left, float top, float width, float height, int startColor, int endColor, boolean horizontal) {
        float zLevel = 0.0f;
        Matrix4f matrix = matrixStack.m_85850_().m_85861_();
        float f = (float)(startColor >> 24 & 0xFF) / 255.0f * OverlayRenderer.alpha;
        float f1 = (float)(startColor >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(startColor >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(startColor & 0xFF) / 255.0f;
        float f4 = (float)(endColor >> 24 & 0xFF) / 255.0f * OverlayRenderer.alpha;
        float f5 = (float)(endColor >> 16 & 0xFF) / 255.0f;
        float f6 = (float)(endColor >> 8 & 0xFF) / 255.0f;
        float f7 = (float)(endColor & 0xFF) / 255.0f;
        RenderSystem.m_69472_();
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder buffer = tessellator.m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        if (horizontal) {
            buffer.m_85982_(matrix, left + width, top, zLevel).m_85950_(f5, f6, f7, f4).m_5752_();
            buffer.m_85982_(matrix, left, top, zLevel).m_85950_(f1, f2, f3, f).m_5752_();
            buffer.m_85982_(matrix, left, top + height, zLevel).m_85950_(f1, f2, f3, f).m_5752_();
            buffer.m_85982_(matrix, left + width, top + height, zLevel).m_85950_(f5, f6, f7, f4).m_5752_();
        } else {
            buffer.m_85982_(matrix, left + width, top, zLevel).m_85950_(f1, f2, f3, f).m_5752_();
            buffer.m_85982_(matrix, left, top, zLevel).m_85950_(f1, f2, f3, f).m_5752_();
            buffer.m_85982_(matrix, left, top + height, zLevel).m_85950_(f5, f6, f7, f4).m_5752_();
            buffer.m_85982_(matrix, left + width, top + height, zLevel).m_85950_(f5, f6, f7, f4).m_5752_();
        }
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)buffer.m_231175_());
        RenderSystem.m_69461_();
        RenderSystem.m_69493_();
    }

    @Override
    public void drawBorder(PoseStack matrixStack, float minX, float minY, float maxX, float maxY, IBorderStyle border0) {
        BorderStyle border = (BorderStyle)border0;
        this.drawBorder(matrixStack, minX, minY, maxX, maxY, border.width, border.color, true);
    }

    @Override
    public void drawBorder(PoseStack matrixStack, float minX, float minY, float maxX, float maxY, float width, int color, boolean corner) {
        DisplayHelper.fill(matrixStack, minX + width, minY, maxX - width, minY + width, color);
        DisplayHelper.fill(matrixStack, minX + width, maxY - width, maxX - width, maxY, color);
        if (corner) {
            DisplayHelper.fill(matrixStack, minX, minY, minX + width, maxY, color);
            DisplayHelper.fill(matrixStack, maxX - width, minY, maxX, maxY, color);
        } else {
            DisplayHelper.fill(matrixStack, minX, minY + width, minX + width, maxY - width, color);
            DisplayHelper.fill(matrixStack, maxX - width, minY + width, maxX, maxY - width, color);
        }
    }

    public static void drawTexturedModalRect(PoseStack matrixStack, float x, float y, int textureX, int textureY, int width, int height, int tw, int th) {
        Matrix4f matrix = matrixStack.m_85850_().m_85861_();
        float f = 0.00390625f;
        float f1 = 0.00390625f;
        float zLevel = 0.0f;
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder buffer = tessellator.m_85915_();
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        buffer.m_85982_(matrix, x, y + (float)height, zLevel).m_7421_((float)textureX * f, (float)(textureY + th) * f1).m_5752_();
        buffer.m_85982_(matrix, x + (float)width, y + (float)height, zLevel).m_7421_((float)(textureX + tw) * f, (float)(textureY + th) * f1).m_5752_();
        buffer.m_85982_(matrix, x + (float)width, y, zLevel).m_7421_((float)(textureX + tw) * f, (float)textureY * f1).m_5752_();
        buffer.m_85982_(matrix, x, y, zLevel).m_7421_((float)textureX * f, (float)textureY * f1).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)buffer.m_231175_());
    }

    public static List<Component> itemDisplayNameMultiline(ItemStack itemstack) {
        ArrayList<Component> namelist = null;
        try {
            namelist = itemstack.m_41651_((Player)DisplayHelper.CLIENT.f_91074_, (TooltipFlag)TooltipFlag.Default.NORMAL);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (namelist == null) {
            namelist = new ArrayList<Component>();
        }
        if (namelist.isEmpty()) {
            namelist.add((Component)Component.m_237113_((String)"Unnamed"));
        }
        namelist.set(0, (Component)Component.m_237113_((String)(itemstack.m_41791_().f_43022_.toString() + namelist.get(0))));
        for (int i = 1; i < namelist.size(); ++i) {
            namelist.set(i, (Component)namelist.get(i));
        }
        return namelist;
    }

    public static void renderIcon(PoseStack matrixStack, float x, float y, int sx, int sy, IconUI icon) {
        if (icon == null) {
            return;
        }
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)OverlayRenderer.alpha);
        RenderSystem.m_157456_((int)0, (ResourceLocation)GuiComponent.f_93098_);
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        if (icon.bu != -1) {
            DisplayHelper.drawTexturedModalRect(matrixStack, x, y, icon.bu, icon.bv, sx, sy, icon.bsu, icon.bsv);
        }
        DisplayHelper.drawTexturedModalRect(matrixStack, x, y, icon.u, icon.v, sx, sy, icon.su, icon.sv);
    }

    public void drawFluid(PoseStack matrixStack, float xPosition, float yPosition, @Nullable FluidStack fluidStack, float width, float height, int capacityMb) {
        if (OverlayRenderer.alpha < 0.5f) {
            return;
        }
        if (fluidStack == null || fluidStack.isEmpty()) {
            return;
        }
        Fluid fluid = fluidStack.getFluid();
        if (fluid == null) {
            return;
        }
        TextureAtlasSprite fluidStillSprite = DisplayHelper.getStillFluidSprite(fluidStack);
        int fluidColor = IClientFluidTypeExtensions.of((Fluid)fluid).getTintColor(fluidStack);
        int amount = fluidStack.getAmount();
        float scaledAmount = (float)amount * height / (float)capacityMb;
        if (amount > 0 && scaledAmount < 1.0f) {
            scaledAmount = 1.0f;
        }
        if (scaledAmount > height) {
            scaledAmount = height;
        }
        this.drawTiledSprite(matrixStack, xPosition, yPosition, width, height, fluidColor, scaledAmount, fluidStillSprite);
    }

    private void drawTiledSprite(PoseStack matrixStack, float xPosition, float yPosition, float tiledWidth, float tiledHeight, int color, float scaledAmount, TextureAtlasSprite sprite) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)InventoryMenu.f_39692_);
        Matrix4f matrix = matrixStack.m_85850_().m_85861_();
        DisplayHelper.setGLColorFromInt(color);
        int xTileCount = (int)(tiledWidth / 16.0f);
        float xRemainder = tiledWidth - (float)(xTileCount * 16);
        int yTileCount = (int)(scaledAmount / 16.0f);
        float yRemainder = scaledAmount - (float)(yTileCount * 16);
        float yStart = yPosition + tiledHeight;
        for (int xTile = 0; xTile <= xTileCount; ++xTile) {
            for (int yTile = 0; yTile <= yTileCount; ++yTile) {
                float width = xTile == xTileCount ? xRemainder : 16.0f;
                float height = yTile == yTileCount ? yRemainder : 16.0f;
                float x = xPosition + (float)(xTile * 16);
                float y = yStart - (float)((yTile + 1) * 16);
                if (!(width > 0.0f) || !(height > 0.0f)) continue;
                float maskTop = 16.0f - height;
                float maskRight = 16.0f - width;
                DisplayHelper.drawTextureWithMasking(matrix, x, y, sprite, maskTop, maskRight, 100.0f);
            }
        }
    }

    private static TextureAtlasSprite getStillFluidSprite(FluidStack fluidStack) {
        Minecraft minecraft = Minecraft.m_91087_();
        Fluid fluid = fluidStack.getFluid();
        ResourceLocation fluidStill = IClientFluidTypeExtensions.of((Fluid)fluid).getStillTexture(fluidStack);
        return (TextureAtlasSprite)minecraft.m_91258_(InventoryMenu.f_39692_).apply(fluidStill);
    }

    private static void setGLColorFromInt(int color) {
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        float alpha = (float)(color >> 24 & 0xFF) / 255.0f;
        RenderSystem.m_157429_((float)red, (float)green, (float)blue, (float)alpha);
    }

    private static void drawTextureWithMasking(Matrix4f matrix, float xCoord, float yCoord, TextureAtlasSprite textureSprite, float maskTop, float maskRight, float zLevel) {
        float uMin = textureSprite.m_118409_();
        float uMax = textureSprite.m_118410_();
        float vMin = textureSprite.m_118411_();
        float vMax = textureSprite.m_118412_();
        uMax -= maskRight / 16.0f * (uMax - uMin);
        vMax -= maskTop / 16.0f * (vMax - vMin);
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder bufferBuilder = tessellator.m_85915_();
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bufferBuilder.m_85982_(matrix, xCoord, yCoord + 16.0f, zLevel).m_7421_(uMin, vMax).m_5752_();
        bufferBuilder.m_85982_(matrix, xCoord + 16.0f - maskRight, yCoord + 16.0f, zLevel).m_7421_(uMax, vMax).m_5752_();
        bufferBuilder.m_85982_(matrix, xCoord + 16.0f - maskRight, yCoord + maskTop, zLevel).m_7421_(uMax, vMin).m_5752_();
        bufferBuilder.m_85982_(matrix, xCoord, yCoord + maskTop, zLevel).m_7421_(uMin, vMin).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
    }

    public static void fill(PoseStack matrixStack, float minX, float minY, float maxX, float maxY, int color) {
        DisplayHelper.fill(matrixStack.m_85850_().m_85861_(), minX, minY, maxX, maxY, color);
    }

    private static void fill(Matrix4f matrix, float minX, float minY, float maxX, float maxY, int color) {
        if (minX < maxX) {
            float i = minX;
            minX = maxX;
            maxX = i;
        }
        if (minY < maxY) {
            float j = minY;
            minY = maxY;
            maxY = j;
        }
        float f3 = (float)(color >> 24 & 0xFF) / 255.0f * OverlayRenderer.alpha;
        float f = (float)(color >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(color >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(color & 0xFF) / 255.0f;
        BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
        RenderSystem.m_69478_();
        RenderSystem.m_69472_();
        RenderSystem.m_69453_();
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        bufferbuilder.m_85982_(matrix, minX, maxY, 0.0f).m_85950_(f, f1, f2, f3).m_5752_();
        bufferbuilder.m_85982_(matrix, maxX, maxY, 0.0f).m_85950_(f, f1, f2, f3).m_5752_();
        bufferbuilder.m_85982_(matrix, maxX, minY, 0.0f).m_85950_(f, f1, f2, f3).m_5752_();
        bufferbuilder.m_85982_(matrix, minX, minY, 0.0f).m_85950_(f, f1, f2, f3).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
        RenderSystem.m_69493_();
        RenderSystem.m_69461_();
    }

    @Override
    public String humanReadableNumber(double number, String unit, boolean milli) {
        boolean n;
        StringBuilder sb = new StringBuilder();
        boolean bl = n = number < 0.0;
        if (n) {
            number = -number;
            sb.append('-');
        }
        if (milli && number >= 1000.0) {
            number /= 1000.0;
            milli = false;
        }
        if (number < 1000.0) {
            sb.append(dfCommas.format(number));
            if (milli && number != 0.0) {
                sb.append('m');
            }
        } else {
            int exp = (int)(Math.log10(number) / 3.0);
            if (exp > 7) {
                exp = 7;
            }
            char pre = "kMGTPEZ".charAt(exp - 1);
            sb.append(dfCommas.format(number / Math.pow(1000.0, exp)));
            sb.append(pre);
        }
        sb.append(unit);
        return sb.toString();
    }

    @Override
    public void drawText(PoseStack poseStack, String text, float x, float y, int color) {
        this.drawText(poseStack, (Component)Component.m_237113_((String)text), x, y, color);
    }

    @Override
    public void drawText(PoseStack poseStack, Component text, float x, float y, int color) {
        this.drawText(poseStack, text.m_7532_(), x, y, color);
    }

    @Override
    public void drawText(PoseStack poseStack, FormattedCharSequence text, float x, float y, int color) {
        boolean shadow = Jade.CONFIG.get().getOverlay().getTheme().textShadow;
        if (OverlayRenderer.alpha != 1.0f) {
            color = IWailaConfig.IConfigOverlay.applyAlpha(color, OverlayRenderer.alpha);
        }
        if (shadow) {
            DisplayHelper.CLIENT.f_91062_.m_92744_(poseStack, text, x, y, color);
        } else {
            DisplayHelper.CLIENT.f_91062_.m_92877_(poseStack, text, x, y, color);
        }
    }

    public void drawGradientProgress(PoseStack matrixStack, float left, float top, float width, float height, float progress, int progressColor) {
        Color color = Color.rgb(progressColor);
        Color highlight = Color.hsl(color.getHue(), color.getSaturation(), Math.min(color.getLightness() + 0.2, 1.0), color.getOpacity());
        if (progress < 0.1f) {
            this.drawGradientRect(matrixStack, left, top, width * progress, height, progressColor, highlight.toInt(), true);
        } else {
            float hlWidth = width * 0.1f;
            float normalWidth = width * progress - hlWidth;
            DisplayHelper.fill(matrixStack, left, top, left + normalWidth, top + height, progressColor);
            this.drawGradientRect(matrixStack, left + normalWidth, top, hlWidth, height, progressColor, highlight.toInt(), true);
        }
    }

    @Override
    public MutableComponent stripColor(Component component) {
        MutableComponent mutableComponent = Component.m_237119_();
        component.m_7451_((style, string) -> {
            if (!string.isEmpty()) {
                MutableComponent literal = Component.m_237113_((String)STRIP_COLOR.matcher(string).replaceAll(""));
                literal.m_130948_(style.m_131148_((TextColor)null));
                mutableComponent.m_7220_((Component)literal);
            }
            return Optional.empty();
        }, Style.f_131099_);
        return mutableComponent;
    }

    static {
        dfCommas.setRoundingMode(RoundingMode.DOWN);
        STRIP_COLOR = Pattern.compile("(?i)\u00a7[0-9A-F]");
    }
}

