/*
 * Decompiled with CFR 0.152.
 */
package fabric.net.mca.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import fabric.net.mca.Config;
import fabric.net.mca.MCA;
import fabric.net.mca.MCAClient;
import fabric.net.mca.client.gui.VillagerEditorScreen;
import fabric.net.mca.cobalt.network.NetworkHandler;
import fabric.net.mca.network.c2s.DestinyMessage;
import fabric.net.mca.util.localization.FlowingText;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4587;

public class DestinyScreen
extends VillagerEditorScreen {
    private static final class_2960 LOGO_TEXTURE = new class_2960("mca:textures/banner.png");
    private final LinkedList<class_2561> story = new LinkedList();
    private String location;
    private boolean teleported = false;
    private final boolean allowTeleportation;
    private class_4185 acceptWidget;

    public DestinyScreen(UUID playerUUID, boolean allowTeleportation) {
        super(playerUUID, playerUUID);
        this.allowTeleportation = allowTeleportation;
    }

    @Override
    public boolean method_25421() {
        return true;
    }

    public void method_25419() {
        if (!this.page.equals("general") && !this.page.equals("story")) {
            this.setPage("destiny");
        }
    }

    @Override
    protected String[] getPages() {
        return new String[]{"general", "body", "head", "traits"};
    }

    public void method_25420(class_4587 matrices) {
        assert (class_310.method_1551().field_1687 != null);
        this.method_25434((int)class_310.method_1551().field_1687.method_8510());
    }

    private void drawScaledText(class_4587 transform, class_2561 text, int x, int y, float scale) {
        transform.method_22903();
        transform.method_22905(scale, scale, scale);
        DestinyScreen.method_27534((class_4587)transform, (class_327)this.field_22793, (class_2561)text, (int)((int)((float)x / scale)), (int)((int)((float)y / scale)), (int)-1);
        transform.method_22909();
    }

    @Override
    public void method_25394(class_4587 transform, int mouseX, int mouseY, float delta) {
        super.method_25394(transform, mouseX, mouseY, delta);
        switch (this.page) {
            case "general": {
                this.drawScaledText(transform, (class_2561)class_2561.method_43471((String)"gui.destiny.whoareyou"), this.field_22789 / 2, this.field_22790 / 2 - 24, 1.5f);
                transform.method_22903();
                transform.method_22905(0.25f, 0.25f, 0.25f);
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.setShaderTexture((int)0, (class_2960)LOGO_TEXTURE);
                class_332.method_25290((class_4587)transform, (int)(this.field_22789 * 2 - 512), (int)-40, (float)0.0f, (float)0.0f, (int)1024, (int)512, (int)1024, (int)512);
                transform.method_22909();
                break;
            }
            case "destiny": {
                this.drawScaledText(transform, (class_2561)class_2561.method_43471((String)"gui.destiny.journey"), this.field_22789 / 2, this.field_22790 / 2 - 48, 1.5f);
                break;
            }
            case "story": {
                List<class_2561> text = FlowingText.wrap(this.story.getFirst(), 256);
                int y = (int)((float)(this.field_22790 / 2 - 20) - 7.5f * (float)text.size());
                for (class_2561 t : text) {
                    this.drawScaledText(transform, t, this.field_22789 / 2, y, 1.25f);
                    y += 15;
                }
                break;
            }
        }
    }

    @Override
    protected boolean shouldDrawEntity() {
        return !this.page.equals("general") && !this.page.equals("destiny") && !this.page.equals("story") && super.shouldDrawEntity();
    }

    @Override
    protected void setPage(String page) {
        if (page.equals("destiny") && !this.allowTeleportation) {
            NetworkHandler.sendToServer(new DestinyMessage(true));
            MCAClient.getDestinyManager().allowClosing();
            super.method_25419();
            return;
        }
        if (page.equals("destiny") && Config.getServerConfig().destinySpawnLocations.size() == 1) {
            this.selectStory(Config.getServerConfig().destinySpawnLocations.get(0));
            return;
        }
        this.page = page;
        this.method_37067();
        switch (page) {
            case "general": {
                this.drawName(this.field_22789 / 2 - 87, this.field_22790 / 2, name -> {
                    this.updateName((String)name);
                    if (this.acceptWidget != null) {
                        this.acceptWidget.field_22763 = !MCA.isBlankString(name);
                    }
                });
                this.drawGender(this.field_22789 / 2 - 87, this.field_22790 / 2 + 24);
                this.drawModel(this.field_22789 / 2 - 87, this.field_22790 / 2 + 24 + 22);
                this.acceptWidget = (class_4185)this.method_37063((class_364)new class_4185(this.field_22789 / 2 - 32, this.field_22790 / 2 + 60 + 22, 64, 20, (class_2561)class_2561.method_43471((String)"gui.button.accept"), sender -> this.setPage("body")));
                break;
            }
            case "destiny": {
                int x = 0;
                int y = 0;
                for (String location : Config.getServerConfig().destinySpawnLocations) {
                    int rows = (int)Math.ceil((float)Config.getServerConfig().destinySpawnLocations.size() / 3.0f);
                    float offsetX = y + 1 == rows ? (float)(2 - (Config.getServerConfig().destinySpawnLocations.size() - 1) % 3) / 2.0f : 0.0f;
                    float offsetY = (float)Math.max(0, 3 - rows) / 2.0f;
                    this.method_37063((class_364)new class_4185((int)((float)(this.field_22789 / 2) - 144.0f + ((float)x + offsetX) * 96.0f), (int)((float)(this.field_22790 / 2) + ((float)y + offsetY) * 20.0f - 16.0f), 96, 20, (class_2561)class_2561.method_43471((String)("gui.destiny." + new class_2960(location).method_12832())), sender -> this.selectStory(location)));
                    if (++x < 3) continue;
                    x = 0;
                    ++y;
                }
                break;
            }
            case "story": {
                this.method_37063((class_364)new class_4185(this.field_22789 / 2 - 48, this.field_22790 / 2 + 32, 96, 20, (class_2561)class_2561.method_43471((String)"gui.destiny.next"), sender -> {
                    if (!this.teleported) {
                        NetworkHandler.sendToServer(new DestinyMessage(this.location));
                        MCAClient.getDestinyManager().allowClosing();
                        this.teleported = true;
                    }
                    if (this.story.size() > 1) {
                        this.story.remove(0);
                    } else {
                        NetworkHandler.sendToServer(new DestinyMessage(true));
                        super.method_25419();
                    }
                }));
                break;
            }
            default: {
                super.setPage(page);
            }
        }
    }

    private void selectStory(String location) {
        this.story.clear();
        this.story.add((class_2561)class_2561.method_43471((String)"destiny.story.reason"));
        Map<String, String> map = Config.getInstance().destinyLocationsToTranslationMap;
        this.story.add((class_2561)class_2561.method_43471((String)map.getOrDefault(location, map.getOrDefault("default", "missing_default"))));
        this.story.add((class_2561)class_2561.method_43471((String)("destiny.story." + new class_2960(location).method_12832())));
        this.location = location;
        this.setPage("story");
    }
}

