/*
 * Decompiled with CFR 0.152.
 */
package fabric.net.mca.client.gui;

import fabric.net.mca.Config;
import fabric.net.mca.MCA;
import fabric.net.mca.ProfessionsMCA;
import fabric.net.mca.client.gui.widget.ColorPickerWidget;
import fabric.net.mca.client.gui.widget.GeneSliderWidget;
import fabric.net.mca.client.gui.widget.NamedTextFieldWidget;
import fabric.net.mca.client.gui.widget.TooltipButtonWidget;
import fabric.net.mca.cobalt.network.NetworkHandler;
import fabric.net.mca.entity.EntitiesMCA;
import fabric.net.mca.entity.VillagerEntityMCA;
import fabric.net.mca.entity.VillagerLike;
import fabric.net.mca.entity.ai.Genetics;
import fabric.net.mca.entity.ai.Memories;
import fabric.net.mca.entity.ai.Traits;
import fabric.net.mca.entity.ai.relationship.AgeState;
import fabric.net.mca.entity.ai.relationship.Gender;
import fabric.net.mca.entity.ai.relationship.Personality;
import fabric.net.mca.network.c2s.GetVillagerRequest;
import fabric.net.mca.network.c2s.SkinListRequest;
import fabric.net.mca.network.c2s.VillagerEditorSyncRequest;
import fabric.net.mca.network.c2s.VillagerNameRequest;
import fabric.net.mca.resources.ClothingList;
import fabric.net.mca.resources.HairList;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.StringConcatFactory;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_124;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_3852;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_490;
import net.minecraft.class_5250;

public class VillagerEditorScreen
extends class_437 {
    final UUID villagerUUID;
    final UUID playerUUID;
    final boolean allowPlayerModel;
    final boolean allowVillagerModel;
    private int villagerBreedingAge;
    protected String page;
    protected final VillagerEntityMCA villager;
    protected final VillagerEntityMCA villagerVisualization;
    protected static final int DATA_WIDTH = 175;
    private int traitPage;
    private static final int TRAITS_PER_PAGE = 8;
    protected class_2487 villagerData;
    private class_342 villagerNameField;
    private int clothingPage;
    private int clothingPageCount;
    private class_4185 pageButtonWidget;
    private List<String> filteredClothing;
    private List<String> filteredHair;
    private static HashMap<String, ClothingList.Clothing> clothing = new HashMap();
    private static HashMap<String, HairList.Hair> hair = new HashMap();
    private Gender filterGender;
    private String searchString;
    private int hoveredClothingId;
    int CLOTHES_H;
    int CLOTHES_V;
    int CLOTHES_PER_PAGE;
    class_4185 widgetMasculine;
    class_4185 widgetFeminine;
    private class_4185 villagerSkinWidget;
    private class_4185 playerSkinWidget;
    private class_4185 vanillaSkinWidget;
    private class_4185 doneWidget;
    private class_4185 genderButtonFemale;
    private class_4185 genderButtonMale;

    public VillagerEditorScreen(UUID villagerUUID, UUID playerUUID, boolean allowPlayerModel, boolean allowVillagerModel) {
        super((class_2561)class_2561.method_43471((String)"gui.VillagerEditorScreen.title"));
        this.villager = Objects.requireNonNull((VillagerEntityMCA)((class_1299)EntitiesMCA.MALE_VILLAGER.get()).method_5883((class_1937)class_310.method_1551().field_1687));
        this.villagerVisualization = Objects.requireNonNull((VillagerEntityMCA)((class_1299)EntitiesMCA.MALE_VILLAGER.get()).method_5883((class_1937)class_310.method_1551().field_1687));
        this.traitPage = 0;
        this.filteredClothing = new LinkedList<String>();
        this.filteredHair = new LinkedList<String>();
        this.filterGender = Gender.NEUTRAL;
        this.searchString = "";
        this.CLOTHES_H = 8;
        this.CLOTHES_V = 2;
        this.CLOTHES_PER_PAGE = this.CLOTHES_H * this.CLOTHES_V + 1;
        this.villagerUUID = villagerUUID;
        this.playerUUID = playerUUID;
        this.allowPlayerModel = allowPlayerModel;
        this.allowVillagerModel = allowVillagerModel;
        if (clothing.isEmpty()) {
            NetworkHandler.sendToServer(new SkinListRequest());
        }
        this.requestVillagerData();
        this.setPage(Objects.requireNonNullElse(this.page, "loading"));
    }

    public VillagerEditorScreen(UUID villagerUUID, UUID playerUUID) {
        this(villagerUUID, playerUUID, MCA.isPlayerRendererAllowed(), MCA.isVillagerRendererAllowed());
    }

    public boolean method_25421() {
        return false;
    }

    public void method_25426() {
        this.setPage(this.page);
    }

    private int doubleGeneSliders(int y, Genetics.GeneType ... genes) {
        boolean right = false;
        Genetics genetics = this.villager.getGenetics();
        for (Genetics.GeneType g : genes) {
            this.method_37063((class_364)new GeneSliderWidget(this.field_22789 / 2 + (right ? 87 : 0), y, 87, 20, (class_2561)class_2561.method_43471((String)g.getTranslationKey()), genetics.getGene(g), b -> genetics.setGene(g, b.floatValue())));
            if (right) {
                y += 20;
            }
            right = !right;
        }
        return y + 4 + (right ? 20 : 0);
    }

    private int integerChanger(int y, Consumer<Integer> onClick, Supplier<class_2561> content) {
        int bw = 22;
        class_4185 current = (class_4185)this.method_37063((class_364)new class_4185(this.field_22789 / 2 + bw * 2, y, 175 - bw * 4, 20, content.get(), b -> {}));
        this.method_37063((class_364)new class_4185(this.field_22789 / 2, y, bw, 20, (class_2561)class_2561.method_43470((String)"-5"), b -> {
            onClick.accept(-5);
            current.method_25355((class_2561)content.get());
        }));
        this.method_37063((class_364)new class_4185(this.field_22789 / 2 + bw, y, bw, 20, (class_2561)class_2561.method_43470((String)"-50"), b -> {
            onClick.accept(-50);
            current.method_25355((class_2561)content.get());
        }));
        this.method_37063((class_364)new class_4185(this.field_22789 / 2 + 175 - bw * 2, y, bw, 20, (class_2561)class_2561.method_43470((String)"+50"), b -> {
            onClick.accept(50);
            current.method_25355((class_2561)content.get());
        }));
        this.method_37063((class_364)new class_4185(this.field_22789 / 2 + 175 - bw, y, bw, 20, (class_2561)class_2561.method_43470((String)"+5"), b -> {
            onClick.accept(5);
            current.method_25355((class_2561)content.get());
        }));
        return y + 22;
    }

    protected void setPage(String page) {
        this.page = page;
        this.method_37067();
        if (page.equals("loading")) {
            return;
        }
        if (this.shouldShowPageSelection()) {
            String[] pages = this.getPages();
            int w = 350 / pages.length;
            int x = (int)((double)this.field_22789 / 2.0 - (double)pages.length / 2.0 * (double)w);
            for (String string : pages) {
                ((class_4185)this.method_37063((class_364)new class_4185((int)x, (int)(this.field_22790 / 2 - 105), (int)w, (int)20, (class_2561)class_2561.method_43471((String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"gui.villager_editor.page.\u0001"}, (String)string))), (class_4185.class_4241)(class_4185.class_4241)LambdaMetafactory.metafactory(null, null, null, (Lnet/minecraft/class_4185;)V, lambda$setPage$6(java.lang.String net.minecraft.class_4185 ), (Lnet/minecraft/class_4185;)V)((VillagerEditorScreen)this, (String)string)))).field_22763 = !string.equals(page);
                x += w;
            }
            this.doneWidget = (class_4185)this.method_37063((class_364)new class_4185(this.field_22789 / 2 - 175 + 20, this.field_22790 / 2 + 85, 135, 20, (class_2561)class_2561.method_43471((String)"gui.done"), sender -> {
                this.syncVillagerData();
                this.method_25419();
            }));
        }
        int y = this.field_22790 / 2 - 80;
        int margin = 40;
        Genetics genetics = this.villager.getGenetics();
        switch (page) {
            case "general": {
                class_342 textFieldWidget;
                this.drawName(this.field_22789 / 2, y);
                this.drawGender(this.field_22789 / 2, y += 20);
                y += 22;
                if (this.villagerUUID.equals(this.playerUUID)) {
                    this.drawModel(this.field_22789 / 2, y);
                    y += 22;
                }
                if (!this.villagerUUID.equals(this.playerUUID)) {
                    this.method_37063((class_364)new GeneSliderWidget(this.field_22789 / 2, y, 175, 20, (class_2561)class_2561.method_43471((String)"gui.villager_editor.age"), 1.0 + (double)this.villagerBreedingAge / (double)AgeState.getMaxAge(), b -> {
                        this.villagerBreedingAge = -((int)((1.0 - b) * (double)AgeState.getMaxAge())) + 1;
                        this.villager.method_5614(this.villagerBreedingAge);
                        this.villager.method_18382();
                    }));
                    y += 28;
                }
                for (String who : new String[]{"father", "mother", "spouse"}) {
                    textFieldWidget = (class_342)this.method_37063((class_364)new NamedTextFieldWidget(this.field_22793, this.field_22789 / 2, y, 175, 18, (class_2561)class_2561.method_43471((String)("gui.villager_editor.relation." + who))));
                    textFieldWidget.method_1880(64);
                    textFieldWidget.method_1852(this.villagerData.method_10558("tree_" + who + "_name"));
                    textFieldWidget.method_1863(name -> this.villagerData.method_10582("tree_" + who + "_new", name));
                    y += 20;
                }
                textFieldWidget = (class_342)this.method_37063((class_364)new class_342(this.field_22793, this.field_22789 / 2, y += 4, 175, 18, (class_2561)class_2561.method_43470((String)"UUID")));
                textFieldWidget.method_1880(64);
                textFieldWidget.method_1852(this.villagerUUID.toString());
                break;
            }
            case "body": {
                y = this.doubleGeneSliders(y, Genetics.SIZE, Genetics.WIDTH, Genetics.BREAST, Genetics.SKIN);
                this.method_37063((class_364)new class_4185(this.field_22789 / 2, y, 87, 20, (class_2561)class_2561.method_43471((String)"gui.villager_editor.randClothing"), b -> this.sendCommand("clothing")));
                this.method_37063((class_364)new class_4185(this.field_22789 / 2 + 87, y, 87, 20, (class_2561)class_2561.method_43471((String)"gui.villager_editor.selectClothing"), b -> this.setPage("clothing")));
                this.method_37063((class_364)new class_4185(this.field_22789 / 2, y += 22, 87, 20, (class_2561)class_2561.method_43471((String)"gui.villager_editor.prev"), b -> {
                    class_2487 compound = new class_2487();
                    compound.method_10569("offset", -1);
                    this.sendCommand("clothing", compound);
                }));
                this.method_37063((class_364)new class_4185(this.field_22789 / 2 + 87, y, 87, 20, (class_2561)class_2561.method_43471((String)"gui.villager_editor.next"), b -> {
                    class_2487 compound = new class_2487();
                    compound.method_10569("offset", 1);
                    this.sendCommand("clothing", compound);
                }));
                this.method_37063((class_364)new ColorPickerWidget(this.field_22789 / 2 + margin, y += 22, 175 - margin * 2, 175 - margin * 2, genetics.getGene(Genetics.HEMOGLOBIN), genetics.getGene(Genetics.MELANIN), MCA.locate("textures/colormap/villager_skin.png"), (vx, vy) -> {
                    genetics.setGene(Genetics.HEMOGLOBIN, vx.floatValue());
                    genetics.setGene(Genetics.MELANIN, vy.floatValue());
                }));
                break;
            }
            case "head": {
                y = this.doubleGeneSliders(y, Genetics.FACE);
                y = this.doubleGeneSliders(y, Genetics.VOICE_TONE, Genetics.VOICE);
                this.method_37063((class_364)new class_4185(this.field_22789 / 2, y, 87, 20, (class_2561)class_2561.method_43471((String)"gui.villager_editor.randHair"), b -> this.sendCommand("hair")));
                this.method_37063((class_364)new class_4185(this.field_22789 / 2 + 87, y, 87, 20, (class_2561)class_2561.method_43471((String)"gui.villager_editor.selectHair"), b -> this.setPage("hair")));
                this.method_37063((class_364)new class_4185(this.field_22789 / 2, y += 22, 87, 20, (class_2561)class_2561.method_43471((String)"gui.villager_editor.prev"), b -> {
                    class_2487 compound = new class_2487();
                    compound.method_10569("offset", -1);
                    this.sendCommand("hair", compound);
                }));
                this.method_37063((class_364)new class_4185(this.field_22789 / 2 + 87, y, 87, 20, (class_2561)class_2561.method_43471((String)"gui.villager_editor.next"), b -> {
                    class_2487 compound = new class_2487();
                    compound.method_10569("offset", 1);
                    this.sendCommand("hair", compound);
                }));
                this.method_37063((class_364)new ColorPickerWidget(this.field_22789 / 2 + margin, y += 22, 175 - margin * 2, 175 - margin * 2, genetics.getGene(Genetics.PHEOMELANIN), genetics.getGene(Genetics.EUMELANIN), MCA.locate("textures/colormap/villager_hair.png"), (vx, vy) -> {
                    genetics.setGene(Genetics.PHEOMELANIN, vx.floatValue());
                    genetics.setGene(Genetics.EUMELANIN, vy.floatValue());
                }));
                break;
            }
            case "personality": {
                LinkedList<class_4185> linkedList = new LinkedList<class_4185>();
                int row = 0;
                int BUTTONS_PER_ROW = 2;
                for (Personality p : Personality.values()) {
                    if (p == Personality.UNASSIGNED) continue;
                    if (row == 2) {
                        row = 0;
                        y += 19;
                    }
                    class_4185 widget = (class_4185)this.method_37063((class_364)new class_4185(this.field_22789 / 2 + 87 * row, y, 87, 20, p.getName(), b -> {
                        this.villager.getVillagerBrain().setPersonality(p);
                        personalityButtons.forEach(v -> {
                            v.field_22763 = true;
                        });
                        b.field_22763 = false;
                    }));
                    widget.field_22763 = p != this.villager.getVillagerBrain().getPersonality();
                    linkedList.add(widget);
                    ++row;
                }
                break;
            }
            case "traits": {
                int index;
                this.method_37063((class_364)new class_4185(this.field_22789 / 2, y, 32, 20, (class_2561)class_2561.method_43470((String)"<"), b -> this.setTraitPage(this.traitPage - 1)));
                this.method_37063((class_364)new class_4185(this.field_22789 / 2 + 175 - 32, y, 32, 20, (class_2561)class_2561.method_43470((String)">"), b -> this.setTraitPage(this.traitPage + 1)));
                this.method_37063((class_364)new class_4185(this.field_22789 / 2 + 32, y, 111, 20, (class_2561)class_2561.method_43469((String)"gui.villager_editor.page", (Object[])new Object[]{this.traitPage + 1}), b -> ++this.traitPage));
                y += 22;
                Traits.Trait[] traitArray = this.getValidTraits();
                for (int i = 0; i < 8 && (index = i + this.traitPage * 8) < traitArray.length; ++i) {
                    Traits.Trait t = traitArray[index];
                    class_5250 name2 = t.getName().method_27661().method_27692(this.villager.getTraits().hasTrait(t) ? class_124.field_1060 : class_124.field_1080);
                    this.method_37063((class_364)new class_4185(this.field_22789 / 2, y, 175, 20, (class_2561)name2, b -> {
                        if (this.villager.getTraits().hasTrait(t)) {
                            this.villager.getTraits().removeTrait(t);
                        } else {
                            this.villager.getTraits().addTrait(t);
                        }
                        b.method_25355((class_2561)t.getName().method_27661().method_27692(this.villager.getTraits().hasTrait(t) ? class_124.field_1060 : class_124.field_1080));
                    }));
                    y += 20;
                }
                break;
            }
            case "debug": {
                boolean bl = false;
                LinkedList<class_4185> professionButtons = new LinkedList<class_4185>();
                for (class_3852 p : new class_3852[]{class_3852.field_17051, (class_3852)ProfessionsMCA.GUARD.get(), (class_3852)ProfessionsMCA.ARCHER.get(), (class_3852)ProfessionsMCA.OUTLAW.get(), (class_3852)ProfessionsMCA.ADVENTURER.get(), (class_3852)ProfessionsMCA.CULTIST.get()}) {
                    boolean bl2;
                    class_5250 text = class_2561.method_43471((String)("entity.minecraft.villager." + p));
                    class_4185 widget = (class_4185)this.method_37063((class_364)new class_4185(this.field_22789 / 2 + (bl2 ? 87 : 0), y, 87, 20, (class_2561)text, b -> {
                        class_2487 compound = new class_2487();
                        compound.method_10582("profession", class_2378.field_17167.method_10221((Object)p).toString());
                        this.syncVillagerData();
                        NetworkHandler.sendToServer(new VillagerEditorSyncRequest("profession", this.villagerUUID, compound));
                        this.requestVillagerData();
                        professionButtons.forEach(button -> {
                            button.field_22763 = true;
                        });
                        b.field_22763 = false;
                    }));
                    professionButtons.add(widget);
                    boolean bl3 = widget.field_22763 = this.villager.getProfession() != p;
                    if (bl2) {
                        y += 20;
                    }
                    bl2 = !bl2;
                }
                this.method_37063((class_364)new GeneSliderWidget(this.field_22789 / 2, y += 4, 175, 20, (class_2561)class_2561.method_43471((String)"gui.villager_editor.infection"), this.villager.getInfectionProgress(), b -> {
                    this.villager.setInfected(b > 0.0);
                    this.villager.setInfectionProgress(b.floatValue());
                }));
                y += 22;
                assert (this.field_22787 != null);
                assert (this.field_22787.field_1724 != null);
                Memories player = this.villager.getVillagerBrain().getMemoriesForPlayer((class_1657)this.field_22787.field_1724);
                y = this.integerChanger(y, player::modHearts, () -> class_2561.method_43469((String)"gui.blueprint.reputation", (Object[])new Object[]{player.getHearts()}));
                this.integerChanger(y, v -> this.villager.getVillagerBrain().modifyMoodValue((int)v), () -> class_2561.method_43469((String)"gui.interact.label.mood", (Object[])new Object[]{this.villager.getVillagerBrain().getMoodValue()}));
                break;
            }
            case "clothing": 
            case "hair": {
                this.filterGender = this.villager.getGenetics().getGender();
                this.searchString = "";
                class_342 textFieldWidget = (class_342)this.method_37063((class_364)new class_342(this.field_22793, this.field_22789 / 2 - 87, this.field_22790 / 2 - 100, 175, 18, (class_2561)class_2561.method_43471((String)"gui.villager_editor.search")));
                textFieldWidget.method_1880(64);
                textFieldWidget.method_1863(v -> {
                    this.searchString = v;
                    this.filter();
                });
                y = this.field_22790 / 2 + 85;
                this.pageButtonWidget = (class_4185)this.method_37063((class_364)new class_4185(this.field_22789 / 2 - 30, y, 60, 20, (class_2561)class_2561.method_43470((String)""), b -> {}));
                this.method_37063((class_364)new class_4185(this.field_22789 / 2 - 32 - 28, y, 28, 20, (class_2561)class_2561.method_43470((String)"<<"), b -> {
                    this.clothingPage = Math.max(0, this.clothingPage - 1);
                    this.updateClothingPageWidget();
                }));
                this.method_37063((class_364)new class_4185(this.field_22789 / 2 + 32, y, 28, 20, (class_2561)class_2561.method_43470((String)">>"), b -> {
                    this.clothingPage = Math.max(0, Math.min(this.clothingPageCount - 1, this.clothingPage + 1));
                    this.updateClothingPageWidget();
                }));
                this.method_37063((class_364)new class_4185(this.field_22789 / 2 + 32 + 32, y, 128, 20, (class_2561)class_2561.method_43471((String)"gui.button.done"), b -> {
                    if (page.equals("clothing")) {
                        this.setPage("body");
                    } else {
                        this.setPage("head");
                    }
                }));
                this.widgetMasculine = (class_4185)this.method_37063((class_364)new class_4185(this.field_22789 / 2 - 32 - 96 - 64, y, 64, 20, (class_2561)class_2561.method_43471((String)"gui.villager_editor.masculine"), b -> {
                    this.filterGender = Gender.MALE;
                    this.filter();
                    this.widgetMasculine.field_22763 = false;
                    this.widgetFeminine.field_22763 = true;
                }));
                this.widgetMasculine.field_22763 = this.filterGender != Gender.MALE;
                this.widgetFeminine = (class_4185)this.method_37063((class_364)new class_4185(this.field_22789 / 2 - 32 - 96 - 64 + 64, y, 64, 20, (class_2561)class_2561.method_43471((String)"gui.villager_editor.feminine"), b -> {
                    this.filterGender = Gender.FEMALE;
                    this.filter();
                    this.widgetMasculine.field_22763 = true;
                    this.widgetFeminine.field_22763 = false;
                }));
                this.widgetFeminine.field_22763 = this.filterGender != Gender.FEMALE;
                this.filter();
            }
        }
    }

    private Traits.Trait[] getValidTraits() {
        return (Traits.Trait[])Arrays.stream(Traits.Trait.values()).filter((? super T e) -> {
            if (this.villagerUUID.equals(this.playerUUID)) {
                return (Config.getInstance().bypassTraitRestrictions || e.isUsableOnPlayer()) && e.isEnabled();
            }
            return e.isEnabled();
        }).toList().toArray(Traits.Trait[]::new);
    }

    private void updateClothingPageWidget() {
        if (this.pageButtonWidget != null) {
            this.pageButtonWidget.method_25355((class_2561)class_2561.method_43470((String)String.format("%d / %d", this.clothingPage + 1, this.clothingPageCount)));
        }
    }

    private void filter() {
        if (Objects.equals(this.page, "clothing")) {
            this.filteredClothing = this.filter(clothing);
        } else {
            this.filteredHair = this.filter(hair);
        }
    }

    private <T extends ClothingList.ListEntry> List<String> filter(HashMap<String, T> map) {
        List<String> filtered = map.entrySet().stream().filter((? super T v) -> this.filterGender == ((ClothingList.ListEntry)v.getValue()).gender || ((ClothingList.ListEntry)v.getValue()).gender == Gender.NEUTRAL).filter((? super T v) -> {
            Object patt21822$temp = v.getValue();
            if (patt21822$temp instanceof ClothingList.Clothing) {
                ClothingList.Clothing c = (ClothingList.Clothing)patt21822$temp;
                return !c.exclude;
            }
            return true;
        }).filter((? super T v) -> MCA.isBlankString(this.searchString) || ((String)v.getKey()).contains(this.searchString)).map(Map.Entry::getKey).toList();
        this.clothingPageCount = (int)Math.ceil((float)filtered.size() / (float)this.CLOTHES_PER_PAGE);
        this.clothingPage = Math.max(0, Math.min(this.clothingPage, this.clothingPageCount - 1));
        this.updateClothingPageWidget();
        return filtered;
    }

    protected String[] getPages() {
        if (this.villagerUUID.equals(this.playerUUID)) {
            return new String[]{"general", "body", "head", "traits"};
        }
        return new String[]{"general", "body", "head", "personality", "traits", "debug"};
    }

    protected void drawName(int x, int y) {
        this.drawName(x, y, name -> {
            this.updateName((String)name);
            if (this.doneWidget != null) {
                this.doneWidget.field_22763 = !MCA.isBlankString(name);
            }
        });
    }

    protected void drawName(int x, int y, Consumer<String> onChanged) {
        this.villagerNameField = (class_342)this.method_37063((class_364)new class_342(this.field_22793, x, y, 116, 18, (class_2561)class_2561.method_43471((String)"structure_block.structure_name")));
        this.villagerNameField.method_1880(32);
        this.villagerNameField.method_1852(this.getName().getString());
        this.villagerNameField.method_1863(onChanged);
        this.method_37063((class_364)new class_4185(x + 116 + 1, y - 1, 56, 20, (class_2561)class_2561.method_43471((String)"gui.button.random"), b -> NetworkHandler.sendToServer(new VillagerNameRequest(this.villager.getGenetics().getGender()))));
    }

    public class_2561 getName() {
        class_2561 villagerName = null;
        boolean isPlayer = this.villagerUUID.equals(this.playerUUID);
        if (isPlayer) {
            assert (this.field_22787 != null);
            assert (this.field_22787.field_1724 != null);
            villagerName = this.field_22787.field_1724.method_5797();
        } else if (this.villager.method_16914()) {
            villagerName = this.villager.method_5797();
        }
        if (villagerName == null || MCA.isBlankString(villagerName.getString())) {
            if (isPlayer) {
                assert (this.field_22787 != null);
                assert (this.field_22787.field_1724 != null);
                villagerName = this.field_22787.field_1724.method_5477();
            } else {
                villagerName = this.villager.method_5477();
            }
            if (villagerName == null || MCA.isBlankString(villagerName.getString())) {
                NetworkHandler.sendToServer(new VillagerNameRequest(this.villager.getGenetics().getGender()));
            } else {
                this.updateName(villagerName.getString());
            }
        }
        return villagerName;
    }

    public void updateName(String name) {
        if (!MCA.isBlankString(name)) {
            class_2561 newName = class_2561.method_30163((String)name);
            boolean isPlayer = this.villagerUUID.equals(this.playerUUID);
            if (isPlayer) {
                assert (this.field_22787 != null);
                assert (this.field_22787.field_1724 != null);
                class_2561 realName = this.field_22787.field_1724.method_5477();
                if (realName.getString().equals(name)) {
                    newName = null;
                }
                this.field_22787.field_1724.method_5665(newName);
                this.field_22787.field_1724.method_5880(newName != null);
                if (this.field_22787.field_1724.method_5807()) {
                    this.villager.method_5665(newName);
                } else {
                    this.villager.setName(realName.getString());
                }
            } else {
                this.villager.method_5665(newName);
            }
        }
    }

    void drawGender(int x, int y) {
        this.genderButtonFemale = new class_4185(x, y, 87, 20, (class_2561)class_2561.method_43471((String)"gui.villager_editor.feminine"), sender -> {
            this.villager.getGenetics().setGender(Gender.FEMALE);
            this.sendCommand("gender");
            this.genderButtonFemale.field_22763 = false;
            this.genderButtonMale.field_22763 = true;
        });
        this.method_37063((class_364)this.genderButtonFemale);
        this.genderButtonMale = new class_4185(x + 87, y, 87, 20, (class_2561)class_2561.method_43471((String)"gui.villager_editor.masculine"), sender -> {
            this.villager.getGenetics().setGender(Gender.MALE);
            this.sendCommand("gender");
            this.genderButtonFemale.field_22763 = true;
            this.genderButtonMale.field_22763 = false;
        });
        this.method_37063((class_364)this.genderButtonMale);
        this.genderButtonFemale.field_22763 = this.villager.getGenetics().getGender() != Gender.FEMALE;
        this.genderButtonMale.field_22763 = this.villager.getGenetics().getGender() != Gender.MALE;
    }

    void drawModel(int x, int y) {
        if (this.allowPlayerModel && this.allowVillagerModel) {
            this.villagerSkinWidget = (class_4185)this.method_37063((class_364)new TooltipButtonWidget(x, y, 58, 20, "gui.villager_editor.villager_skin", b -> {
                this.villagerData.method_10569("playerModel", VillagerLike.PlayerModel.VILLAGER.ordinal());
                this.syncVillagerData();
                this.playerSkinWidget.field_22763 = true;
                this.villagerSkinWidget.field_22763 = false;
                this.vanillaSkinWidget.field_22763 = true;
            }));
            this.villagerSkinWidget.field_22763 = this.villagerData.method_10550("playerModel") != VillagerLike.PlayerModel.VILLAGER.ordinal();
            this.playerSkinWidget = (class_4185)this.method_37063((class_364)new TooltipButtonWidget(x + 58, y, 58, 20, "gui.villager_editor.player_skin", b -> {
                this.villagerData.method_10569("playerModel", VillagerLike.PlayerModel.PLAYER.ordinal());
                this.syncVillagerData();
                this.playerSkinWidget.field_22763 = false;
                this.villagerSkinWidget.field_22763 = true;
                this.vanillaSkinWidget.field_22763 = true;
            }));
            this.playerSkinWidget.field_22763 = this.villagerData.method_10550("playerModel") != VillagerLike.PlayerModel.PLAYER.ordinal();
            this.vanillaSkinWidget = (class_4185)this.method_37063((class_364)new TooltipButtonWidget(x + 116, y, 58, 20, "gui.villager_editor.vanilla_skin", b -> {
                this.villagerData.method_10569("playerModel", VillagerLike.PlayerModel.VANILLA.ordinal());
                this.syncVillagerData();
                this.villagerSkinWidget.field_22763 = true;
                this.playerSkinWidget.field_22763 = true;
                this.vanillaSkinWidget.field_22763 = false;
            }));
            this.vanillaSkinWidget.field_22763 = this.villagerData.method_10550("playerModel") != VillagerLike.PlayerModel.VANILLA.ordinal();
        }
    }

    private void sendCommand(String command) {
        this.sendCommand(command, new class_2487());
    }

    private void sendCommand(String command, class_2487 nbt) {
        this.syncVillagerData();
        NetworkHandler.sendToServer(new VillagerEditorSyncRequest(command, this.villagerUUID, nbt));
        this.requestVillagerData();
    }

    private void setTraitPage(int i) {
        Traits.Trait[] traits = this.getValidTraits();
        int maxPage = (int)Math.ceil((double)traits.length / 8.0) - 1;
        this.traitPage = Math.max(0, Math.min(maxPage, i));
        this.setPage("traits");
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.page.equals("clothing") && this.hoveredClothingId >= 0 && this.filteredClothing.size() > this.hoveredClothingId) {
            this.villager.setClothes(this.filteredClothing.get(this.hoveredClothingId));
            this.setPage("body");
            this.eventCallback("clothing");
            return true;
        }
        if (this.page.equals("hair") && this.hoveredClothingId >= 0 && this.filteredHair.size() > this.hoveredClothingId) {
            this.villager.setHair(this.filteredHair.get(this.hoveredClothingId));
            this.setPage("head");
            this.eventCallback("hair");
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    protected void eventCallback(String event) {
    }

    protected boolean shouldUsePlayerModel() {
        return false;
    }

    protected boolean shouldPrintPlayerHint() {
        return true;
    }

    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        this.method_25420(matrices);
        VillagerEditorScreen.method_25294((class_4587)matrices, (int)0, (int)20, (int)this.field_22789, (int)(this.field_22790 - 20), (int)0x66000000);
        if (this.villager == null) {
            return;
        }
        this.villager.field_6012 = (int)(System.currentTimeMillis() / 50L);
        if (this.shouldDrawEntity()) {
            int x = this.field_22789 / 2 - 87;
            int y = this.field_22790 / 2 + 70;
            if (this.villagerUUID.equals(this.playerUUID) && this.shouldUsePlayerModel()) {
                assert (class_310.method_1551().field_1724 != null);
                class_490.method_2486((int)x, (int)y, (int)60, (float)(x - mouseX), (float)(y - 50 - mouseY), (class_1309)class_310.method_1551().field_1724);
            } else {
                class_490.method_2486((int)x, (int)y, (int)60, (float)(x - mouseX), (float)(y - 50 - mouseY), (class_1309)this.villager);
            }
            if (this.shouldPrintPlayerHint() && this.villagerUUID.equals(this.playerUUID) && this.villagerData.method_10550("playerModel") != VillagerLike.PlayerModel.VILLAGER.ordinal()) {
                matrices.method_22903();
                matrices.method_22904((double)x, (double)(y - 145), 0.0);
                matrices.method_22905(0.5f, 0.5f, 0.5f);
                VillagerEditorScreen.method_27534((class_4587)matrices, (class_327)this.field_22793, (class_2561)class_2561.method_43471((String)"gui.villager_editor.model_hint"), (int)0, (int)0, (int)-1426063361);
                matrices.method_22909();
            }
        }
        if (this.page.equals("clothing") || this.page.equals("hair")) {
            class_2487 nbt = new class_2487();
            this.villager.method_5652(nbt);
            this.villagerVisualization.method_5749(nbt);
            this.villagerVisualization.method_5614(this.villager.method_5618());
            this.villagerVisualization.method_18382();
            int i = 0;
            this.hoveredClothingId = -1;
            block0: for (int y = 0; y < this.CLOTHES_V; ++y) {
                for (int x = 0; x < this.CLOTHES_H + y; ++x) {
                    int index = this.clothingPage * this.CLOTHES_PER_PAGE + i;
                    if ((this.page.equals("clothing") ? this.filteredClothing : this.filteredHair).size() <= index) continue block0;
                    this.villagerVisualization.field_6249 = (float)System.currentTimeMillis() / 50.0f + (float)i * 17.0f;
                    this.villagerVisualization.field_6225 = 1.5f;
                    if (this.page.equals("clothing")) {
                        this.villagerVisualization.setClothes(this.filteredClothing.get(index));
                    } else {
                        this.villagerVisualization.setHair(this.filteredHair.get(index));
                    }
                    int cx = this.field_22789 / 2 + (int)(((double)x - (double)this.CLOTHES_H / 2.0 + 0.5 - 0.5 * (double)(y % 2)) * 40.0);
                    int cy = this.field_22790 / 2 + 25 + (int)(((double)y - (double)this.CLOTHES_V / 2.0 + 0.5) * 65.0);
                    if (Math.abs(cx - mouseX) <= 20 && Math.abs(cy - mouseY - 30) <= 30) {
                        this.hoveredClothingId = index;
                    }
                    class_490.method_2486((int)cx, (int)cy, (int)(this.hoveredClothingId == index ? 35 : 30), (float)((float)(-(mouseX - cx)) / 2.0f), (float)((float)(-(mouseY - cy - 64)) / 2.0f), (class_1309)this.villagerVisualization);
                    ++i;
                }
            }
        }
        super.method_25394(matrices, mouseX, mouseY, delta);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        return super.method_25406(mouseX, mouseY, button);
    }

    protected boolean shouldDrawEntity() {
        return !this.page.equals("loading") && !this.page.equals("clothing") && !this.page.equals("hair");
    }

    protected boolean shouldShowPageSelection() {
        return !this.page.equals("clothing") && !this.page.equals("hair");
    }

    public void setVillagerName(String name) {
        this.villagerNameField.method_1852(name);
        this.updateName(name);
    }

    public void setVillagerData(class_2487 villagerData) {
        if (this.villager != null) {
            this.villagerData = villagerData;
            this.villager.method_5749(villagerData);
            this.villagerBreedingAge = villagerData.method_10550("Age");
            this.villager.method_5614(this.villagerBreedingAge);
            this.villager.method_18382();
        }
        if (this.page.equals("loading")) {
            this.setPage("general");
        } else {
            this.setPage(this.page);
        }
    }

    private void requestVillagerData() {
        NetworkHandler.sendToServer(new GetVillagerRequest(this.villagerUUID));
    }

    void syncVillagerData() {
        class_2487 nbt = this.villagerData;
        this.villager.method_5652(nbt);
        nbt.method_10569("Age", this.villagerBreedingAge);
        NetworkHandler.sendToServer(new VillagerEditorSyncRequest("sync", this.villagerUUID, nbt));
    }

    public void setSkinList(HashMap<String, ClothingList.Clothing> clothing, HashMap<String, HairList.Hair> hair) {
        VillagerEditorScreen.clothing = clothing;
        VillagerEditorScreen.hair = hair;
        this.filter();
    }

    private /* synthetic */ void lambda$setPage$6(String p, class_4185 sender) {
        this.setPage(p);
    }
}

