/*
 * Decompiled with CFR 0.152.
 */
package fabric.net.mca.entity.ai;

import fabric.net.mca.Config;
import fabric.net.mca.MCA;
import fabric.net.mca.advancement.criterion.CriterionMCA;
import fabric.net.mca.cobalt.network.NetworkHandler;
import fabric.net.mca.entity.VillagerEntityMCA;
import fabric.net.mca.entity.ai.Memories;
import fabric.net.mca.entity.ai.Pregnancy;
import fabric.net.mca.entity.ai.Relationship;
import fabric.net.mca.entity.interaction.gifts.GiftType;
import fabric.net.mca.entity.interaction.gifts.Response;
import fabric.net.mca.item.SpecialCaseGift;
import fabric.net.mca.network.s2c.AnalysisResults;
import fabric.net.mca.resources.data.analysis.IntAnalysis;
import fabric.net.mca.util.network.datasync.CDataManager;
import fabric.net.mca.util.network.datasync.CDataParameter;
import fabric.net.mca.util.network.datasync.CParameter;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1738;
import net.minecraft.class_1743;
import net.minecraft.class_1769;
import net.minecraft.class_1792;
import net.minecraft.class_1794;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1811;
import net.minecraft.class_1821;
import net.minecraft.class_1829;
import net.minecraft.class_1831;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_4174;

public class BreedableRelationship
extends Relationship<VillagerEntityMCA> {
    private static final CDataParameter<Boolean> IS_PROCREATING = CParameter.create("isProcreating", false);
    private int procreateTick = -1;
    private final Pregnancy pregnancy;

    public static <E extends class_1297> CDataManager.Builder<E> createTrackedData(CDataManager.Builder<E> builder) {
        return Relationship.createTrackedData(builder).addAll(IS_PROCREATING).add(Pregnancy::createTrackedData);
    }

    public BreedableRelationship(VillagerEntityMCA entity) {
        super(entity);
        this.pregnancy = new Pregnancy(entity);
    }

    public Pregnancy getPregnancy() {
        return this.pregnancy;
    }

    public boolean isProcreating() {
        return (Boolean)((VillagerEntityMCA)this.entity).getTrackedValue(IS_PROCREATING);
    }

    public void startProcreating() {
        this.procreateTick = 60;
        ((VillagerEntityMCA)this.entity).setTrackedValue(IS_PROCREATING, true);
    }

    public void tick(int age) {
        if (age % 20 == 0) {
            this.pregnancy.tick();
        }
        if (!this.isProcreating()) {
            return;
        }
        if (this.procreateTick > 0) {
            --this.procreateTick;
            ((VillagerEntityMCA)this.entity).method_5942().method_6340();
            ((VillagerEntityMCA)this.entity).field_6002.method_8421((class_1297)this.entity, (byte)12);
        } else {
            this.getFamilyTree().getOrCreate((class_1297)this.entity);
            this.getPartner().ifPresent(spouse -> {
                this.pregnancy.procreate((class_1297)spouse);
                ((VillagerEntityMCA)this.entity).setTrackedValue(IS_PROCREATING, false);
            });
        }
    }

    public void giveGift(class_3222 player, Memories memory) {
        class_1799 stack = player.method_6047();
        if (!stack.method_7960() && !this.handleSpecialCaseGift(player, stack)) {
            if (stack.method_7909() == class_1802.field_8463) {
                ((VillagerEntityMCA)this.entity).setInfected(false);
                ((VillagerEntityMCA)this.entity).method_18866(((VillagerEntityMCA)this.entity).field_6002, stack);
                stack.method_7934(1);
            } else {
                class_1792 class_17922 = stack.method_7909();
                if (class_17922 instanceof class_1769) {
                    class_1769 dye = (class_1769)class_17922;
                    ((VillagerEntityMCA)this.entity).setHairDye(dye.method_7802());
                    stack.method_7934(1);
                } else if (stack.method_7909() == class_1802.field_8554) {
                    ((VillagerEntityMCA)this.entity).clearHairDye();
                    stack.method_7934(1);
                } else if (stack.method_7909() == class_1802.field_8448) {
                    if (stack.method_7938()) {
                        ((VillagerEntityMCA)this.entity).setCustomSkin(stack.method_7964().getString());
                    } else {
                        ((VillagerEntityMCA)this.entity).setCustomSkin("");
                    }
                    stack.method_7934(1);
                } else {
                    Optional<GiftType> gift = GiftType.bestMatching((VillagerEntityMCA)this.entity, stack, player);
                    if (gift.isPresent()) {
                        this.acceptGift(stack, gift.get(), player, memory);
                    } else {
                        gift = this.handleDynamicGift(stack);
                        if (gift.isPresent()) {
                            this.acceptGift(stack, gift.get(), player, memory);
                        } else {
                            this.rejectGift((class_1657)player, "gift.fail");
                        }
                    }
                }
            }
        }
    }

    private Optional<GiftType> handleDynamicGift(class_1799 stack) {
        class_4174 component;
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof class_1829) {
            class_1829 sword = (class_1829)class_17922;
            float satisfaction = sword.method_8020();
            satisfaction = (float)(Math.pow(satisfaction, 1.25) * 2.0);
            return Optional.of(new GiftType(stack.method_7909(), (int)satisfaction, MCA.locate("swords")));
        }
        class_1792 satisfaction = stack.method_7909();
        if (satisfaction instanceof class_1811) {
            class_1811 ranged = (class_1811)satisfaction;
            float satisfaction2 = ranged.method_24792();
            satisfaction2 = (float)(Math.pow(satisfaction2, 1.25) * 2.0);
            return Optional.of(new GiftType(stack.method_7909(), (int)satisfaction2, MCA.locate("archery")));
        }
        satisfaction = stack.method_7909();
        if (satisfaction instanceof class_1831) {
            class_1831 tool = (class_1831)satisfaction;
            float satisfaction3 = tool.method_8022().method_8027();
            satisfaction3 = (float)(Math.pow(satisfaction3, 1.25) * 2.0);
            return Optional.of(new GiftType(stack.method_7909(), (int)satisfaction3, MCA.locate(stack.method_7909() instanceof class_1743 ? "swords" : (stack.method_7909() instanceof class_1794 ? "hoes" : (stack.method_7909() instanceof class_1821 ? "shovels" : "pickaxes")))));
        }
        satisfaction = stack.method_7909();
        if (satisfaction instanceof class_1738) {
            class_1738 armor = (class_1738)satisfaction;
            int satisfaction4 = (int)(Math.pow(armor.method_7687(), 1.25) * 1.5 + (double)(armor.method_7686().method_7700() * 5.0f));
            return Optional.of(new GiftType(stack.method_7909(), satisfaction4, MCA.locate("armor")));
        }
        if (stack.method_7909().method_19263() && (component = stack.method_7909().method_19264()) != null) {
            int satisfaction5 = (int)((float)component.method_19230() + component.method_19231() * 3.0f);
            return Optional.of(new GiftType(stack.method_7909(), satisfaction5, MCA.locate("food")));
        }
        return Optional.empty();
    }

    private void acceptGift(class_1799 stack, GiftType gift, class_3222 player, Memories memory) {
        if (!((VillagerEntityMCA)this.entity).method_35199().method_27070(stack)) {
            this.rejectGift((class_1657)player, "villager.inventory.full");
            return;
        }
        IntAnalysis analysis = gift.getSatisfactionFor((VillagerEntityMCA)this.entity, stack, player);
        int satisfaction = analysis.getTotal();
        Response response = gift.getResponse(satisfaction);
        int occurrences = this.getGiftSaturation().get(stack);
        int penalty = (int)((double)((float)occurrences * Config.getInstance().giftDesaturationFactor) * Math.pow(Math.max((double)satisfaction, 0.0), Config.getInstance().giftDesaturationExponent));
        if (penalty != 0) {
            analysis.add("desaturation", -penalty);
        }
        int desaturatedSatisfaction = analysis.getTotal();
        Response desaturatedResponse = gift.getResponse(desaturatedSatisfaction);
        desaturatedSatisfaction = (int)((double)desaturatedSatisfaction * Config.getInstance().giftSatisfactionFactor);
        NetworkHandler.sendToPlayer(new AnalysisResults(analysis), player);
        if (response == Response.FAIL) {
            this.rejectGift((class_1657)player, gift.getDialogueFor(response));
        } else if (desaturatedResponse == Response.FAIL) {
            this.rejectGift((class_1657)player, "gift.saturated");
        } else {
            ((VillagerEntityMCA)this.entity).sendChatMessage((class_1657)player, gift.getDialogueFor(response), new Object[0]);
            if (response == Response.BEST) {
                ((VillagerEntityMCA)this.entity).playSurprisedSound();
            }
            this.getGiftSaturation().add(stack);
            ((VillagerEntityMCA)this.entity).field_6002.method_8421((class_1297)this.entity, (byte)16);
            ((VillagerEntityMCA)this.entity).method_35199().method_5491(stack.method_7971(1));
        }
        ((VillagerEntityMCA)this.entity).getVillagerBrain().modifyMoodValue((int)((float)desaturatedSatisfaction * Config.getInstance().giftMoodEffect + Config.getInstance().baseGiftMoodEffect * (float)class_3532.method_17822((double)desaturatedSatisfaction)));
        CriterionMCA.HEARTS_CRITERION.trigger(player, memory.getHearts(), desaturatedSatisfaction, "gift");
        memory.modHearts(desaturatedSatisfaction);
    }

    private void rejectGift(class_1657 player, String dialogue) {
        ((VillagerEntityMCA)this.entity).field_6002.method_8421((class_1297)this.entity, (byte)15);
        ((VillagerEntityMCA)this.entity).sendChatMessage(player, dialogue, new Object[0]);
    }

    private boolean handleSpecialCaseGift(class_3222 player, class_1799 stack) {
        class_1792 item = stack.method_7909();
        if (item instanceof SpecialCaseGift) {
            if (((SpecialCaseGift)item).handle(player, (VillagerEntityMCA)this.entity)) {
                stack.method_7934(1);
            }
            return true;
        }
        if (item == class_1802.field_17534 && !((VillagerEntityMCA)this.entity).method_6109()) {
            if (this.pregnancy.tryStartGestation()) {
                player.field_6002.method_8421((class_1297)this.entity, (byte)12);
                stack.method_7934(1);
                ((VillagerEntityMCA)this.entity).sendChatMessage((class_1657)player, "gift.cake.success", new Object[0]);
            } else {
                ((VillagerEntityMCA)this.entity).sendChatMessage((class_1657)player, "gift.cake.fail", new Object[0]);
            }
            return true;
        }
        if (item == class_1802.field_8463 && ((VillagerEntityMCA)this.entity).method_6109()) {
            ((VillagerEntityMCA)this.entity).method_5615(6000);
            stack.method_7934(1);
            return true;
        }
        return false;
    }
}

