/*
 * Decompiled with CFR 0.152.
 */
package fabric.net.mca.server;

import fabric.net.mca.Config;
import fabric.net.mca.MCA;
import fabric.net.mca.ducks.IVillagerEntity;
import fabric.net.mca.entity.VillagerEntityMCA;
import fabric.net.mca.entity.VillagerFactory;
import fabric.net.mca.entity.ZombieVillagerEntityMCA;
import fabric.net.mca.entity.ZombieVillagerFactory;
import fabric.net.mca.entity.ai.relationship.Gender;
import fabric.net.mca.server.world.data.Nationality;
import java.util.Locale;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.minecraft.class_1297;
import net.minecraft.class_1314;
import net.minecraft.class_1641;
import net.minecraft.class_1646;
import net.minecraft.class_2378;
import net.minecraft.class_3218;
import net.minecraft.class_3730;

public class SpawnQueue {
    private static final SpawnQueue INSTANCE = new SpawnQueue();
    private final ConcurrentLinkedQueue<class_1646> villagerSpawnQueue = new ConcurrentLinkedQueue();
    private final ConcurrentLinkedQueue<class_1641> zombieVillagerSpawnQueue = new ConcurrentLinkedQueue();

    public static SpawnQueue getInstance() {
        return INSTANCE;
    }

    public void tick() {
        class_1646 e;
        if (!this.villagerSpawnQueue.isEmpty()) {
            e = this.villagerSpawnQueue.poll();
            MCA.executorService.execute(() -> {
                if (e.field_6002.method_8477(e.method_24515())) {
                    e.method_31472();
                    VillagerEntityMCA villager = VillagerFactory.newVillager(e.field_6002).withName(e.method_16914() ? e.method_5477().getString() : null).withGender(Gender.getRandom()).withAge(e.method_5618()).withPosition((class_1297)e).withType(e.method_7231().method_16919()).withProfession(e.method_7231().method_16924(), e.method_7231().method_16925(), e.method_8264()).spawn(((IVillagerEntity)e).getSpawnReason());
                    this.copyPastaIntensifies((class_1314)villager, (class_1314)e);
                } else {
                    this.villagerSpawnQueue.add(e);
                }
            });
        }
        if (!this.zombieVillagerSpawnQueue.isEmpty()) {
            e = this.zombieVillagerSpawnQueue.poll();
            MCA.executorService.execute(() -> this.lambda$tick$1((class_1641)e));
        }
    }

    private void copyPastaIntensifies(class_1314 villager, class_1314 entity) {
        if (entity.method_5947()) {
            villager.method_5971();
        }
        if (entity.method_5655()) {
            villager.method_5684(true);
        }
        if (entity.method_5987()) {
            villager.method_5977(true);
        }
        for (String tag : entity.method_5752()) {
            villager.method_5780(tag);
        }
    }

    public static boolean shouldGetConverted(class_1297 entity) {
        if (Config.getInstance().fractionOfVanillaVillages <= 0.0f) {
            return true;
        }
        int i = Nationality.get((class_3218)entity.method_37908()).getRegionId(entity.method_24515());
        return (double)Math.floorMod(i, 100) >= (double)Config.getInstance().fractionOfVanillaVillages * 100.0;
    }

    public boolean addVillager(class_1297 entity) {
        IVillagerEntity villagerEntity;
        if (entity instanceof IVillagerEntity && !this.handlesSpawnReason((villagerEntity = (IVillagerEntity)entity).getSpawnReason())) {
            return false;
        }
        if (Config.getInstance().villagerDimensionBlacklist.contains(entity.method_5770().method_27983().method_29177().toString())) {
            return false;
        }
        if (Config.getInstance().overwriteOriginalVillagers && (entity.getClass().equals(class_1646.class) || Config.getInstance().moddedVillagerWhitelist.contains(class_2378.field_11145.method_10221((Object)entity.method_5864()).toString()) && entity instanceof class_1646) && SpawnQueue.shouldGetConverted(entity) && !this.villagerSpawnQueue.contains(entity)) {
            return this.villagerSpawnQueue.add((class_1646)entity);
        }
        if (Config.getInstance().overwriteOriginalZombieVillagers && (entity.getClass().equals(class_1641.class) || Config.getInstance().moddedZombieVillagerWhitelist.contains(class_2378.field_11145.method_10221((Object)entity.method_5864()).toString()) && entity instanceof class_1641) && !this.zombieVillagerSpawnQueue.contains(entity)) {
            return this.zombieVillagerSpawnQueue.add((class_1641)entity);
        }
        return false;
    }

    private boolean handlesSpawnReason(class_3730 reason) {
        return Config.getInstance().allowedSpawnReasons.contains(reason.name().toLowerCase(Locale.ROOT));
    }

    public void convert(class_1646 villager) {
        this.villagerSpawnQueue.add(villager);
    }

    private /* synthetic */ void lambda$tick$1(class_1641 e) {
        if (e.field_6002.method_8477(e.method_24515())) {
            e.method_31472();
            ZombieVillagerEntityMCA villager = ZombieVillagerFactory.newVillager(e.field_6002).withName(e.method_16914() ? e.method_5477().getString() : null).withGender(Gender.getRandom()).withPosition((class_1297)e).withType(e.method_7231().method_16919()).withProfession(e.method_7231().method_16924(), e.method_7231().method_16925()).spawn(((IVillagerEntity)e).getSpawnReason());
            this.copyPastaIntensifies((class_1314)villager, (class_1314)e);
        } else {
            this.zombieVillagerSpawnQueue.add(e);
        }
    }
}

