/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.client.render;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.blaze3d.vertex.PoseStack;
import forge.net.mca.Config;
import forge.net.mca.client.model.VillagerEntityBaseModelMCA;
import forge.net.mca.client.model.VillagerEntityModelMCA;
import forge.net.mca.entity.Infectable;
import forge.net.mca.entity.VillagerLike;
import forge.net.mca.entity.ai.relationship.AgeState;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.HumanoidMobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.core.UUIDUtil;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;

public class VillagerLikeEntityMCARenderer<T extends Mob>
extends HumanoidMobRenderer<T, VillagerEntityModelMCA<T>> {
    public VillagerLikeEntityMCARenderer(EntityRendererProvider.Context ctx, VillagerEntityModelMCA<T> model) {
        super(ctx, model, 0.5f);
        this.m_115326_((RenderLayer)new HumanoidArmorLayer((RenderLayerParent)this, this.createArmorModel(0.3f), this.createArmorModel(0.55f)));
    }

    private VillagerEntityBaseModelMCA<T> createArmorModel(float modelSize) {
        return new VillagerEntityBaseModelMCA(LayerDefinition.m_171565_((MeshDefinition)VillagerEntityBaseModelMCA.getModelData(new CubeDeformation(modelSize)), (int)64, (int)32).m_171564_());
    }

    protected void scale(T villager, PoseStack matrices, float tickDelta) {
        float height = ((VillagerLike)villager).getRawScaleFactor();
        float width = ((VillagerLike)villager).getHorizontalScaleFactor();
        matrices.m_85841_(width, height, width);
        if (((VillagerLike)villager).getAgeState() == AgeState.BABY && !villager.m_20159_()) {
            matrices.m_85837_(0.0, (double)0.6f, 0.0);
        }
    }

    @Nullable
    protected RenderType getRenderLayer(T entity, boolean showBody, boolean translucent, boolean showOutlines) {
        if (((VillagerLike)entity).hasCustomSkin()) {
            Minecraft minecraftClient = Minecraft.m_91087_();
            Map map = minecraftClient.m_91109_().m_118815_(((VillagerLike)entity).getGameProfile());
            return map.containsKey(MinecraftProfileTexture.Type.SKIN) ? RenderType.m_110473_((ResourceLocation)minecraftClient.m_91109_().m_118825_((MinecraftProfileTexture)map.get(MinecraftProfileTexture.Type.SKIN), MinecraftProfileTexture.Type.SKIN)) : RenderType.m_110458_((ResourceLocation)DefaultPlayerSkin.m_118627_((UUID)UUIDUtil.m_235875_((GameProfile)((VillagerLike)entity).getGameProfile())));
        }
        return null;
    }

    protected boolean m_6512_(T villager) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        return player != null && Config.getInstance().showNameTags && player.m_20280_(villager) < Math.pow(Config.getInstance().nameTagDistance, 2.0) && !villager.m_20177_((Player)player);
    }

    protected boolean isShaking(T entity) {
        return ((Infectable)entity).getInfectionProgress() > 0.2f;
    }
}

