/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.entity.ai;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import forge.net.mca.Config;
import forge.net.mca.MCA;
import forge.net.mca.entity.VillagerEntityMCA;
import forge.net.mca.entity.ai.gpt3Modules.EnvironmentModule;
import forge.net.mca.entity.ai.gpt3Modules.PersonalityModule;
import forge.net.mca.entity.ai.gpt3Modules.PlayerModule;
import forge.net.mca.entity.ai.gpt3Modules.RelationModule;
import forge.net.mca.entity.ai.gpt3Modules.TraitsModule;
import forge.net.mca.entity.ai.gpt3Modules.VillageModule;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import org.apache.commons.io.IOUtils;

public class GPT3 {
    public static final String URL = "http://snoweagle.tk/";
    private static final int MIN_MEMORY = 100;
    private static final int MAX_MEMORY = 600;
    private static final int MAX_MEMORY_TIME = 54000;
    private static final int CONVERSATION_TIME = 1200;
    private static final int CONVERSATION_DISTANCE = 16;
    private static final Map<UUID, List<String>> memory = new HashMap<UUID, List<String>>();
    private static final Map<UUID, Long> lastInteractions = new HashMap<UUID, Long>();
    private static final Map<UUID, UUID> lastInteraction = new HashMap<UUID, UUID>();

    public static String translate(String phrase) {
        return phrase.replaceAll("_", " ").toLowerCase(Locale.ROOT).replace("mca.", "");
    }

    public static Answer request(String encodedURL) {
        try {
            HttpURLConnection con = (HttpURLConnection)new URL(encodedURL).openConnection();
            con.setRequestProperty("Accept-Charset", StandardCharsets.UTF_8.toString());
            InputStream response = con.getInputStream();
            String body = IOUtils.toString((InputStream)response, (Charset)StandardCharsets.UTF_8);
            JsonObject map = JsonParser.parseString((String)body).getAsJsonObject();
            String answer = map.has("answer") ? map.get("answer").getAsString().trim().replace("\n", "") : "";
            String error = map.has("error") ? map.get("error").getAsString().trim().replace("\n", "") : null;
            return new Answer(answer, error);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new Answer(null, "unknown");
        }
    }

    public static Optional<String> answer(ServerPlayer player, VillagerEntityMCA villager, String msg) {
        try {
            String playerName = player.m_7755_().getString();
            String villagerName = villager.m_7755_().getString();
            long time = villager.f_19853_.m_46467_();
            if (time > lastInteractions.getOrDefault(villager.m_20148_(), 0L) + 54000L) {
                memory.remove(villager.m_20148_());
            }
            lastInteractions.put(villager.m_20148_(), time);
            lastInteraction.put(player.m_20148_(), villager.m_20148_());
            List pastDialogue = memory.computeIfAbsent(villager.m_20148_(), key -> new LinkedList());
            int MEMORY = 100 + Math.min(5, Config.getInstance().villagerChatAIIntelligence) * 500 / 5;
            while (pastDialogue.stream().mapToInt(v -> v.length() / 4).sum() > MEMORY) {
                pastDialogue.remove(0);
            }
            pastDialogue.add("$player: " + msg);
            LinkedList<String> input = new LinkedList<String>();
            PersonalityModule.apply(input, villager, player);
            TraitsModule.apply(input, villager, player);
            RelationModule.apply(input, villager, player);
            VillageModule.apply(input, villager, player);
            EnvironmentModule.apply(input, villager, player);
            PlayerModule.apply(input, villager, player);
            input.add("\n\n");
            for (String s2 : pastDialogue) {
                input.add(s2 + "\n");
            }
            input.add("$villager:");
            Map<String, String> variables = Map.of("player", playerName, "villager", villagerName);
            StringBuilder sb = new StringBuilder();
            for (String s3 : input) {
                for (Map.Entry<String, String> entry : variables.entrySet()) {
                    s3 = s3.replaceAll("\\$" + entry.getKey(), entry.getValue());
                }
                sb.append(s3);
            }
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("prompt", sb.toString());
            params.put("player", variables.get("player"));
            params.put("villager", variables.get("villager"));
            String encodedURL = params.keySet().stream().map(key -> key + "=" + URLEncoder.encode((String)params.get(key), StandardCharsets.UTF_8)).collect(Collectors.joining("&", "http://snoweagle.tk/chat?", ""));
            Answer message = GPT3.request(encodedURL);
            if (message.error == null) {
                pastDialogue.add(villagerName + ": " + message.answer);
                return Optional.ofNullable(message.answer);
            }
            if (message.error.equals("limit")) {
                MutableComponent styled = Component.m_237115_((String)"mca.limit.patreon").m_130938_(s -> s.m_131140_(ChatFormatting.GOLD).m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://github.com/Luke100000/minecraft-comes-alive/wiki/GPT3-based-conversations#increase-conversation-limit")).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237115_((String)"mca.limit.patreon.hover"))));
                player.m_5661_((Component)styled, false);
            } else if (message.error.equals("limit_premium")) {
                player.m_5661_((Component)Component.m_237115_((String)"mca.limit.premium").m_130940_(ChatFormatting.RED), false);
            } else {
                player.m_5661_((Component)Component.m_237115_((String)"mca.ai_broken").m_130940_(ChatFormatting.RED), false);
            }
        }
        catch (Exception e) {
            MCA.LOGGER.error((Object)e);
            player.m_5661_((Component)Component.m_237115_((String)"mca.ai_broken").m_130940_(ChatFormatting.RED), false);
        }
        return Optional.empty();
    }

    public static boolean inConversationWith(VillagerEntityMCA villager, ServerPlayer player) {
        return villager.m_20270_((Entity)player) < 16.0f && villager.f_19853_.m_46467_() < lastInteractions.getOrDefault(villager.m_20148_(), 0L) + 1200L && lastInteraction.getOrDefault(player.m_20148_(), Util.f_137441_).equals(villager.m_20148_());
    }

    public record Answer(String answer, String error) {
    }
}

