/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.entity.ai;

import forge.net.mca.ClientProxy;
import forge.net.mca.Config;
import forge.net.mca.MCA;
import forge.net.mca.cobalt.network.NetworkHandler;
import forge.net.mca.entity.EntityWrapper;
import forge.net.mca.entity.VillagerEntityMCA;
import forge.net.mca.entity.ai.DialogueType;
import forge.net.mca.entity.ai.relationship.family.FamilyTree;
import forge.net.mca.entity.ai.relationship.family.FamilyTreeNode;
import forge.net.mca.network.s2c.VillagerMessage;
import forge.net.mca.resources.API;
import forge.net.mca.server.world.data.PlayerSaveData;
import java.util.Locale;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public interface Messenger
extends EntityWrapper {
    public static final TargetingConditions CAN_RECEIVE = TargetingConditions.m_148353_();

    default public boolean isSpeechImpaired() {
        return false;
    }

    default public boolean isToYoungToSpeak() {
        return false;
    }

    default public void playSpeechEffect() {
    }

    default public DialogueType getDialogueType(Player receiver) {
        return DialogueType.UNASSIGNED;
    }

    default public MutableComponent getTranslatable(Player target, String phraseId, Object ... params) {
        Mob mob;
        String targetName;
        Object genderString = "";
        Level level = target.f_19853_;
        if (level instanceof ServerLevel) {
            ServerLevel world = (ServerLevel)level;
            targetName = FamilyTree.get(world).getOrEmpty(target.m_20148_()).map(FamilyTreeNode::getName).filter(n -> !MCA.isBlankString(n)).orElse(target.m_7755_().getString());
            genderString = "#G" + PlayerSaveData.get((ServerPlayer)target).getGender().name().toLowerCase(Locale.ROOT) + ".";
        } else {
            targetName = target.m_7755_().getString();
        }
        Object[] newParams = new Object[params.length + 1];
        System.arraycopy(params, 0, newParams, 1, params.length);
        newParams[0] = targetName;
        Object professionString = "";
        if (!this.asEntity().m_6162_() && (mob = this.asEntity()) instanceof VillagerEntityMCA) {
            VillagerEntityMCA v = (VillagerEntityMCA)mob;
            professionString = "#P" + Registry.f_122869_.m_7981_((Object)v.getProfession()).m_135815_() + ".";
        }
        Object personalityString = "";
        Mob mob2 = this.asEntity();
        if (mob2 instanceof VillagerEntityMCA) {
            VillagerEntityMCA v = (VillagerEntityMCA)mob2;
            personalityString = "#E" + v.getVillagerBrain().getPersonality().name() + ".";
        }
        return Component.m_237110_((String)((String)genderString + (String)personalityString + (String)professionString + "#T" + this.getDialogueType(target).name() + "." + phraseId), (Object[])newParams);
    }

    default public void sendChatToAllAround(MutableComponent phrase) {
        for (Player player : this.asEntity().f_19853_.m_45955_(CAN_RECEIVE, (LivingEntity)this.asEntity(), this.asEntity().m_20191_().m_82400_(20.0))) {
            float dist = player.m_20270_((Entity)this.asEntity());
            this.sendChatMessage(phrase.m_130940_(dist < 10.0f ? ChatFormatting.WHITE : ChatFormatting.GRAY), (Entity)player);
        }
    }

    default public void sendChatToAllAround(String phrase, Object ... params) {
        for (Player player : this.asEntity().f_19853_.m_45955_(CAN_RECEIVE, (LivingEntity)this.asEntity(), this.asEntity().m_20191_().m_82400_(20.0))) {
            float dist = player.m_20270_((Entity)this.asEntity());
            this.sendChatMessage(this.getTranslatable(player, phrase, params).m_130940_(dist < 10.0f ? ChatFormatting.WHITE : ChatFormatting.GRAY), (Entity)player);
        }
    }

    default public void sendChatMessage(Player target, String phraseId, Object ... params) {
        this.sendChatMessage(this.getTranslatable(target, phraseId, params), (Entity)target);
    }

    default public MutableComponent transformMessage(MutableComponent message) {
        if (this.isSpeechImpaired()) {
            return Component.m_237115_((String)API.getRandomSentence("zombie", message.getString()));
        }
        if (this.isToYoungToSpeak()) {
            return Component.m_237115_((String)API.getRandomSentence("baby", message.getString()));
        }
        return message;
    }

    default public MutableComponent sendChatMessage(MutableComponent message, Entity receiver) {
        message = this.transformMessage(message);
        MutableComponent textToSend = Component.m_237113_((String)Config.getInstance().villagerChatPrefix).m_7220_(this.asEntity().m_5446_()).m_130946_(": ").m_7220_((Component)message);
        VillagerMessage msg = new VillagerMessage(textToSend, this.asEntity().m_20148_());
        if (receiver instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)receiver;
            NetworkHandler.sendToPlayer(msg, serverPlayer);
        } else {
            ClientProxy.getNetworkHandler().handleVillagerMessage(msg);
        }
        this.playSpeechEffect();
        return message;
    }

    default public void sendEventMessage(Component message, Player receiver) {
        receiver.m_5661_(message, true);
    }

    default public void sendEventMessage(Component message) {
        if (!(this instanceof Entity)) {
            return;
        }
        Messenger.sendEventMessage(((Entity)this).f_19853_, message);
    }

    public static void sendEventMessage(Level world, Component message) {
        world.m_6907_().forEach(player -> player.m_5661_(message, true));
    }
}

