/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.entity.ai;

import forge.net.mca.Config;
import forge.net.mca.entity.VillagerEntityMCA;
import forge.net.mca.entity.ai.MemoryModuleTypeMCA;
import forge.net.mca.entity.ai.MoveState;
import forge.net.mca.server.world.data.GraveyardManager;
import forge.net.mca.server.world.data.Village;
import forge.net.mca.server.world.data.VillageManager;
import forge.net.mca.util.network.datasync.CDataManager;
import forge.net.mca.util.network.datasync.CDataParameter;
import forge.net.mca.util.network.datasync.CParameter;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.player.Player;

public class Residency {
    private static final CDataParameter<Integer> VILLAGE = CParameter.create("buildings", -1);
    private final VillagerEntityMCA entity;

    public static <E extends Entity> CDataManager.Builder<E> createTrackedData(CDataManager.Builder<E> builder) {
        return builder.addAll(VILLAGE);
    }

    public Residency(VillagerEntityMCA entity) {
        this.entity = entity;
    }

    public BlockPos getWorkplace() {
        return this.entity.m_6274_().m_21952_(MemoryModuleType.f_26360_).map(GlobalPos::m_122646_).orElse(BlockPos.f_121853_);
    }

    public void setWorkplace(ServerPlayer player) {
        PoiManager pointOfInterestStorage = player.m_9236_().m_8904_();
        pointOfInterestStorage.m_148658_(VillagerProfession.f_35585_.f_219629_(), a -> true, this.entity.m_20183_(), 8, PoiManager.Occupancy.HAS_SPACE).ifPresentOrElse(blockPos -> pointOfInterestStorage.m_27177_(blockPos).ifPresent(pointOfInterestType -> {
            pointOfInterestStorage.m_217946_(VillagerProfession.f_35585_.f_219629_(), (registryEntry, blockPos2) -> blockPos2.equals(blockPos), blockPos, 1);
            this.entity.m_35428_(MemoryModuleType.f_26361_);
            this.entity.m_6274_().m_21936_(MemoryModuleType.f_26361_);
            this.entity.m_35428_(MemoryModuleType.f_26360_);
            this.entity.m_6274_().m_21936_(MemoryModuleType.f_26360_);
            GlobalPos globalPos = GlobalPos.m_122643_((ResourceKey)player.m_9236_().m_46472_(), (BlockPos)blockPos);
            this.entity.m_6274_().m_21879_(MemoryModuleType.f_26360_, (Object)globalPos);
            player.m_9236_().m_7605_((Entity)this.entity, (byte)14);
            MinecraftServer minecraftServer = player.m_9236_().m_7654_();
            Optional.ofNullable(minecraftServer.m_129880_(globalPos.m_122640_())).flatMap(world -> world.m_8904_().m_27177_(globalPos.m_122646_())).flatMap(registryEntry -> Registry.f_122869_.m_123024_().filter(profession -> profession.f_219628_().test(registryEntry)).findFirst()).ifPresent(profession -> {
                this.entity.m_34375_(this.entity.m_7141_().m_35565_(profession));
                this.entity.m_35483_(player.m_9236_());
            });
            this.entity.sendChatMessage((Player)player, "interaction.setworkplace.success", new Object[0]);
        }), () -> this.entity.sendChatMessage((Player)player, "interaction.setworkplace.failed", new Object[0]));
    }

    public Optional<Village> getHomeVillage() {
        VillageManager manager = VillageManager.get((ServerLevel)this.entity.f_19853_);
        return manager.getOrEmpty((Integer)this.entity.getTrackedValue(VILLAGE));
    }

    public void seekHome() {
        if (this.entity.requiresHome()) {
            VillageManager manager = VillageManager.get((ServerLevel)this.entity.f_19853_);
            manager.findNearestVillage((Entity)this.entity).ifPresent(v -> {
                this.leaveHome();
                v.updateResident(this.entity);
                this.entity.setTrackedValue(VILLAGE, v.getId());
            });
        }
    }

    public void leaveHome() {
        Optional<Village> village = this.getHomeVillage();
        village.ifPresent(v -> v.removeResident(this.entity));
        this.entity.setTrackedValue(VILLAGE, -1);
    }

    public void tick() {
        if (this.entity.f_19797_ % 600 == 0 && this.entity.requiresHome()) {
            Optional<Village> village2 = this.getHomeVillage();
            if (village2.isEmpty() && Config.getInstance().enableAutoScanByDefault || village2.filter(Village::isAutoScan).isPresent()) {
                this.reportBuildings();
            }
            if (village2.isEmpty()) {
                this.seekHome();
            }
        }
        if (this.entity.f_19797_ % 1200 == 0) {
            this.getHomeVillage().ifPresentOrElse(village -> {
                int mood = village.popMood();
                if (mood != 0) {
                    this.entity.getVillagerBrain().modifyMoodValue(mood);
                }
                this.entity.f_19853_.m_6907_().forEach(player -> {
                    int rep = village.popHearts((Player)player);
                    if (rep != 0) {
                        this.entity.getVillagerBrain().getMemoriesForPlayer((Player)player).modHearts(rep);
                    }
                });
                this.entity.f_19853_.m_6907_().forEach(player -> {
                    int hearts = this.entity.getVillagerBrain().getMemoriesForPlayer((Player)player).getHearts();
                    village.setReputation((Player)player, this.entity, hearts);
                });
            }, this::leaveHome);
        }
    }

    private void reportBuildings() {
        VillageManager manager = VillageManager.get((ServerLevel)this.entity.f_19853_);
        Stream stream = ((ServerLevel)this.entity.f_19853_).m_8904_().m_27138_(type -> true, p -> !manager.cache.contains(p), this.entity.m_20183_(), 48, PoiManager.Occupancy.ANY);
        stream.forEach(manager::reportBuilding);
        GraveyardManager.get((ServerLevel)this.entity.f_19853_).reportToVillageManager((Entity)this.entity);
    }

    public void setHome(ServerPlayer player) {
        if (!this.entity.requiresHome()) {
            this.entity.sendChatMessage((Player)player, "interaction.sethome.temporary", new Object[0]);
            return;
        }
        VillageManager manager = VillageManager.get((ServerLevel)player.f_19853_);
        manager.processBuilding(player.m_20183_(), true, false);
        this.seekHome();
        PoiManager pointOfInterestStorage = player.m_9236_().m_8904_();
        Optional position = pointOfInterestStorage.m_27138_(registryEntry -> registryEntry.m_203565_(PoiTypes.f_218060_), p -> true, player.m_20183_(), 8, PoiManager.Occupancy.HAS_SPACE).findAny();
        if (position.isPresent()) {
            this.entity.sendChatMessage((Player)player, "interaction.sethome.success", new Object[0]);
            this.entity.m_6274_().m_21952_(MemoryModuleType.f_26359_).ifPresent(p -> {
                this.entity.m_35428_(MemoryModuleType.f_26359_);
                this.entity.m_6274_().m_21936_(MemoryModuleType.f_26359_);
            });
            pointOfInterestStorage.m_217946_(registryEntry -> registryEntry.m_203565_(PoiTypes.f_218060_), (p, q) -> true, (BlockPos)position.get(), 1);
            this.entity.m_6274_().m_21879_(MemoryModuleType.f_26359_, (Object)GlobalPos.m_122643_((ResourceKey)this.entity.f_19853_.m_46472_(), (BlockPos)((BlockPos)position.get())));
            this.entity.m_6274_().m_21879_((MemoryModuleType)MemoryModuleTypeMCA.FORCED_HOME.get(), (Object)true);
            this.seekHome();
        } else {
            this.entity.m_6274_().m_21936_((MemoryModuleType)MemoryModuleTypeMCA.FORCED_HOME.get());
            this.getHomeVillage().map(v -> v.getBuildingAt((Vec3i)this.entity.m_20183_())).filter(Optional::isPresent).map(Optional::get).filter(b -> b.getBuildingType().noBeds()).ifPresentOrElse(building -> this.entity.sendChatMessage((Player)player, "interaction.sethome.bedfail." + building.getBuildingType().name(), new Object[0]), () -> this.entity.sendChatMessage((Player)player, "interaction.sethome.bedfail", new Object[0]));
        }
    }

    public Optional<GlobalPos> getHome() {
        return this.entity.getMCABrain().m_21952_(MemoryModuleType.f_26359_);
    }

    public void goHome(Player player) {
        this.entity.getVillagerBrain().setMoveState(MoveState.MOVE, player);
        this.entity.getInteractions().stopInteracting();
        this.getHome().filter(p -> p.m_122640_() == this.entity.f_19853_.m_46472_()).ifPresentOrElse(home -> {
            this.entity.moveTowards(home.m_122646_());
            this.entity.sendChatMessage(player, "interaction.gohome.success", new Object[0]);
        }, () -> this.entity.sendChatMessage(player, "interaction.gohome.fail.nohome", new Object[0]));
    }
}

