/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.entity.interaction;

import forge.net.mca.Config;
import forge.net.mca.MCA;
import forge.net.mca.ProfessionsMCA;
import forge.net.mca.advancement.criterion.CriterionMCA;
import forge.net.mca.entity.VillagerEntityMCA;
import forge.net.mca.entity.ai.Chore;
import forge.net.mca.entity.ai.Memories;
import forge.net.mca.entity.ai.MoveState;
import forge.net.mca.entity.ai.relationship.RelationshipState;
import forge.net.mca.entity.ai.relationship.family.FamilyTree;
import forge.net.mca.entity.ai.relationship.family.FamilyTreeNode;
import forge.net.mca.entity.interaction.EntityCommandHandler;
import forge.net.mca.item.ItemsMCA;
import forge.net.mca.server.world.data.PlayerSaveData;
import forge.net.mca.util.WorldUtils;
import java.util.Comparator;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetPassengersPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Saddleable;
import net.minecraft.world.entity.ai.util.RandomPos;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class VillagerCommandHandler
extends EntityCommandHandler<VillagerEntityMCA> {
    public VillagerCommandHandler(VillagerEntityMCA entity) {
        super(entity);
    }

    @Override
    public boolean handle(ServerPlayer player, String command) {
        Memories memory = ((VillagerEntityMCA)this.entity).getVillagerBrain().getMemoriesForPlayer((Player)player);
        if (MoveState.byCommand(command).filter(state -> {
            ((VillagerEntityMCA)this.entity).getVillagerBrain().setMoveState((MoveState)((Object)state), (Player)player);
            return true;
        }).isPresent()) {
            return true;
        }
        if (Chore.byCommand(command).filter(chore -> {
            ((VillagerEntityMCA)this.entity).getVillagerBrain().assignJob((Chore)((Object)chore), (Player)player);
            CriterionMCA.GENERIC_EVENT_CRITERION.trigger(player, "chores");
            ((VillagerEntityMCA)this.entity).sendChatMessage(Component.m_237115_((String)"adult.chore.success"), (Entity)player);
            return true;
        }).isPresent()) {
            return true;
        }
        String arg = "";
        String[] split = command.split("\\.");
        if (split.length > 1) {
            command = split[0];
            arg = split[1];
        }
        switch (command) {
            case "pick_up": {
                if (player.m_20197_().size() >= 3) {
                    ((Entity)player.m_20197_().get(0)).m_8127_();
                }
                if (((VillagerEntityMCA)this.entity).m_20159_()) {
                    ((VillagerEntityMCA)this.entity).m_8127_();
                } else {
                    ((VillagerEntityMCA)this.entity).m_7998_((Entity)player, true);
                }
                player.f_8906_.m_9829_((Packet)new ClientboundSetPassengersPacket((Entity)player));
                return false;
            }
            case "ridehorse": {
                if (((VillagerEntityMCA)this.entity).m_20159_()) {
                    ((VillagerEntityMCA)this.entity).m_8127_();
                } else {
                    ((VillagerEntityMCA)this.entity).f_19853_.m_6249_((Entity)player, player.m_20191_().m_82400_(10.0), e -> e instanceof Saddleable && ((Saddleable)e).m_6254_()).stream().filter(horse -> !horse.m_20160_()).min(Comparator.comparingDouble(a -> a.m_20280_(this.entity))).ifPresentOrElse(horse -> {
                        ((VillagerEntityMCA)this.entity).m_7998_((Entity)horse, false);
                        ((VillagerEntityMCA)this.entity).sendChatMessage((Player)player, "interaction.ridehorse.success", new Object[0]);
                    }, () -> ((VillagerEntityMCA)this.entity).sendChatMessage((Player)player, "interaction.ridehorse.fail.notnearby", new Object[0]));
                }
                return true;
            }
            case "sethome": {
                ((VillagerEntityMCA)this.entity).getResidency().setHome(player);
                return true;
            }
            case "gohome": {
                ((VillagerEntityMCA)this.entity).getResidency().goHome((Player)player);
                this.stopInteracting();
                return false;
            }
            case "setworkplace": {
                ((VillagerEntityMCA)this.entity).getResidency().setWorkplace(player);
                return true;
            }
            case "trade": {
                ((VillagerEntityMCA)this.entity).getInteractions().stopInteracting();
                this.prepareOffersFor((Player)player);
                return false;
            }
            case "inventory": {
                player.m_5893_((MenuProvider)this.entity);
                return false;
            }
            case "gift": {
                ((VillagerEntityMCA)this.entity).getRelationships().giveGift(player, memory);
                return true;
            }
            case "adopt": {
                ((VillagerEntityMCA)this.entity).sendChatMessage((Player)player, "interaction.adopt.success", new Object[0]);
                FamilyTreeNode parentNode = FamilyTree.get(player.m_9236_()).getOrCreate((Entity)player);
                ((VillagerEntityMCA)this.entity).getRelationships().getFamilyEntry().assignParent(parentNode);
                Optional<FamilyTreeNode> parentSpouse = FamilyTree.get(player.m_9236_()).getOrEmpty(parentNode.partner());
                parentSpouse.ifPresent(p -> ((VillagerEntityMCA)this.entity).getRelationships().getFamilyEntry().assignParent((FamilyTreeNode)p));
                break;
            }
            case "procreate": {
                if (memory.getHearts() < 100) {
                    ((VillagerEntityMCA)this.entity).sendChatMessage((Player)player, "interaction.procreate.fail.lowhearts", new Object[0]);
                } else {
                    ((VillagerEntityMCA)this.entity).getRelationships().startProcreating();
                }
                return true;
            }
            case "divorcePapers": {
                player.m_150109_().m_36054_(new ItemStack((ItemLike)ItemsMCA.DIVORCE_PAPERS.get()));
                return true;
            }
            case "divorceConfirm": {
                ItemStack papers = ((Item)ItemsMCA.DIVORCE_PAPERS.get()).m_7968_();
                Memories memories = ((VillagerEntityMCA)this.entity).getVillagerBrain().getMemoriesForPlayer((Player)player);
                if (player.m_150109_().m_36063_(papers)) {
                    ((VillagerEntityMCA)this.entity).sendChatMessage((Player)player, "divorcePaper", new Object[0]);
                    player.m_150109_().m_36057_(papers);
                    memories.modHearts(-20);
                } else {
                    ((VillagerEntityMCA)this.entity).sendChatMessage((Player)player, "divorce", new Object[0]);
                    memories.modHearts(-200);
                }
                ((VillagerEntityMCA)this.entity).getVillagerBrain().modifyMoodValue(-5);
                ((VillagerEntityMCA)this.entity).getRelationships().endRelationShip(RelationshipState.SINGLE);
                PlayerSaveData playerData = PlayerSaveData.get(player);
                playerData.endRelationShip(RelationshipState.SINGLE);
                return true;
            }
            case "execute": {
                ((VillagerEntityMCA)this.entity).setProfession((VillagerProfession)ProfessionsMCA.OUTLAW.get());
                return true;
            }
            case "pardon": {
                ((VillagerEntityMCA)this.entity).setProfession(VillagerProfession.f_35585_);
                return true;
            }
            case "stay_in_village": {
                ((VillagerEntityMCA)this.entity).setProfession(VillagerProfession.f_35585_);
                ((VillagerEntityMCA)this.entity).setDespawnDelay(0);
                return true;
            }
            case "hire_short": {
                this.payEmeralds(player, 5);
                ((VillagerEntityMCA)this.entity).makeMercenary();
                ((VillagerEntityMCA)this.entity).setDespawnDelay(72000);
                return true;
            }
            case "hire_long": {
                this.payEmeralds(player, 10);
                ((VillagerEntityMCA)this.entity).makeMercenary();
                ((VillagerEntityMCA)this.entity).setDespawnDelay(168000);
                return true;
            }
            case "infected": {
                ((VillagerEntityMCA)this.entity).setInfected(!((VillagerEntityMCA)this.entity).isInfected());
                return true;
            }
            case "stopworking": {
                ((VillagerEntityMCA)this.entity).getVillagerBrain().abandonJob();
                return true;
            }
            case "armor": {
                ((VillagerEntityMCA)this.entity).getVillagerBrain().setArmorWear(!((VillagerEntityMCA)this.entity).getVillagerBrain().getArmorWear());
                if (((VillagerEntityMCA)this.entity).getVillagerBrain().getArmorWear()) {
                    ((VillagerEntityMCA)this.entity).sendChatMessage((Player)player, "armor.enabled", new Object[0]);
                } else {
                    ((VillagerEntityMCA)this.entity).sendChatMessage((Player)player, "armor.disabled", new Object[0]);
                }
                return true;
            }
            case "profession": {
                switch (arg) {
                    case "none": {
                        ((VillagerEntityMCA)this.entity).setProfession(VillagerProfession.f_35585_);
                        ((VillagerEntityMCA)this.entity).sendChatMessage((Player)player, "profession.set.none", new Object[0]);
                        break;
                    }
                    case "guard": {
                        ((VillagerEntityMCA)this.entity).setProfession((VillagerProfession)ProfessionsMCA.GUARD.get());
                        ((VillagerEntityMCA)this.entity).sendChatMessage((Player)player, "profession.set.guard", new Object[0]);
                        break;
                    }
                    case "archer": {
                        ((VillagerEntityMCA)this.entity).setProfession((VillagerProfession)ProfessionsMCA.ARCHER.get());
                        ((VillagerEntityMCA)this.entity).sendChatMessage((Player)player, "profession.set.archer", new Object[0]);
                    }
                }
                return true;
            }
            case "apologize": {
                Vec3 pos = ((VillagerEntityMCA)this.entity).m_20182_();
                ((VillagerEntityMCA)this.entity).f_19853_.m_45976_(VillagerEntityMCA.class, new AABB(pos, pos).m_82400_(32.0)).forEach(v -> {
                    double d = ((VillagerEntityMCA)this.entity).m_20280_((Entity)v);
                    int n = v.m_5448_() == null ? 1024 : 64;
                    if (d <= (double)n) {
                        v.pardonPlayers(99);
                    }
                });
                break;
            }
            case "location": {
                if (Config.getInstance().structuresInRumors.size() > 0) {
                    if (arg.length() == 0) {
                        arg = Config.getInstance().structuresInRumors.get(((VillagerEntityMCA)this.entity).m_217043_().m_188503_(Config.getInstance().structuresInRumors.size()));
                    }
                    ServerLevel world = (ServerLevel)((VillagerEntityMCA)this.entity).f_19853_;
                    String finalArg = arg;
                    MCA.executorService.execute(() -> {
                        ResourceLocation identifier = new ResourceLocation(finalArg);
                        BlockPos pos = RandomPos.m_217851_((RandomSource)((VillagerEntityMCA)this.entity).m_217043_(), (int)1024, (int)0).m_121955_((Vec3i)((VillagerEntityMCA)this.entity).m_20183_());
                        Optional<BlockPos> position = WorldUtils.getClosestStructurePosition(world, pos, identifier, 64);
                        if (position.isPresent()) {
                            String posString = position.get().m_123341_() + "," + position.get().m_123342_() + "," + position.get().m_123343_();
                            ((VillagerEntityMCA)this.entity).sendChatMessage((Player)player, "dialogue.location." + identifier.m_135815_(), new Object[]{posString});
                        } else {
                            ((VillagerEntityMCA)this.entity).sendChatMessage((Player)player, "dialogue.location.forgot", new Object[0]);
                        }
                    });
                    break;
                }
                ((VillagerEntityMCA)this.entity).sendChatMessage((Player)player, "dialogue.location.forgot", new Object[0]);
                break;
            }
            case "slap": {
                player.m_6469_(DamageSource.f_19311_, 1.0f);
            }
        }
        return super.handle(player, command);
    }

    private void payEmeralds(ServerPlayer player, int emeralds) {
        Inventory inventory = player.m_150109_();
        for (int j = 0; j < inventory.m_6643_(); ++j) {
            ItemStack itemStack = inventory.m_8020_(j);
            if (!itemStack.m_41720_().equals(Items.f_42616_)) continue;
            int c = Math.min(itemStack.m_41613_(), emeralds);
            itemStack.m_41774_(c);
            if ((emeralds -= c) > 0) continue;
            return;
        }
    }

    public void prepareOffersFor(Player player) {
        MobEffectInstance effectInstance;
        int i = ((VillagerEntityMCA)this.entity).m_35532_(player);
        if (i != 0) {
            for (MerchantOffer tradeOffer : ((VillagerEntityMCA)this.entity).m_6616_()) {
                tradeOffer.m_45353_(-Mth.m_14143_((float)((float)i * tradeOffer.m_45378_())));
            }
        }
        if (player.m_21023_(MobEffects.f_19595_) && (effectInstance = player.m_21124_(MobEffects.f_19595_)) != null) {
            int k = effectInstance.m_19564_();
            for (MerchantOffer merchantOffer : ((VillagerEntityMCA)this.entity).m_6616_()) {
                double d0 = 0.3 + 0.0625 * (double)k;
                int j = (int)Math.floor(d0 * (double)merchantOffer.m_45352_().m_41613_());
                merchantOffer.m_45353_(-Math.max(j, 1));
            }
        }
        ((VillagerEntityMCA)this.entity).m_7189_(player);
        ((VillagerEntityMCA)this.entity).m_45301_(player, ((VillagerEntityMCA)this.entity).m_5446_(), ((VillagerEntityMCA)this.entity).m_7141_().m_35576_());
    }
}

