/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.network.c2s;

import forge.net.mca.Config;
import forge.net.mca.MCA;
import forge.net.mca.cobalt.network.Message;
import forge.net.mca.util.WorldUtils;
import forge.net.mca.util.compat.FuzzyPositionsCompat;
import java.util.EnumSet;
import net.minecraft.network.protocol.game.ClientboundPlayerPositionPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.TicketType;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.levelgen.Heightmap;

public class DestinyMessage
implements Message {
    private static final long serialVersionUID = -782119062565197963L;
    private final String location;
    private final boolean isClosing;

    public DestinyMessage(String location, boolean isClosing) {
        this.location = location;
        this.isClosing = isClosing;
    }

    public DestinyMessage(String location) {
        this(location, false);
    }

    public DestinyMessage(boolean isClosing) {
        this(null, isClosing);
    }

    @Override
    public void receive(ServerPlayer player) {
        if (this.isClosing) {
            player.m_21195_(MobEffects.f_19609_);
        }
        if (Config.getInstance().allowDestinyTeleportation && this.location != null) {
            MCA.executorService.execute(() -> WorldUtils.getClosestStructurePosition(player.m_9236_(), player.m_20183_(), new ResourceLocation(this.location), 128).ifPresent(pos -> {
                player.m_9236_().m_46745_(pos);
                pos = player.m_9236_().m_5452_(Heightmap.Types.WORLD_SURFACE, pos);
                pos = FuzzyPositionsCompat.upWhile(pos, player.m_9236_().m_141928_(), p -> player.m_9236_().m_8055_(p).m_60828_((BlockGetter)player.m_9236_(), p));
                pos = FuzzyPositionsCompat.downWhile(pos, 1, p -> !player.m_9236_().m_8055_(p.m_7495_()).m_60838_((BlockGetter)player.m_9236_(), p));
                ChunkPos chunkPos = new ChunkPos(pos);
                player.m_9236_().m_7726_().m_8387_(TicketType.f_9448_, chunkPos, 1, (Object)player.m_19879_());
                player.f_8906_.m_9780_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), player.m_146908_(), player.m_146909_(), EnumSet.noneOf(ClientboundPlayerPositionPacket.RelativeArgument.class));
                player.m_9158_(player.f_19853_.m_46472_(), pos, 0.0f, true, false);
                if (player.f_19853_.m_7654_() != null && player.f_19853_.m_7654_().m_7779_(player.m_36316_())) {
                    player.m_9236_().m_8733_(pos, 0.0f);
                }
            }));
        }
    }
}

