/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.resources;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import forge.net.mca.Config;
import forge.net.mca.MCA;
import forge.net.mca.entity.VillagerLike;
import forge.net.mca.entity.ai.relationship.AgeState;
import forge.net.mca.entity.ai.relationship.Gender;
import forge.net.mca.resources.Resources;
import forge.net.mca.resources.WeightedPool;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.npc.VillagerProfession;
import org.jetbrains.annotations.Nullable;

public class ClothingList
extends SimpleJsonResourceReloadListener {
    protected static final ResourceLocation ID = MCA.locate("skins/clothing");
    public final HashMap<String, Clothing> clothing = new HashMap();
    private static ClothingList INSTANCE;

    public static ClothingList getInstance() {
        return INSTANCE;
    }

    public ClothingList() {
        super(Resources.GSON, "skins/clothing");
        INSTANCE = this;
    }

    protected void apply(Map<ResourceLocation, JsonElement> data, ResourceManager manager, ProfilerFiller profiler) {
        this.clothing.clear();
        data.forEach((id, file) -> {
            Gender gender = Gender.byName(id.m_135815_().split("\\.")[0]);
            if (gender == Gender.UNASSIGNED) {
                MCA.LOGGER.warn("Invalid gender for clothing pool: {}", id);
                return;
            }
            for (String key : file.getAsJsonObject().keySet()) {
                JsonObject object = file.getAsJsonObject().get(key).getAsJsonObject();
                for (int i = 0; i < GsonHelper.m_13824_((JsonObject)object, (String)"count", (int)1); ++i) {
                    String identifier = String.format(key, i);
                    Clothing c = new Clothing(identifier);
                    c.gender = gender;
                    c.profession = GsonHelper.m_13851_((JsonObject)object, (String)"profession", null);
                    c.chance = GsonHelper.m_13820_((JsonObject)object, (String)"chance", (float)1.0f);
                    c.exclude = GsonHelper.m_13855_((JsonObject)object, (String)"exclude", (boolean)false);
                    c.temperature = GsonHelper.m_13824_((JsonObject)object, (String)"temperature", (int)0);
                    if (this.clothing.containsKey(identifier) && object.has("count")) continue;
                    this.clothing.put(identifier, c);
                }
            }
        });
    }

    public WeightedPool<String> getPool(VillagerLike<?> villager) {
        Gender gender = villager.getGenetics().getGender();
        return switch (villager.getAgeState()) {
            case AgeState.BABY, AgeState.TODDLER -> this.getPool(gender, MCA.locate("baby").toString());
            case AgeState.CHILD, AgeState.TEEN -> this.getPool(gender, MCA.locate("child").toString());
            default -> {
                WeightedPool<String> pool = this.getPool(gender, villager.m_7141_().m_35571_());
                if (pool.entries.size() == 0) {
                    pool = this.getPool(gender, VillagerProfession.f_35585_);
                }
                yield pool;
            }
        };
    }

    public WeightedPool<String> getPool(Gender gender, @Nullable VillagerProfession profession) {
        Map<String, String> map = Config.getInstance().professionConversionsMap;
        String currentValue = profession == null ? "minecraft:none" : Registry.f_122869_.m_7981_((Object)profession).toString();
        String identifier = map.getOrDefault(currentValue, map.getOrDefault("default", currentValue));
        return this.getPool(gender, identifier);
    }

    public WeightedPool<String> getPool(Gender gender, @Nullable String profession) {
        return this.clothing.values().stream().filter(c -> c.gender == Gender.NEUTRAL || gender == Gender.NEUTRAL || c.gender == gender).filter(c -> c.profession == null || profession == null && !c.exclude || c.profession.equals(profession)).collect(() -> new WeightedPool.Mutable<String>("mca:missing"), (list, entry) -> list.add(entry.identifier, entry.chance), (a, b) -> a.entries.addAll(b.entries));
    }

    public static class Clothing
    extends ListEntry {
        @Nullable
        public String profession;
        public float temperature;
        public boolean exclude;

        public Clothing(String identifier) {
            super(identifier);
        }
    }

    public static class ListEntry
    implements Serializable {
        final String identifier;
        public Gender gender;
        public float chance;

        public ListEntry(String identifier) {
            this.identifier = identifier;
        }
    }
}

