/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.server;

import forge.net.mca.Config;
import forge.net.mca.MCA;
import forge.net.mca.ducks.IVillagerEntity;
import forge.net.mca.entity.VillagerEntityMCA;
import forge.net.mca.entity.VillagerFactory;
import forge.net.mca.entity.ZombieVillagerEntityMCA;
import forge.net.mca.entity.ZombieVillagerFactory;
import forge.net.mca.entity.ai.relationship.Gender;
import forge.net.mca.server.world.data.Nationality;
import java.util.Locale;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.minecraft.core.Registry;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.monster.ZombieVillager;
import net.minecraft.world.entity.npc.Villager;

public class SpawnQueue {
    private static final SpawnQueue INSTANCE = new SpawnQueue();
    private final ConcurrentLinkedQueue<Villager> villagerSpawnQueue = new ConcurrentLinkedQueue();
    private final ConcurrentLinkedQueue<ZombieVillager> zombieVillagerSpawnQueue = new ConcurrentLinkedQueue();

    public static SpawnQueue getInstance() {
        return INSTANCE;
    }

    public void tick() {
        Villager e;
        if (!this.villagerSpawnQueue.isEmpty()) {
            e = this.villagerSpawnQueue.poll();
            MCA.executorService.execute(() -> {
                if (e.f_19853_.m_46749_(e.m_20183_())) {
                    e.m_146870_();
                    VillagerEntityMCA villager = VillagerFactory.newVillager(e.f_19853_).withName(e.m_8077_() ? e.m_7755_().getString() : null).withGender(Gender.getRandom()).withAge(e.m_146764_()).withPosition((Entity)e).withType(e.m_7141_().m_35560_()).withProfession(e.m_7141_().m_35571_(), e.m_7141_().m_35576_(), e.m_6616_()).spawn(((IVillagerEntity)e).getSpawnReason());
                    this.copyPastaIntensifies((PathfinderMob)villager, (PathfinderMob)e);
                } else {
                    this.villagerSpawnQueue.add(e);
                }
            });
        }
        if (!this.zombieVillagerSpawnQueue.isEmpty()) {
            e = this.zombieVillagerSpawnQueue.poll();
            MCA.executorService.execute(() -> this.lambda$tick$1((ZombieVillager)e));
        }
    }

    private void copyPastaIntensifies(PathfinderMob villager, PathfinderMob entity) {
        if (entity.m_21532_()) {
            villager.m_21530_();
        }
        if (entity.m_20147_()) {
            villager.m_20331_(true);
        }
        if (entity.m_21525_()) {
            villager.m_21557_(true);
        }
        for (String tag : entity.m_19880_()) {
            villager.m_20049_(tag);
        }
    }

    public static boolean shouldGetConverted(Entity entity) {
        if (Config.getInstance().fractionOfVanillaVillages <= 0.0f) {
            return true;
        }
        int i = Nationality.get((ServerLevel)entity.m_9236_()).getRegionId(entity.m_20183_());
        return (double)Math.floorMod(i, 100) >= (double)Config.getInstance().fractionOfVanillaVillages * 100.0;
    }

    public boolean addVillager(Entity entity) {
        IVillagerEntity villagerEntity;
        if (entity instanceof IVillagerEntity && !this.handlesSpawnReason((villagerEntity = (IVillagerEntity)entity).getSpawnReason())) {
            return false;
        }
        if (Config.getInstance().villagerDimensionBlacklist.contains(entity.m_20193_().m_46472_().m_135782_().toString())) {
            return false;
        }
        if (Config.getInstance().overwriteOriginalVillagers && (entity.getClass().equals(Villager.class) || Config.getInstance().moddedVillagerWhitelist.contains(Registry.f_122826_.m_7981_((Object)entity.m_6095_()).toString()) && entity instanceof Villager) && SpawnQueue.shouldGetConverted(entity) && !this.villagerSpawnQueue.contains(entity)) {
            return this.villagerSpawnQueue.add((Villager)entity);
        }
        if (Config.getInstance().overwriteOriginalZombieVillagers && (entity.getClass().equals(ZombieVillager.class) || Config.getInstance().moddedZombieVillagerWhitelist.contains(Registry.f_122826_.m_7981_((Object)entity.m_6095_()).toString()) && entity instanceof ZombieVillager) && !this.zombieVillagerSpawnQueue.contains(entity)) {
            return this.zombieVillagerSpawnQueue.add((ZombieVillager)entity);
        }
        return false;
    }

    private boolean handlesSpawnReason(MobSpawnType reason) {
        return Config.getInstance().allowedSpawnReasons.contains(reason.name().toLowerCase(Locale.ROOT));
    }

    public void convert(Villager villager) {
        this.villagerSpawnQueue.add(villager);
    }

    private /* synthetic */ void lambda$tick$1(ZombieVillager e) {
        if (e.f_19853_.m_46749_(e.m_20183_())) {
            e.m_146870_();
            ZombieVillagerEntityMCA villager = ZombieVillagerFactory.newVillager(e.f_19853_).withName(e.m_8077_() ? e.m_7755_().getString() : null).withGender(Gender.getRandom()).withPosition((Entity)e).withType(e.m_7141_().m_35560_()).withProfession(e.m_7141_().m_35571_(), e.m_7141_().m_35576_()).spawn(((IVillagerEntity)e).getSpawnReason());
            this.copyPastaIntensifies((PathfinderMob)villager, (PathfinderMob)e);
        } else {
            this.zombieVillagerSpawnQueue.add(e);
        }
    }
}

