/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.server.world.data.villageComponents;

import forge.net.mca.Config;
import forge.net.mca.ProfessionsMCA;
import forge.net.mca.entity.VillagerEntityMCA;
import forge.net.mca.entity.ai.relationship.Gender;
import forge.net.mca.server.world.data.Village;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.WanderingTrader;
import net.minecraft.world.level.BlockGetter;

public class VillageInnManager {
    private final Village village;

    public VillageInnManager(Village village) {
        this.village = village;
    }

    public void updateInn(ServerLevel world) {
        this.village.getBuildingsOfType("inn").forEach(b -> {
            block1: {
                BlockPos p;
                if (!(world.f_46441_.m_188501_() < Config.getInstance().adventurerAtInnChancePerMinute)) break block1;
                ArrayList values = new ArrayList(b.getBlocks().values().stream().flatMap(Collection::stream).toList());
                Collections.shuffle(values);
                Iterator iterator = values.iterator();
                while (iterator.hasNext() && !this.trySpawnAdventurer(world, (p = (BlockPos)iterator.next()).m_7494_())) {
                }
            }
        });
    }

    private boolean doesNotSuffocateAt(BlockGetter world, BlockPos pos) {
        for (BlockPos blockPos : BlockPos.m_121940_((BlockPos)pos, (BlockPos)pos.m_7494_())) {
            if (world.m_8055_(blockPos).m_60812_(world, blockPos).m_83281_()) continue;
            return false;
        }
        return true;
    }

    private boolean trySpawnAdventurer(ServerLevel world, BlockPos blockPos) {
        if (!world.m_7232_(SectionPos.m_123171_((int)blockPos.m_123341_()), SectionPos.m_123171_((int)blockPos.m_123343_()))) {
            return true;
        }
        String name = null;
        if (this.doesNotSuffocateAt((BlockGetter)world, blockPos)) {
            VillagerEntityMCA adventurer;
            int i = world.f_46441_.m_188503_(10);
            if (i == 0 && Config.getInstance().innSpawnsWanderingTraders) {
                WanderingTrader trader = (WanderingTrader)EntityType.f_20494_.m_20600_(world, null, null, null, blockPos, MobSpawnType.EVENT, false, false);
                if (trader != null) {
                    name = trader.m_7755_().getString();
                    trader.m_35891_(Config.getInstance().adventurerStayTime);
                }
            } else if (i == 1 && Config.getInstance().innSpawnsCultists) {
                VillagerEntityMCA adventurer2 = (VillagerEntityMCA)Gender.getRandom().getVillagerType().m_20600_(world, null, null, null, blockPos, MobSpawnType.EVENT, false, false);
                if (adventurer2 != null) {
                    name = adventurer2.m_7755_().getString();
                    adventurer2.setProfession((VillagerProfession)ProfessionsMCA.CULTIST.get());
                    adventurer2.setDespawnDelay(Config.getInstance().adventurerStayTime);
                }
            } else if (Config.getInstance().innSpawnsAdventurers && (adventurer = (VillagerEntityMCA)Gender.getRandom().getVillagerType().m_20600_(world, null, null, null, blockPos, MobSpawnType.EVENT, false, false)) != null) {
                name = adventurer.m_7755_().getString();
                adventurer.setProfession((VillagerProfession)ProfessionsMCA.ADVENTURER.get());
                adventurer.setDespawnDelay(Config.getInstance().adventurerStayTime);
            }
            if (name != null) {
                if (Config.getInstance().innArrivalNotification) {
                    this.village.broadCastMessage(world, "events.arrival.inn", name);
                }
                return true;
            }
        }
        return false;
    }
}

