/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.server.world.data.villageComponents;

import forge.net.mca.Config;
import forge.net.mca.entity.VillagerEntityMCA;
import forge.net.mca.entity.ai.Memories;
import forge.net.mca.server.world.data.Village;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;

public class VillageMarriageManager {
    private final Village village;

    public VillageMarriageManager(Village village) {
        this.village = village;
    }

    public void marry(ServerLevel world) {
        if (world.f_46441_.m_188501_() >= Config.getInstance().marriageChancePerMinute) {
            return;
        }
        List<VillagerEntityMCA> allVillagers = this.village.getResidents(world);
        List availableVillagers = allVillagers.stream().filter(v -> !v.m_6162_()).filter(v -> !v.getRelationships().isMarried()).filter(v -> !v.getRelationships().isEngaged()).filter(v -> !v.getRelationships().isPromised()).collect(Collectors.toList());
        if (availableVillagers.size() <= 1 || (float)availableVillagers.size() < (float)allVillagers.size() * this.village.getMarriageThreshold()) {
            return;
        }
        availableVillagers.sort(Comparator.comparingInt(a -> a.getVillagerBrain().getMemories().values().stream().map(Memories::getHearts).max(Integer::compare).orElse(0)));
        VillagerEntityMCA suitor = (VillagerEntityMCA)availableVillagers.remove(0);
        availableVillagers.stream().filter(suitor::canBeAttractedTo).filter(i -> !suitor.getRelationships().getFamilyEntry().isRelative(i.m_20148_())).findFirst().ifPresent(mate -> {
            suitor.getRelationships().marry((Entity)mate);
            mate.getRelationships().marry((Entity)suitor);
            if (Config.getInstance().villagerMarriageNotification) {
                this.village.broadCastMessage(world, "events.marry", suitor, (VillagerEntityMCA)mate);
            }
        });
    }
}

