/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.util.compat;

import com.google.common.annotations.VisibleForTesting;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;

public class FuzzyPositionsCompat {
    public static BlockPos localFuzz(RandomSource random, int horizontalRange, int verticalRange) {
        int i = random.m_188503_(2 * horizontalRange + 1) - horizontalRange;
        int j = random.m_188503_(2 * verticalRange + 1) - verticalRange;
        int k = random.m_188503_(2 * horizontalRange + 1) - horizontalRange;
        return new BlockPos(i, j, k);
    }

    @VisibleForTesting
    public static BlockPos upWhile(BlockPos pos, int maxY, Predicate<BlockPos> condition) {
        if (!condition.test(pos)) {
            return pos;
        }
        BlockPos blockPos = pos.m_7494_();
        while (blockPos.m_123342_() < maxY && condition.test(blockPos)) {
            blockPos = blockPos.m_7494_();
        }
        return blockPos;
    }

    @VisibleForTesting
    public static BlockPos downWhile(BlockPos pos, int minY, Predicate<BlockPos> condition) {
        if (!condition.test(pos)) {
            return pos;
        }
        BlockPos blockPos = pos.m_7495_();
        while (blockPos.m_123342_() > minY && condition.test(blockPos)) {
            blockPos = blockPos.m_7495_();
        }
        return blockPos;
    }
}

