/*
 * Decompiled with CFR 0.152.
 */
package quilt.net.mca;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_310;
import quilt.net.mca.Config;
import quilt.net.mca.DestinyManager;
import quilt.net.mca.MCA;
import quilt.net.mca.cobalt.network.NetworkHandler;
import quilt.net.mca.entity.VillagerEntityMCA;
import quilt.net.mca.entity.VillagerLike;
import quilt.net.mca.network.c2s.ConfigRequest;
import quilt.net.mca.network.c2s.PlayerDataRequest;

public class MCAClient {
    public static VillagerEntityMCA fallbackVillager;
    public static Map<UUID, VillagerLike<?>> playerData;
    public static Set<UUID> playerDataRequests;
    private static final DestinyManager destinyManager;

    public static DestinyManager getDestinyManager() {
        return destinyManager;
    }

    public static void onLogin() {
        playerDataRequests.clear();
        NetworkHandler.sendToServer(new ConfigRequest());
    }

    public static boolean useGeneticsRenderer(UUID uuid) {
        if (MCA.isPlayerRendererAllowed()) {
            if (!playerDataRequests.contains(uuid)) {
                playerDataRequests.add(uuid);
                NetworkHandler.sendToServer(new PlayerDataRequest(uuid));
            }
            return playerData.containsKey(uuid) && playerData.get(uuid).getPlayerModel() != VillagerLike.PlayerModel.VANILLA;
        }
        return false;
    }

    public static boolean useVillagerRenderer(UUID uuid) {
        return MCAClient.useGeneticsRenderer(uuid) && playerData.get(uuid).getPlayerModel() == VillagerLike.PlayerModel.VILLAGER;
    }

    public static boolean renderArms(UUID uuid, String key) {
        return MCAClient.useVillagerRenderer(uuid) && Config.getInstance().playerRendererBlacklist.entrySet().stream().filter(entry -> ((String)entry.getValue()).equals("arms") || ((String)entry.getValue()).equals(key)).noneMatch(entry -> MCA.doesModExist((String)entry.getKey()));
    }

    public static boolean renderArms(UUID uuid) {
        return MCAClient.renderArms(uuid, "arms");
    }

    public static void tickClient(class_310 client) {
        destinyManager.tick(client);
    }

    static {
        playerData = new HashMap();
        playerDataRequests = new HashSet<UUID>();
        destinyManager = new DestinyManager();
    }
}

