/*
 * Decompiled with CFR 0.152.
 */
package quilt.net.mca.client;

import java.util.Collection;
import java.util.Locale;
import java.util.UUID;
import net.minecraft.class_1106;
import net.minecraft.class_1113;
import net.minecraft.class_1297;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_5819;
import quilt.net.mca.entity.CommonSpeechManager;
import quilt.net.mca.entity.VillagerEntityMCA;
import quilt.net.mca.entity.ai.Genetics;
import quilt.net.mca.util.LimitedLinkedHashMap;

public class SpeechManager {
    public static final SpeechManager INSTANCE = new SpeechManager();
    private final LimitedLinkedHashMap<UUID, class_1106> currentlyPlaying = new LimitedLinkedHashMap(10);
    private final class_5819 threadSafeRandom = class_5819.method_43050();

    public void onChatMessage(class_2561 message, UUID sender) {
        if (CommonSpeechManager.INSTANCE.translations.containsKey(message.method_10851())) {
            this.speak((String)CommonSpeechManager.INSTANCE.translations.get(message.method_10851()), sender);
        } else {
            for (class_2561 sibling : message.method_10855()) {
                if (!CommonSpeechManager.INSTANCE.translations.containsKey(sibling.method_10851())) continue;
                this.speak((String)CommonSpeechManager.INSTANCE.translations.get(sibling.method_10851()), sender);
            }
        }
    }

    private void speak(String phrase, UUID sender) {
        if (this.currentlyPlaying.containsKey(sender) && class_310.method_1551().method_1483().method_4877((class_1113)this.currentlyPlaying.get(sender))) {
            return;
        }
        class_310 client = class_310.method_1551();
        if (client.field_1687 != null) {
            VillagerEntityMCA villager = null;
            for (class_1297 entity : client.field_1687.method_18112()) {
                if (!(entity instanceof VillagerEntityMCA)) continue;
                VillagerEntityMCA v = (VillagerEntityMCA)entity;
                if (!entity.method_5667().equals(sender)) continue;
                villager = v;
                break;
            }
            if (villager != null) {
                Collection keys;
                if (villager.isSpeechImpaired()) {
                    return;
                }
                if (villager.isToYoungToSpeak()) {
                    return;
                }
                float pitch = villager.method_6017();
                float gene = villager.getGenetics().getGene(Genetics.VOICE_TONE);
                int tone = Math.min(9, (int)Math.floor(gene * 10.0f));
                class_2960 sound = new class_2960("mca_voices", "%s/%s_%d".formatted(phrase, villager.getGenetics().getGender().binary().getStrName(), tone).toLowerCase(Locale.ROOT));
                if (client.field_1687 != null && client.field_1724 != null && (keys = client.method_1483().method_4864()).contains(sound)) {
                    class_1106 instance = new class_1106(new class_3414(sound), class_3419.field_15254, 1.0f, pitch, (class_1297)villager, this.threadSafeRandom.method_43055());
                    this.currentlyPlaying.put(sender, instance);
                    client.method_1483().method_4873((class_1113)instance);
                }
            }
        }
    }
}

