/*
 * Decompiled with CFR 0.152.
 */
package quilt.net.mca.resources;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_3695;
import net.minecraft.class_3852;
import net.minecraft.class_4309;
import org.jetbrains.annotations.Nullable;
import quilt.net.mca.Config;
import quilt.net.mca.MCA;
import quilt.net.mca.entity.VillagerLike;
import quilt.net.mca.entity.ai.relationship.AgeState;
import quilt.net.mca.entity.ai.relationship.Gender;
import quilt.net.mca.resources.Resources;
import quilt.net.mca.resources.WeightedPool;

public class ClothingList
extends class_4309 {
    protected static final class_2960 ID = MCA.locate("skins/clothing");
    public final HashMap<String, Clothing> clothing = new HashMap();
    private static ClothingList INSTANCE;

    public static ClothingList getInstance() {
        return INSTANCE;
    }

    public ClothingList() {
        super(Resources.GSON, "skins/clothing");
        INSTANCE = this;
    }

    protected void apply(Map<class_2960, JsonElement> data, class_3300 manager, class_3695 profiler) {
        this.clothing.clear();
        data.forEach((id, file) -> {
            Gender gender = Gender.byName(id.method_12832().split("\\.")[0]);
            if (gender == Gender.UNASSIGNED) {
                MCA.LOGGER.warn("Invalid gender for clothing pool: {}", id);
                return;
            }
            for (String key : file.getAsJsonObject().keySet()) {
                JsonObject object = file.getAsJsonObject().get(key).getAsJsonObject();
                for (int i = 0; i < class_3518.method_15282((JsonObject)object, (String)"count", (int)1); ++i) {
                    String identifier = String.format(key, i);
                    Clothing c = new Clothing(identifier);
                    c.gender = gender;
                    c.profession = class_3518.method_15253((JsonObject)object, (String)"profession", null);
                    c.chance = class_3518.method_15277((JsonObject)object, (String)"chance", (float)1.0f);
                    c.exclude = class_3518.method_15258((JsonObject)object, (String)"exclude", (boolean)false);
                    c.temperature = class_3518.method_15282((JsonObject)object, (String)"temperature", (int)0);
                    if (this.clothing.containsKey(identifier) && object.has("count")) continue;
                    this.clothing.put(identifier, c);
                }
            }
        });
    }

    public WeightedPool<String> getPool(VillagerLike<?> villager) {
        Gender gender = villager.getGenetics().getGender();
        return switch (villager.getAgeState()) {
            case AgeState.BABY, AgeState.TODDLER -> this.getPool(gender, MCA.locate("baby").toString());
            case AgeState.CHILD, AgeState.TEEN -> this.getPool(gender, MCA.locate("child").toString());
            default -> {
                WeightedPool<String> pool = this.getPool(gender, villager.method_7231().method_16924());
                if (pool.entries.size() == 0) {
                    pool = this.getPool(gender, class_3852.field_17051);
                }
                yield pool;
            }
        };
    }

    public WeightedPool<String> getPool(Gender gender, @Nullable class_3852 profession) {
        Map<String, String> map = Config.getInstance().professionConversionsMap;
        String currentValue = profession == null ? "minecraft:none" : class_2378.field_17167.method_10221((Object)profession).toString();
        String identifier = map.getOrDefault(currentValue, map.getOrDefault("default", currentValue));
        return this.getPool(gender, identifier);
    }

    public WeightedPool<String> getPool(Gender gender, @Nullable String profession) {
        return this.clothing.values().stream().filter(c -> c.gender == Gender.NEUTRAL || gender == Gender.NEUTRAL || c.gender == gender).filter(c -> c.profession == null || profession == null && !c.exclude || c.profession.equals(profession)).collect(() -> new WeightedPool.Mutable<String>("mca:missing"), (list, entry) -> list.add(entry.identifier, entry.chance), (a, b) -> a.entries.addAll(b.entries));
    }

    public static class Clothing
    extends ListEntry {
        @Nullable
        public String profession;
        public float temperature;
        public boolean exclude;

        public Clothing(String identifier) {
            super(identifier);
        }
    }

    public static class ListEntry
    implements Serializable {
        final String identifier;
        public Gender gender;
        public float chance;

        public ListEntry(String identifier) {
            this.identifier = identifier;
        }
    }
}

