/*
 * Decompiled with CFR 0.152.
 */
package quilt.net.mca.server.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import quilt.net.mca.Config;
import quilt.net.mca.cobalt.network.NetworkHandler;
import quilt.net.mca.entity.ai.GPT3;
import quilt.net.mca.network.s2c.OpenGuiRequest;
import quilt.net.mca.server.ServerInteractionManager;
import quilt.net.mca.server.world.data.PlayerSaveData;

public class Command {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"mca").then(Command.register("help", (com.mojang.brigadier.Command<class_2168>)((com.mojang.brigadier.Command)Command::displayHelp)))).then(Command.register("propose").then(class_2170.method_9244((String)"target", (ArgumentType)class_2186.method_9305()).executes(Command::propose)))).then(Command.register("accept").then(class_2170.method_9244((String)"target", (ArgumentType)class_2186.method_9305()).executes(Command::accept)))).then(Command.register("proposals", (com.mojang.brigadier.Command<class_2168>)((com.mojang.brigadier.Command)Command::displayProposal)))).then(Command.register("procreate", (com.mojang.brigadier.Command<class_2168>)((com.mojang.brigadier.Command)Command::procreate)))).then(Command.register("separate", (com.mojang.brigadier.Command<class_2168>)((com.mojang.brigadier.Command)Command::separate)))).then(Command.register("reject").then(class_2170.method_9244((String)"target", (ArgumentType)class_2186.method_9305()).executes(Command::reject)))).then(Command.register("editor", (com.mojang.brigadier.Command<class_2168>)((com.mojang.brigadier.Command)Command::editor)))).then(Command.register("destiny", (com.mojang.brigadier.Command<class_2168>)((com.mojang.brigadier.Command)Command::destiny)))).then(Command.register("mail", (com.mojang.brigadier.Command<class_2168>)((com.mojang.brigadier.Command)Command::mail)))).then(Command.register("verify").then(class_2170.method_9244((String)"email", (ArgumentType)StringArgumentType.greedyString()).executes(Command::verify))));
    }

    private static int editor(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        if (((class_2168)ctx.getSource()).method_9259(2) || Config.getInstance().allowFullPlayerEditor) {
            NetworkHandler.sendToPlayer(new OpenGuiRequest(OpenGuiRequest.Type.VILLAGER_EDITOR, (class_1297)((class_2168)ctx.getSource()).method_44023()), ((class_2168)ctx.getSource()).method_44023());
            return 0;
        }
        if (Config.getInstance().allowLimitedPlayerEditor) {
            NetworkHandler.sendToPlayer(new OpenGuiRequest(OpenGuiRequest.Type.LIMITED_VILLAGER_EDITOR, (class_1297)((class_2168)ctx.getSource()).method_44023()), ((class_2168)ctx.getSource()).method_44023());
            return 0;
        }
        ((class_2168)ctx.getSource()).method_44023().method_43496((class_2561)class_2561.method_43471((String)"command.no_permission").method_27692(class_124.field_1061));
        return 1;
    }

    private static int destiny(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        if (((class_2168)ctx.getSource()).method_9259(2) || Config.getInstance().allowDestinyCommandOnce) {
            class_3222 player = ((class_2168)ctx.getSource()).method_44023();
            if (!PlayerSaveData.get(player).isEntityDataSet() || Config.getInstance().allowDestinyCommandMoreThanOnce) {
                ServerInteractionManager.launchDestiny(player);
                return 0;
            }
            ((class_2168)ctx.getSource()).method_44023().method_43496((class_2561)class_2561.method_43471((String)"command.only_one_destiny").method_27692(class_124.field_1061));
            return 1;
        }
        ((class_2168)ctx.getSource()).method_44023().method_43496((class_2561)class_2561.method_43471((String)"command.no_permission").method_27692(class_124.field_1061));
        return 1;
    }

    private static int mail(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        class_3222 player = ((class_2168)ctx.getSource()).method_44023();
        PlayerSaveData data = PlayerSaveData.get(player);
        if (data.hasMail()) {
            while (data.hasMail()) {
                player.method_31548().method_7398(data.getMail());
            }
        } else {
            ((class_2168)ctx.getSource()).method_44023().method_43496((class_2561)class_2561.method_43471((String)"command.no_mail"));
        }
        return 0;
    }

    private static int verify(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        class_3222 player = ((class_2168)ctx.getSource()).method_44023();
        CompletableFuture.runAsync(() -> {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("email", StringArgumentType.getString((CommandContext)ctx, (String)"email"));
            assert (player != null);
            params.put("player", player.method_5477().getString());
            String encodedURL = params.keySet().stream().map(key -> key + "=" + URLEncoder.encode((String)params.get(key), StandardCharsets.UTF_8)).collect(Collectors.joining("&", "http://snoweagle.tk/verify?", ""));
            GPT3.Answer request = GPT3.request(encodedURL);
            if (request.answer().equals("success")) {
                player.method_43496((class_2561)class_2561.method_43471((String)"command.verify.success").method_27692(class_124.field_1060));
            } else if (request.answer().equals("failed")) {
                player.method_43496((class_2561)class_2561.method_43471((String)"command.verify.failed").method_27692(class_124.field_1061));
            } else {
                player.method_43496((class_2561)class_2561.method_43471((String)"command.verify.crashed").method_27692(class_124.field_1061));
            }
        });
        return 0;
    }

    private static int displayHelp(CommandContext<class_2168> ctx) {
        Command.sendMessage((class_1297)((class_2168)ctx.getSource()).method_44023(), class_124.field_1079 + "--- " + class_124.field_1065 + "PLAYER COMMANDS" + class_124.field_1079 + " ---");
        Command.sendMessage((class_1297)((class_2168)ctx.getSource()).method_44023(), class_124.field_1068 + " /mca editor" + class_124.field_1065 + " - Choose your genetics and stuff.");
        Command.sendMessage((class_1297)((class_2168)ctx.getSource()).method_44023(), class_124.field_1068 + " /mca propose <PlayerName>" + class_124.field_1065 + " - Proposes marriage to the given player.");
        Command.sendMessage((class_1297)((class_2168)ctx.getSource()).method_44023(), class_124.field_1068 + " /mca proposals " + class_124.field_1065 + " - Shows all active proposals.");
        Command.sendMessage((class_1297)((class_2168)ctx.getSource()).method_44023(), class_124.field_1068 + " /mca accept <PlayerName>" + class_124.field_1065 + " - Accepts the player's marriage request.");
        Command.sendMessage((class_1297)((class_2168)ctx.getSource()).method_44023(), class_124.field_1068 + " /mca reject <PlayerName>" + class_124.field_1065 + " - Rejects the player's marriage request.");
        Command.sendMessage((class_1297)((class_2168)ctx.getSource()).method_44023(), class_124.field_1068 + " /mca procreate " + class_124.field_1065 + " - Starts procreation.");
        Command.sendMessage((class_1297)((class_2168)ctx.getSource()).method_44023(), class_124.field_1068 + " /mca separate " + class_124.field_1065 + " - Ends your marriage.");
        Command.sendMessage((class_1297)((class_2168)ctx.getSource()).method_44023(), class_124.field_1079 + "--- " + class_124.field_1065 + "GLOBAL COMMANDS" + class_124.field_1079 + " ---");
        Command.sendMessage((class_1297)((class_2168)ctx.getSource()).method_44023(), class_124.field_1068 + " /mca help " + class_124.field_1065 + " - Shows this list of commands.");
        return 0;
    }

    private static int propose(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        class_3222 target = class_2186.method_9315(ctx, (String)"target");
        ServerInteractionManager.getInstance().sendProposal(((class_2168)ctx.getSource()).method_44023(), target);
        return 0;
    }

    private static int accept(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        class_3222 target = class_2186.method_9315(ctx, (String)"target");
        ServerInteractionManager.getInstance().acceptProposal(((class_2168)ctx.getSource()).method_44023(), target);
        return 0;
    }

    private static int displayProposal(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        ServerInteractionManager.getInstance().listProposals(((class_2168)ctx.getSource()).method_44023());
        return 0;
    }

    private static int procreate(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        ServerInteractionManager.getInstance().procreate(((class_2168)ctx.getSource()).method_44023());
        return 0;
    }

    private static int separate(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        ServerInteractionManager.getInstance().endMarriage(((class_2168)ctx.getSource()).method_44023());
        return 0;
    }

    private static int reject(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        class_3222 target = class_2186.method_9315(ctx, (String)"target");
        ServerInteractionManager.getInstance().rejectProposal(((class_2168)ctx.getSource()).method_44023(), target);
        return 0;
    }

    private static ArgumentBuilder<class_2168, ?> register(String name, com.mojang.brigadier.Command<class_2168> cmd) {
        return ((LiteralArgumentBuilder)class_2170.method_9247((String)name).requires(cs -> cs.method_9259(0))).executes(cmd);
    }

    private static ArgumentBuilder<class_2168, ?> register(String name) {
        return class_2170.method_9247((String)name).requires(cs -> cs.method_9259(0));
    }

    private static void sendMessage(class_1297 commandSender, String message) {
        commandSender.method_43496((class_2561)class_2561.method_43470((String)(class_124.field_1065 + "[MCA] " + class_124.field_1070 + message)));
    }
}

