/*
 * Decompiled with CFR 0.152.
 */
package quilt.net.mca.server.world.data.villageComponents;

import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_1297;
import net.minecraft.class_3218;
import quilt.net.mca.Config;
import quilt.net.mca.entity.VillagerEntityMCA;
import quilt.net.mca.entity.ai.Memories;
import quilt.net.mca.server.world.data.Village;

public class VillageMarriageManager {
    private final Village village;

    public VillageMarriageManager(Village village) {
        this.village = village;
    }

    public void marry(class_3218 world) {
        if (world.field_9229.method_43057() >= Config.getInstance().marriageChancePerMinute) {
            return;
        }
        List<VillagerEntityMCA> allVillagers = this.village.getResidents(world);
        List availableVillagers = allVillagers.stream().filter(v -> !v.method_6109()).filter(v -> !v.getRelationships().isMarried()).filter(v -> !v.getRelationships().isEngaged()).filter(v -> !v.getRelationships().isPromised()).collect(Collectors.toList());
        if (availableVillagers.size() <= 1 || (float)availableVillagers.size() < (float)allVillagers.size() * this.village.getMarriageThreshold()) {
            return;
        }
        availableVillagers.sort(Comparator.comparingInt(a -> a.getVillagerBrain().getMemories().values().stream().map(Memories::getHearts).max(Integer::compare).orElse(0)));
        VillagerEntityMCA suitor = (VillagerEntityMCA)availableVillagers.remove(0);
        availableVillagers.stream().filter(suitor::canBeAttractedTo).filter(i -> !suitor.getRelationships().getFamilyEntry().isRelative(i.method_5667())).findFirst().ifPresent(mate -> {
            suitor.getRelationships().marry((class_1297)mate);
            mate.getRelationships().marry((class_1297)suitor);
            if (Config.getInstance().villagerMarriageNotification) {
                this.village.broadCastMessage(world, "events.marry", suitor, (VillagerEntityMCA)mate);
            }
        });
    }
}

