/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littleframes.client;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import team.creative.creativecore.common.util.math.base.Facing;
import team.creative.creativecore.common.util.math.box.AlignedBox;
import team.creative.creativecore.common.util.math.box.BoxCorner;
import team.creative.creativecore.common.util.math.box.BoxFace;
import team.creative.littleframes.client.display.FrameDisplay;
import team.creative.littleframes.common.block.BECreativePictureFrame;
import team.creative.littleframes.common.block.BlockCreativePictureFrame;

@OnlyIn(value=Dist.CLIENT)
public class CreativePictureFrameRenderer
implements BlockEntityRenderer<BECreativePictureFrame> {
    public boolean shouldRenderOffScreen(BECreativePictureFrame frame) {
        return frame.getSizeX() > 16.0f || frame.getSizeY() > 16.0f;
    }

    public boolean shouldRender(BECreativePictureFrame frame, Vec3 vec) {
        return Vec3.m_82512_((Vec3i)frame.m_58899_()).m_82509_((Position)vec, (double)frame.renderDistance);
    }

    public void render(BECreativePictureFrame frame, float partialTicks, PoseStack pose, MultiBufferSource buffer, int p_112311_, int p_112312_) {
        if (frame.isURLEmpty() || frame.alpha == 0.0f) {
            if (frame.display != null) {
                frame.display.release();
            }
            return;
        }
        FrameDisplay display = frame.requestDisplay();
        if (display == null) {
            return;
        }
        display.prepare(frame.getURL(), frame.volume * Minecraft.m_91087_().f_91066_.m_92147_(SoundSource.MASTER), frame.minDistance, frame.maxDistance, frame.playing, frame.loop, frame.tick);
        RenderSystem.m_69482_();
        RenderSystem.m_69478_();
        RenderSystem.m_69408_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.m_157429_((float)frame.brightness, (float)frame.brightness, (float)frame.brightness, (float)frame.alpha);
        int texture = display.texture();
        if (texture == -1) {
            return;
        }
        RenderSystem.m_69396_((int)texture);
        RenderSystem.m_157453_((int)0, (int)texture);
        RenderSystem.m_69937_((int)3553, (int)10241, (int)9728);
        RenderSystem.m_69937_((int)3553, (int)10240, (int)9728);
        Facing facing = Facing.get((Direction)((Direction)frame.m_58900_().m_61143_((Property)BlockCreativePictureFrame.FACING)));
        AlignedBox box = frame.getBox();
        box.grow(facing.axis, 0.01f);
        BoxFace face = BoxFace.get((Facing)facing);
        pose.m_85836_();
        pose.m_85837_(0.5, 0.5, 0.5);
        pose.m_85845_(facing.rotation().m_122270_((float)Math.toRadians(-frame.rotation)));
        pose.m_85837_(-0.5, -0.5, -0.5);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder builder = tesselator.m_85915_();
        builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        Matrix4f mat = pose.m_85850_().m_85861_();
        for (BoxCorner corner : face.corners) {
            builder.m_85982_(mat, box.get(corner.x), box.get(corner.y), box.get(corner.z)).m_7421_(corner.isFacing(face.getTexU()) != frame.flipX ? 1.0f : 0.0f, corner.isFacing(face.getTexV()) != frame.flipY ? 1.0f : 0.0f).m_5752_();
        }
        tesselator.m_85914_();
        if (frame.bothSides) {
            builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
            for (int i = face.corners.length - 1; i >= 0; --i) {
                BoxCorner corner = face.corners[i];
                builder.m_85982_(mat, box.get(corner.x), box.get(corner.y), box.get(corner.z)).m_7421_(corner.isFacing(face.getTexU()) != frame.flipX ? 1.0f : 0.0f, corner.isFacing(face.getTexV()) != frame.flipY ? 1.0f : 0.0f).m_5752_();
            }
            tesselator.m_85914_();
        }
        pose.m_85849_();
    }
}

