/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littleframes.client.gui;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import team.creative.creativecore.common.gui.controls.simple.GuiButton;
import team.creative.creativecore.common.gui.controls.simple.GuiTextfield;
import team.creative.creativecore.common.gui.style.GuiStyle;
import team.creative.creativecore.common.gui.style.display.StyleDisplay;
import team.creative.creativecore.common.util.text.TextBuilder;
import team.creative.littleframes.LittleFrames;
import team.creative.littleframes.client.gui.GuiWarningStyles;

public class GuiUrlTextfield
extends GuiTextfield {
    private GuiButton saveButton;

    public GuiUrlTextfield(GuiButton saveButton, String name, String text) {
        super(name, text);
        this.saveButton = saveButton;
    }

    public StyleDisplay getBorder(GuiStyle style, StyleDisplay display) {
        if (!this.canUse(true)) {
            return LittleFrames.CONFIG.whitelistEnabled ? GuiWarningStyles.DISABLED_BORDER : GuiWarningStyles.WARNING_BORDER;
        }
        return super.getBorder(style, display);
    }

    public StyleDisplay getBackground(GuiStyle style, StyleDisplay display) {
        if (!this.canUse(true)) {
            return LittleFrames.CONFIG.whitelistEnabled ? GuiWarningStyles.DISABLED_BACKGROUND : GuiWarningStyles.WARNING_BACKGROUND;
        }
        return super.getBackground(style, display);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        boolean pressed = super.keyPressed(keyCode, scanCode, modifiers);
        this.saveButton.setEnabled(this.canUse(false));
        return pressed;
    }

    public List<Component> getTooltip() {
        if (!this.canUse(false)) {
            return new TextBuilder().text("" + ChatFormatting.RED + ChatFormatting.BOLD).translate("label.littleframes.not_whitelisted.name").build();
        }
        if (!this.canUse(true)) {
            return new TextBuilder().text("" + ChatFormatting.GOLD).translate("label.littleframes.whitelist_warning.name").build();
        }
        return null;
    }

    protected boolean canUse(boolean ignoreToggle) {
        return LittleFrames.CONFIG.canUse(this.getPlayer(), this.getText(), ignoreToggle);
    }
}

