/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littleframes.client.texture;

import com.madgag.gif.fmsware.GifDecoder;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import net.minecraft.client.Minecraft;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import team.creative.littleframes.LittleFrames;
import team.creative.littleframes.client.texture.TextureCache;
import team.creative.littleframes.client.texture.TextureStorage;

public class TextureSeeker
extends Thread {
    public static final Logger LOGGER = LogManager.getLogger(LittleFrames.class);
    public static final TextureStorage TEXTURE_STORAGE = new TextureStorage();
    public static final DateFormat FORMAT = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z");
    public static final Object LOCK = new Object();
    public static final int MAXIMUM_ACTIVE_DOWNLOADS = 5;
    public static int activeDownloads = 0;
    private static final Minecraft mc = Minecraft.m_91087_();
    private TextureCache cache;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TextureSeeker(TextureCache cache) {
        this.cache = cache;
        Object object = LOCK;
        synchronized (object) {
            ++activeDownloads;
        }
        this.setName("OPF Download \"" + cache.url + "\"");
        this.setDaemon(true);
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Exception exception = null;
        boolean isVideo = false;
        boolean processed = false;
        try {
            ByteArrayInputStream in;
            block26: {
                byte[] data = TextureSeeker.load(this.cache.url);
                String type = TextureSeeker.readType(data);
                in = null;
                try {
                    in = new ByteArrayInputStream(data);
                    if (type != null && type.equalsIgnoreCase("gif")) {
                        GifDecoder gif = new GifDecoder();
                        int status = gif.read(in);
                        if (status == 0) {
                            mc.m_18709_(() -> this.cache.process(gif));
                            processed = true;
                        } else {
                            LOGGER.error("Failed to read gif: {}", (Object)status);
                        }
                        break block26;
                    }
                    try {
                        BufferedImage image = ImageIO.read(in);
                        if (image != null) {
                            mc.m_18709_(() -> this.cache.process(image));
                            processed = true;
                        }
                    }
                    catch (IOException e1) {
                        exception = e1;
                        LOGGER.error("Failed to parse BufferedImage from stream", (Throwable)e1);
                    }
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(in);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((InputStream)in);
        }
        catch (FoundVideoException e) {
            if (LittleFrames.CONFIG.useVLC) {
                this.cache.processVideo();
                isVideo = true;
            } else {
                exception = e;
            }
        }
        catch (NoConnectionException e) {
            exception = e;
        }
        catch (Exception e) {
            exception = e;
            LOGGER.error("An exception occurred while loading LittleFrames image", (Throwable)e);
        }
        if (!isVideo && !processed) {
            if (exception == null) {
                this.cache.processFailed("download.exception.gif");
            } else if (exception instanceof FoundVideoException) {
                this.cache.processFailed("No image found");
            } else if (exception.getMessage().startsWith("Server returned HTTP response code: 403")) {
                this.cache.processFailed("download.exception.forbidden");
            } else if (exception.getMessage().startsWith("Server returned HTTP response code: 404")) {
                this.cache.processFailed("download.exception.notfound");
            } else {
                this.cache.processFailed("download.exception.invalid");
            }
            TEXTURE_STORAGE.deleteEntry(this.cache.url);
        }
        Object object = LOCK;
        synchronized (object) {
            --activeDownloads;
        }
    }

    /*
     * Exception decompiling
     */
    public static byte[] load(String url) throws IOException, FoundVideoException, NoConnectionException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [12[CATCHBLOCK], 1[TRYBLOCK], 0[TRYBLOCK]], but top level block is 7[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static String readType(byte[] input) throws IOException {
        String string;
        ByteArrayInputStream in = null;
        try {
            in = new ByteArrayInputStream(input);
            string = TextureSeeker.readType(in);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(in);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)in);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readType(InputStream input) throws IOException {
        ImageInputStream stream = ImageIO.createImageInputStream(input);
        Iterator<ImageReader> iter = ImageIO.getImageReaders(stream);
        if (!iter.hasNext()) {
            return null;
        }
        ImageReader reader = iter.next();
        if (reader.getFormatName().equalsIgnoreCase("gif")) {
            return "gif";
        }
        ImageReadParam param = reader.getDefaultReadParam();
        reader.setInput(stream, true, true);
        try {
            reader.read(0, param);
        }
        catch (IOException e) {
            LOGGER.error("Failed to parse input format", (Throwable)e);
        }
        finally {
            reader.dispose();
            IOUtils.closeQuietly((Closeable)stream);
        }
        input.reset();
        return reader.getFormatName();
    }

    public static class FoundVideoException
    extends Exception {
    }

    public static class NoConnectionException
    extends Exception {
        public NoConnectionException() {
            super("");
        }
    }
}

