/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littleframes.common.structure;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import team.creative.creativecore.common.gui.creator.GuiCreator;
import team.creative.creativecore.common.network.CreativePacket;
import team.creative.creativecore.common.util.math.base.Axis;
import team.creative.creativecore.common.util.math.base.Facing;
import team.creative.creativecore.common.util.math.box.AlignedBox;
import team.creative.creativecore.common.util.math.box.BoxCorner;
import team.creative.creativecore.common.util.math.box.BoxFace;
import team.creative.creativecore.common.util.math.vec.Vec3d;
import team.creative.creativecore.common.util.math.vec.VectorUtils;
import team.creative.littleframes.LittleFrames;
import team.creative.littleframes.client.display.FrameDisplay;
import team.creative.littleframes.client.gui.GuiLittlePictureFrame;
import team.creative.littleframes.client.texture.TextureCache;
import team.creative.littleframes.common.block.BECreativePictureFrame;
import team.creative.littleframes.common.packet.LittlePictureFramePacket;
import team.creative.littletiles.common.block.little.tile.LittleTileContext;
import team.creative.littletiles.common.block.little.tile.parent.IStructureParentCollection;
import team.creative.littletiles.common.gui.handler.LittleStructureGuiCreator;
import team.creative.littletiles.common.structure.LittleStructure;
import team.creative.littletiles.common.structure.LittleStructureType;
import team.creative.littletiles.common.structure.directional.StructureDirectional;
import team.creative.littletiles.common.structure.relative.StructureRelative;

public class LittlePictureFrame
extends LittleStructure {
    public static final LittleStructureGuiCreator GUI = (LittleStructureGuiCreator)GuiCreator.register((String)"little_frame", (GuiCreator)new LittleStructureGuiCreator((nbt, player, structure) -> new GuiLittlePictureFrame((LittlePictureFrame)((Object)structure))));
    @StructureDirectional(color=0xFF0001)
    public StructureRelative frame;
    @StructureDirectional
    public Facing facing;
    @StructureDirectional
    public Vector3f topRight;
    private String url = "";
    public float brightness = 1.0f;
    public float alpha = 1.0f;
    public int renderDistance = 64;
    public FitMode fitMode = FitMode.CROP;
    public float volume = 1.0f;
    public float minDistance = 5.0f;
    public float maxDistance = 20.0f;
    public boolean loop = true;
    public int tick = 0;
    public boolean playing = true;
    @OnlyIn(value=Dist.CLIENT)
    public TextureCache cache;
    @OnlyIn(value=Dist.CLIENT)
    public FrameDisplay display;

    public LittlePictureFrame(LittleStructureType type, IStructureParentCollection mainBlock) {
        super(type, mainBlock);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isURLEmpty() {
        return this.url.isEmpty();
    }

    @OnlyIn(value=Dist.CLIENT)
    public String getURL() {
        return BECreativePictureFrame.replaceVariables(this.url);
    }

    public String getRealURL() {
        return this.url;
    }

    public void setURL(String url) {
        this.url = url;
    }

    @OnlyIn(value=Dist.CLIENT)
    public FrameDisplay requestDisplay() {
        String url = this.getURL();
        if (this.cache == null || !this.cache.url.equals(url)) {
            this.cache = TextureCache.get(url);
            if (this.display != null) {
                this.display.release();
            }
            this.display = null;
        }
        if (!(this.cache.isVideo() || this.cache.ready() && this.cache.getError() == null)) {
            return null;
        }
        if (this.display != null) {
            return this.display;
        }
        this.display = this.cache.createDisplay(new Vec3d((Vec3i)this.getPos()), url, this.volume, this.minDistance, this.maxDistance, this.loop);
        return this.display;
    }

    public void play() {
        this.playing = true;
        LittleFrames.NETWORK.sendToClient((CreativePacket)new LittlePictureFramePacket(this.getStructureLocation(), this.playing, this.tick), this.getLevel(), this.getPos());
    }

    public void pause() {
        this.playing = false;
        LittleFrames.NETWORK.sendToClient((CreativePacket)new LittlePictureFramePacket(this.getStructureLocation(), this.playing, this.tick), this.getLevel(), this.getPos());
    }

    public void stop() {
        this.playing = false;
        this.tick = 0;
        LittleFrames.NETWORK.sendToClient((CreativePacket)new LittlePictureFramePacket(this.getStructureLocation(), this.playing, this.tick), this.getLevel(), this.getPos());
    }

    protected void loadExtra(CompoundTag nbt) {
        this.url = nbt.m_128461_("url");
        this.renderDistance = nbt.m_128441_("render") ? nbt.m_128451_("render") : 64;
        this.alpha = nbt.m_128441_("alpha") ? nbt.m_128457_("alpha") : 1.0f;
        this.brightness = nbt.m_128441_("brightness") ? nbt.m_128457_("brightness") : 1.0f;
        this.volume = nbt.m_128457_("volume");
        this.minDistance = nbt.m_128441_("min") ? nbt.m_128457_("min") : 5.0f;
        this.maxDistance = nbt.m_128441_("max") ? nbt.m_128457_("max") : 20.0f;
        this.playing = nbt.m_128471_("playing");
        this.tick = nbt.m_128451_("tick");
        this.loop = nbt.m_128471_("loop");
        this.fitMode = FitMode.values()[nbt.m_128451_("fitMode")];
    }

    protected void saveExtra(CompoundTag nbt) {
        nbt.m_128359_("url", this.url);
        nbt.m_128405_("render", this.renderDistance);
        nbt.m_128350_("alpha", this.alpha);
        nbt.m_128350_("brightness", this.brightness);
        nbt.m_128350_("volume", this.volume);
        nbt.m_128350_("min", this.minDistance);
        nbt.m_128350_("max", this.maxDistance);
        nbt.m_128379_("playing", this.playing);
        nbt.m_128405_("tick", this.tick);
        nbt.m_128379_("loop", this.loop);
        nbt.m_128405_("fitMode", this.fitMode.ordinal());
    }

    public boolean canInteract() {
        return true;
    }

    public InteractionResult use(Level level, LittleTileContext context, BlockPos pos, Player player, BlockHitResult result) {
        GUI.open(player, (LittleStructure)this);
        return InteractionResult.SUCCESS;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderTick(PoseStack pose, MultiBufferSource buffer, BlockPos pos, float partialTickTime) {
        if (this.isURLEmpty() || this.alpha == 0.0f) {
            if (this.display != null) {
                this.display.release();
            }
            return;
        }
        FrameDisplay display = this.requestDisplay();
        if (display == null) {
            return;
        }
        display.prepare(this.getURL(), this.volume * Minecraft.m_91087_().f_91066_.m_92147_(SoundSource.MASTER), this.minDistance, this.maxDistance, this.playing, this.loop, this.tick);
        RenderSystem.m_69482_();
        RenderSystem.m_69478_();
        RenderSystem.m_69408_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.m_157429_((float)this.brightness, (float)this.brightness, (float)this.brightness, (float)this.alpha);
        int texture = display.texture();
        RenderSystem.m_69396_((int)texture);
        RenderSystem.m_157453_((int)0, (int)texture);
        RenderSystem.m_69937_((int)3553, (int)10241, (int)9728);
        RenderSystem.m_69937_((int)3553, (int)10240, (int)9728);
        AlignedBox box = this.frame.getBox().getBox(this.frame.getGrid());
        BoxFace face = BoxFace.get((Facing)this.facing);
        if (this.facing.positive) {
            box.setMax(this.facing.axis, box.getMin(this.facing.axis) + 0.01f);
        } else {
            box.setMin(this.facing.axis, box.getMax(this.facing.axis) - 0.01f);
        }
        Axis uAxis = face.getTexUAxis();
        Axis vAxis = face.getTexVAxis();
        if (this.fitMode == FitMode.CROP) {
            float videoRatio;
            float height;
            float width = box.getSize(uAxis);
            float ratio = width / (height = box.getSize(vAxis));
            if (ratio > (videoRatio = (float)display.getWidth() / (float)display.getHeight())) {
                box.shrink(uAxis, width - height * videoRatio);
            } else if (ratio < videoRatio) {
                box.shrink(vAxis, height - width / videoRatio);
            }
        }
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder builder = tesselator.m_85915_();
        builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        Matrix4f mat = pose.m_85850_().m_85861_();
        for (BoxCorner corner : face.corners) {
            builder.m_85982_(mat, box.get(corner.x), box.get(corner.y), box.get(corner.z)).m_7421_(corner.isFacingPositive(uAxis) != VectorUtils.get((Axis)uAxis, (Vector3f)this.topRight) > 0.0f ? 1.0f : 0.0f, corner.isFacingPositive(vAxis) != VectorUtils.get((Axis)vAxis, (Vector3f)this.topRight) > 0.0f ? 1.0f : 0.0f).m_5752_();
        }
        tesselator.m_85914_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public double getMaxRenderDistance() {
        return this.renderDistance;
    }

    @OnlyIn(value=Dist.CLIENT)
    public AABB getRenderBoundingBox() {
        return this.frame.getBox().getBB(this.frame.getGrid());
    }

    public void tick() {
        FrameDisplay display;
        super.tick();
        if (this.isClient() && (display = this.requestDisplay()) != null) {
            display.tick(this.url, this.volume, this.minDistance, this.maxDistance, this.playing, this.loop, this.tick);
        }
        if (this.playing) {
            ++this.tick;
        }
    }

    public void unload() {
        super.unload();
        if (this.getLevel().f_46443_ && this.display != null) {
            this.display.release();
        }
    }

    public static enum FitMode {
        CROP,
        STRETCH;

    }
}

