/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.factory;

import java.util.ArrayList;
import java.util.List;
import uk.co.caprica.vlcj.binding.internal.libvlc_audio_output_t;
import uk.co.caprica.vlcj.binding.lib.LibVlc;
import uk.co.caprica.vlcj.binding.support.strings.NativeString;
import uk.co.caprica.vlcj.factory.AudioOutput;
import uk.co.caprica.vlcj.factory.BaseApi;
import uk.co.caprica.vlcj.factory.MediaPlayerFactory;

public final class AudioApi
extends BaseApi {
    AudioApi(MediaPlayerFactory factory) {
        super(factory);
    }

    public List<AudioOutput> audioOutputs() {
        ArrayList<AudioOutput> result = new ArrayList<AudioOutput>();
        libvlc_audio_output_t audioOutputs = LibVlc.libvlc_audio_output_list_get(this.libvlcInstance);
        if (audioOutputs != null) {
            libvlc_audio_output_t audioOutput = audioOutputs;
            while (audioOutput != null) {
                String name = NativeString.copyNativeString(audioOutput.psz_name);
                String description = NativeString.copyNativeString(audioOutput.psz_description);
                result.add(new AudioOutput(name, description));
                audioOutput = audioOutput.p_next;
            }
            LibVlc.libvlc_audio_output_list_release(audioOutputs.getPointer());
        }
        return result;
    }
}

