/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.media;

import com.sun.jna.Pointer;
import uk.co.caprica.vlcj.binding.internal.libvlc_picture_t;
import uk.co.caprica.vlcj.binding.lib.LibVlc;
import uk.co.caprica.vlcj.binding.support.types.size_tByReference;
import uk.co.caprica.vlcj.media.PictureType;

public final class Picture {
    private final int width;
    private final int height;
    private final PictureType type;
    private final int stride;
    private final long time;
    private final byte[] buffer;
    private final int size;

    public Picture(libvlc_picture_t picture) {
        this.width = LibVlc.libvlc_picture_get_width(picture);
        this.height = LibVlc.libvlc_picture_get_height(picture);
        this.type = PictureType.pictureType(LibVlc.libvlc_picture_type(picture));
        this.stride = this.type == PictureType.ARGB ? LibVlc.libvlc_picture_get_stride(picture) : 0;
        this.time = LibVlc.libvlc_picture_get_time(picture);
        this.buffer = this.initBuffer(picture);
        this.size = this.buffer.length;
    }

    public Picture(int width, int height, PictureType type, int stride, long time, byte[] buffer, int size) {
        this.width = width;
        this.height = height;
        this.type = type;
        this.stride = stride;
        this.time = time;
        this.buffer = buffer;
        this.size = size;
    }

    private byte[] initBuffer(libvlc_picture_t picture) {
        size_tByReference size = new size_tByReference();
        Pointer pointer = LibVlc.libvlc_picture_get_buffer(picture, size);
        return pointer.getByteArray(0L, size.getValue().intValue());
    }

    public int width() {
        return this.width;
    }

    public int height() {
        return this.height;
    }

    public PictureType type() {
        return this.type;
    }

    public int stride() {
        return this.stride;
    }

    public long time() {
        return this.time;
    }

    public byte[] buffer() {
        return this.buffer;
    }

    public int size() {
        return this.size;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(100);
        sb.append(this.getClass().getSimpleName()).append('[');
        sb.append("width=").append(this.width).append(',');
        sb.append("height=").append(this.height).append(',');
        sb.append("type=").append((Object)this.type).append(',');
        sb.append("stride=").append(this.stride).append(',');
        sb.append("time=").append(this.time).append(',');
        sb.append("size=").append(this.size).append(']');
        return sb.toString();
    }
}

