/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.media.callback.seekable;

import java.io.File;
import java.io.IOException;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import uk.co.caprica.vlcj.media.callback.seekable.MappedByteBufferCallbackMedia;

public class FileMappedByteBufferCallbackMedia
extends MappedByteBufferCallbackMedia {
    private final Path path;
    private FileChannel fileChannel;

    public FileMappedByteBufferCallbackMedia(Path path) {
        this.path = path;
    }

    public FileMappedByteBufferCallbackMedia(File file) {
        this(file.toPath());
    }

    public FileMappedByteBufferCallbackMedia(String filename) {
        this(Paths.get(filename, new String[0]));
    }

    @Override
    protected MappedByteBuffer getBuffer() {
        try {
            this.fileChannel = (FileChannel)Files.newByteChannel(this.path, StandardOpenOption.READ);
            return this.fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, this.fileChannel.size());
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    protected void onClose() {
        try {
            this.fileChannel.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

