/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.player.base;

import uk.co.caprica.vlcj.binding.lib.LibVlc;
import uk.co.caprica.vlcj.player.base.BaseApi;
import uk.co.caprica.vlcj.player.base.MediaPlayer;
import uk.co.caprica.vlcj.player.base.MediaPlayerPlayLatch;
import uk.co.caprica.vlcj.player.base.MediaPlayerStopLatch;

public final class ControlsApi
extends BaseApi {
    private boolean repeat;

    ControlsApi(MediaPlayer mediaPlayer) {
        super(mediaPlayer);
    }

    public boolean play() {
        this.mediaPlayer.onBeforePlay();
        return LibVlc.libvlc_media_player_play(this.mediaPlayerInstance) == 0;
    }

    public boolean start() {
        return new MediaPlayerPlayLatch(this.mediaPlayer).play();
    }

    public boolean stop() {
        return new MediaPlayerStopLatch(this.mediaPlayer).stop();
    }

    public boolean stopAsync() {
        return LibVlc.libvlc_media_player_stop_async(this.mediaPlayerInstance) == 0;
    }

    public void setPause(boolean pause) {
        LibVlc.libvlc_media_player_set_pause(this.mediaPlayerInstance, pause ? 1 : 0);
    }

    public void pause() {
        LibVlc.libvlc_media_player_pause(this.mediaPlayerInstance);
    }

    public void nextFrame() {
        LibVlc.libvlc_media_player_next_frame(this.mediaPlayerInstance);
    }

    public boolean skipTime(long delta) {
        long current = this.mediaPlayer.status().time();
        if (current != -1L) {
            return this.setTime(current + delta, false);
        }
        return false;
    }

    public boolean skipPosition(double delta) {
        double current = this.mediaPlayer.status().position();
        if (current != -1.0) {
            return this.setPosition(current + delta, false);
        }
        return false;
    }

    public boolean skipTime(long delta, boolean fast) {
        long current = this.mediaPlayer.status().time();
        if (current != -1L) {
            return this.setTime(current + delta, fast);
        }
        return false;
    }

    public boolean skipPosition(double delta, boolean fast) {
        double current = this.mediaPlayer.status().position();
        if (current != -1.0) {
            return this.setPosition(current + delta, fast);
        }
        return false;
    }

    public boolean setTime(long time) {
        return this.setTime(time, false);
    }

    public boolean setPosition(double position) {
        return this.setPosition(position, false);
    }

    public boolean setTime(long time, boolean fast) {
        return LibVlc.libvlc_media_player_set_time(this.mediaPlayerInstance, Math.max(time, 0L), fast ? 1 : 0) == 0;
    }

    public boolean setPosition(double position, boolean fast) {
        return LibVlc.libvlc_media_player_set_position(this.mediaPlayerInstance, Math.max(position, 0.0), fast ? 1 : 0) == 0;
    }

    public boolean setRate(float rate) {
        return LibVlc.libvlc_media_player_set_rate(this.mediaPlayerInstance, rate) != -1;
    }

    public void setRepeat(boolean repeat) {
        this.repeat = repeat;
    }

    public boolean getRepeat() {
        return this.repeat;
    }
}

