/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.player.base;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import uk.co.caprica.vlcj.binding.lib.LibVlc;
import uk.co.caprica.vlcj.media.MediaEventListener;
import uk.co.caprica.vlcj.player.base.BaseApi;
import uk.co.caprica.vlcj.player.base.MediaPlayer;
import uk.co.caprica.vlcj.player.base.MediaPlayerEventAdapter;
import uk.co.caprica.vlcj.player.base.MediaPlayerEventListener;
import uk.co.caprica.vlcj.player.base.MediaPlayerNativeEventManager;
import uk.co.caprica.vlcj.player.base.MediaPlayerReadyEventHandler;
import uk.co.caprica.vlcj.player.base.MediaPlayerTimerListener;
import uk.co.caprica.vlcj.player.base.RepeatPlayEventHandler;
import uk.co.caprica.vlcj.player.base.events.MediaPlayerEvent;

public final class EventApi
extends BaseApi {
    private final MediaPlayerNativeEventManager eventManager;
    private final PlaybackTimeHandler playbackTimeHandler = new PlaybackTimeHandler();
    private final List<MediaPlayerTimerListener> timerListenerList = new CopyOnWriteArrayList<MediaPlayerTimerListener>();
    private final ScheduledExecutorService timerService = Executors.newSingleThreadScheduledExecutor();
    private final Runnable playbackTimerTask = () -> {
        if (this.playbackTimeHandler.playing) {
            long playbackStarted = this.playbackTimeHandler.referenceTime;
            long playbackTime = playbackStarted != 0L ? LibVlc.libvlc_clock() - playbackStarted : 0L;
            for (MediaPlayerTimerListener listener : this.timerListenerList) {
                listener.tick(this.mediaPlayer, playbackTime);
            }
        }
    };
    private long timerRate = 1000L;
    private TimeUnit timerUnit = TimeUnit.MILLISECONDS;
    private ScheduledFuture<?> timerTask;

    EventApi(MediaPlayer mediaPlayer) {
        super(mediaPlayer);
        this.eventManager = new MediaPlayerNativeEventManager(this.libvlcInstance, mediaPlayer);
        this.addMediaPlayerEventListener(new RepeatPlayEventHandler());
        this.addMediaPlayerEventListener(new MediaPlayerReadyEventHandler());
        this.addMediaPlayerEventListener(this.playbackTimeHandler);
    }

    public void addMediaPlayerEventListener(MediaPlayerEventListener listener) {
        this.eventManager.addEventListener(listener);
    }

    public void removeMediaPlayerEventListener(MediaPlayerEventListener listener) {
        this.eventManager.removeEventListener(listener);
    }

    public void addMediaEventListener(MediaEventListener listener) {
        this.mediaPlayer.media().addPersistentMediaEventListener(listener);
    }

    public void removeMediaEventListener(MediaEventListener listener) {
        this.mediaPlayer.media().removePersistentMediaEventListener(listener);
    }

    public void setTimerRate(long rate, TimeUnit unit) {
        this.timerRate = rate;
        this.timerUnit = unit;
    }

    public void addTimerListener(MediaPlayerTimerListener listener) {
        this.timerListenerList.add(listener);
        if (this.timerTask == null) {
            this.timerTask = this.timerService.scheduleAtFixedRate(this.playbackTimerTask, 0L, this.timerRate, this.timerUnit);
        }
    }

    public void removeTimerListener(MediaPlayerTimerListener listener) {
        this.timerListenerList.remove(listener);
        if (this.timerListenerList.isEmpty()) {
            this.timerTask.cancel(true);
            this.timerTask = null;
        }
    }

    void raiseEvent(MediaPlayerEvent event) {
        this.eventManager.raiseEvent(event);
    }

    @Override
    protected void release() {
        this.eventManager.release();
        this.timerListenerList.clear();
        if (this.timerTask != null) {
            this.timerTask.cancel(true);
        }
        this.timerService.shutdown();
    }

    private static class PlaybackTimeHandler
    extends MediaPlayerEventAdapter {
        private volatile long referenceTime;
        private volatile boolean playing;

        private PlaybackTimeHandler() {
        }

        @Override
        public void playing(MediaPlayer mediaPlayer) {
            this.referenceTime = LibVlc.libvlc_clock();
            this.playing = true;
        }

        @Override
        public void paused(MediaPlayer mediaPlayer) {
            this.playing = false;
        }

        @Override
        public void stopped(MediaPlayer mediaPlayer) {
            this.referenceTime = 0L;
            this.playing = false;
        }

        @Override
        public void stopping(MediaPlayer mediaPlayer) {
            this.referenceTime = 0L;
            this.playing = false;
        }

        @Override
        public void timeChanged(MediaPlayer mediaPlayer, long newTime) {
            this.referenceTime = LibVlc.libvlc_clock() - newTime * 1000L;
        }

        @Override
        public void error(MediaPlayer mediaPlayer) {
            this.referenceTime = 0L;
            this.playing = false;
        }
    }
}

