/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.player.base;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import uk.co.caprica.vlcj.binding.internal.libvlc_player_program_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_player_programlist_t;
import uk.co.caprica.vlcj.binding.lib.LibVlc;
import uk.co.caprica.vlcj.binding.support.types.size_t;
import uk.co.caprica.vlcj.player.base.BaseApi;
import uk.co.caprica.vlcj.player.base.MediaPlayer;
import uk.co.caprica.vlcj.player.base.Program;

public final class ProgramApi
extends BaseApi {
    ProgramApi(MediaPlayer mediaPlayer) {
        super(mediaPlayer);
    }

    public List<Program> list() {
        libvlc_player_programlist_t programList = LibVlc.libvlc_media_player_get_programlist(this.mediaPlayerInstance);
        if (programList != null) {
            int count = LibVlc.libvlc_player_programlist_count(programList).intValue();
            ArrayList<Program> result = new ArrayList<Program>(count);
            for (int i = 0; i < count; ++i) {
                libvlc_player_program_t programInstance = LibVlc.libvlc_player_programlist_at(programList, new size_t(i));
                result.add(new Program(programInstance));
            }
            LibVlc.libvlc_player_programlist_delete(programList);
            return result;
        }
        return Collections.emptyList();
    }

    public void select(int programId) {
        LibVlc.libvlc_media_player_select_program_id(this.mediaPlayerInstance, programId);
    }

    public Program selected() {
        libvlc_player_program_t programInstance = LibVlc.libvlc_media_player_get_selected_program(this.mediaPlayerInstance);
        return ProgramApi.convertAndFree(programInstance);
    }

    public Program get(int programId) {
        libvlc_player_program_t programInstance = LibVlc.libvlc_media_player_get_program_from_id(this.mediaPlayerInstance, programId);
        return ProgramApi.convertAndFree(programInstance);
    }

    private static Program convertAndFree(libvlc_player_program_t programInstance) {
        if (programInstance != null) {
            Program program = new Program(programInstance);
            LibVlc.libvlc_player_program_delete(programInstance);
            return program;
        }
        return null;
    }
}

