/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.player.base;

import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.ptr.PointerByReference;
import java.util.ArrayList;
import java.util.List;
import uk.co.caprica.vlcj.binding.internal.libvlc_title_description_t;
import uk.co.caprica.vlcj.binding.lib.LibVlc;
import uk.co.caprica.vlcj.binding.support.strings.NativeString;
import uk.co.caprica.vlcj.player.base.BaseApi;
import uk.co.caprica.vlcj.player.base.MediaPlayer;
import uk.co.caprica.vlcj.player.base.TitleDescription;

public final class TitleApi
extends BaseApi {
    TitleApi(MediaPlayer mediaPlayer) {
        super(mediaPlayer);
    }

    public int titleCount() {
        return LibVlc.libvlc_media_player_get_title_count(this.mediaPlayerInstance);
    }

    public int title() {
        return LibVlc.libvlc_media_player_get_title(this.mediaPlayerInstance);
    }

    public void setTitle(int title) {
        LibVlc.libvlc_media_player_set_title(this.mediaPlayerInstance, title);
    }

    public List<TitleDescription> titleDescriptions() {
        ArrayList<TitleDescription> result;
        PointerByReference titles = new PointerByReference();
        int titleCount = LibVlc.libvlc_media_player_get_full_title_descriptions(this.mediaPlayerInstance, titles);
        if (titleCount != -1) {
            Pointer[] pointers;
            result = new ArrayList<TitleDescription>(titleCount);
            for (Pointer pointer : pointers = titles.getValue().getPointerArray(0L, titleCount)) {
                libvlc_title_description_t titleDescription = (libvlc_title_description_t)Structure.newInstance(libvlc_title_description_t.class, (Pointer)pointer);
                titleDescription.read();
                result.add(new TitleDescription(titleDescription.i_duration, NativeString.copyNativeString(titleDescription.psz_name), titleDescription.i_flags));
            }
            LibVlc.libvlc_title_descriptions_release(titles.getValue(), titleCount);
        } else {
            result = new ArrayList(0);
        }
        return result;
    }
}

