/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.player.base;

import uk.co.caprica.vlcj.binding.internal.libvlc_media_track_t;
import uk.co.caprica.vlcj.binding.lib.LibVlc;
import uk.co.caprica.vlcj.binding.support.strings.NativeString;
import uk.co.caprica.vlcj.media.TrackType;

public abstract class Track {
    private final TrackType trackType;
    private final libvlc_media_track_t instance;
    private final int codec;
    private final String codecName;
    private final int originalCodec;
    private final String originalCodecName;
    private final int id;
    private final int profile;
    private final int level;
    private final int bitRate;
    private final String language;
    private final String description;
    private final String trackId;
    private final boolean stable;
    private final String name;
    private final boolean selected;
    private final String codecDescription;

    protected Track(TrackType trackType, libvlc_media_track_t instance) {
        this.trackType = trackType;
        this.instance = instance;
        this.codec = instance.i_codec;
        this.codecName = Track.codecName(this.codec);
        this.originalCodec = instance.i_original_fourcc;
        this.originalCodecName = Track.codecName(this.originalCodec);
        this.id = instance.i_id;
        this.profile = instance.i_profile;
        this.level = instance.i_level;
        this.bitRate = instance.i_bitrate;
        this.language = NativeString.copyNativeString(instance.psz_language);
        this.description = NativeString.copyNativeString(instance.psz_description);
        this.trackId = NativeString.copyNativeString(instance.psz_id);
        this.stable = instance.id_stable != 0;
        this.name = NativeString.copyNativeString(instance.psz_name);
        this.selected = instance.selected != 0;
        this.codecDescription = Track.codecDescription(instance.i_type, instance.i_codec);
    }

    public final TrackType trackType() {
        return this.trackType;
    }

    public final libvlc_media_track_t instance() {
        return this.instance;
    }

    public final int codec() {
        return this.codec;
    }

    public final String codecName() {
        return this.codecName;
    }

    public final int orignalCodec() {
        return this.codec;
    }

    public final String originalCodecName() {
        return this.originalCodecName;
    }

    public final int id() {
        return this.id;
    }

    public final int profile() {
        return this.profile;
    }

    public final int level() {
        return this.level;
    }

    public final int bitRate() {
        return this.bitRate;
    }

    public final String language() {
        return this.language;
    }

    public final String description() {
        return this.description;
    }

    public final String trackId() {
        return this.trackId;
    }

    public final boolean stable() {
        return this.stable;
    }

    public final String name() {
        return this.name;
    }

    public final boolean selected() {
        return this.selected;
    }

    public final String codecDescription() {
        return this.codecDescription;
    }

    public final void release() {
        LibVlc.libvlc_media_track_release(this.instance);
    }

    public final void hold() {
        LibVlc.libvlc_media_track_hold(this.instance);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(100);
        sb.append(this.getClass().getSimpleName()).append('[');
        sb.append("trackType=").append((Object)this.trackType).append(',');
        sb.append("codec=0x").append(Integer.toHexString(this.codec)).append(',');
        sb.append("codecName=").append(this.codecName).append(',');
        sb.append("originalCodec=0x").append(Integer.toHexString(this.originalCodec)).append(',');
        sb.append("originalCodecName=").append(this.originalCodecName).append(',');
        sb.append("id=").append(this.id).append(',');
        sb.append("profile=").append(this.profile).append(',');
        sb.append("level=").append(this.level).append(',');
        sb.append("bitRate=").append(this.bitRate).append(',');
        sb.append("language=").append(this.language).append(',');
        sb.append("description=").append(this.description).append(',');
        sb.append("trackId=").append(this.trackId).append(',');
        sb.append("stable=").append(this.stable).append(',');
        sb.append("name=").append(this.name).append(',');
        sb.append("selected=").append(this.selected).append(',');
        sb.append("codecDescription=").append(this.codecDescription).append(']');
        return sb.toString();
    }

    private static String codecName(int codec) {
        return codec != 0 ? new String(new byte[]{(byte)codec, (byte)(codec >>> 8), (byte)(codec >>> 16), (byte)(codec >>> 24)}).trim() : null;
    }

    private static String codecDescription(int type, int codec) {
        return LibVlc.libvlc_media_get_codec_description(type, codec);
    }
}

